/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.food.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.delivery.modelo.Entregador;
import br.com.maximasolutions.food.service.EntregadorService;
import br.com.maximasolutions.food.validator.EntregadorValidator;
import br.com.maximasolutions.utils.MaximaMask;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class EntregadorFormController
extends MaximaController
implements Initializable {
    private Entregador entregador;
    @Autowired
    EntregadorService entregadorService;
    @Lazy
    @Autowired
    StageManager stageManager;
    @FXML
    TextField tfId;
    @FXML
    TextField tfNome;
    @FXML
    TextField tfTelefone;
    @FXML
    TextField tfCpf;
    @FXML
    TextField tfPlaca;
    @FXML
    CheckBox cbAtivo;
    @FXML
    Button btnSalva;

    public void initialize(URL url, ResourceBundle rb) {
        this.setMascaras();
        this.registraAcoes();
    }

    public void inicializa() {
        this.entregador = null;
    }

    private void setForm() {
        if (this.entregador == null) {
            return;
        }
        this.tfId.setText(this.entregador.getId().toString());
        this.tfNome.setText(this.entregador.getNome());
        this.tfCpf.setText(this.entregador.getCpf());
        this.tfPlaca.setText(this.entregador.getPlaca().toUpperCase());
        this.cbAtivo.setSelected(this.entregador.getAtivo().booleanValue());
        this.tfTelefone.setText(this.entregador.getTelefone());
    }

    private void setMascaras() {
        MaximaMask.cpfField((TextField)this.tfCpf);
        MaximaMask.placaField((TextField)this.tfPlaca);
    }

    public void inicializa(Entregador entregador1) {
        this.entregador = entregador1;
        if (this.entregador != null) {
            if (this.entregador.getId() != null) {
                this.entregador = (Entregador)this.entregadorService.find(this.entregador.getId());
            }
            this.setForm();
        }
    }

    private Entregador getEntregador() {
        if (this.entregador == null) {
            this.entregador = new Entregador();
        }
        if (this.tfId.getText() != null && !this.tfId.getText().isEmpty()) {
            this.entregador.setId(Long.valueOf(Long.parseLong(this.tfId.getText())));
        }
        this.entregador.setNome(this.tfNome.getText().trim());
        this.entregador.setTelefone(this.tfTelefone.getText().trim());
        this.entregador.setCpf(this.tfCpf.getText().trim());
        this.entregador.setPlaca(this.tfPlaca.getText().trim().toUpperCase());
        this.entregador.setAtivo(Boolean.valueOf(this.cbAtivo.isSelected()));
        return this.entregador;
    }

    public void salva() {
        this.entregador = this.getEntregador();
        String mensagemError = "";
        if (!mensagemError.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)mensagemError);
            return;
        }
        if (EntregadorValidator.isValid((Node[])new Node[]{this.tfNome, this.tfTelefone, this.tfCpf})) {
            this.entregadorService.save((Object)this.entregador);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Entregador salvo com sucesso.");
            Stage stage = (Stage)this.btnSalva.getScene().getWindow();
            stage.close();
        } else {
            System.out.println("Erro ao validar Entregador");
        }
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.salva());
    }
}

