/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.food.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.AES;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.food.modelo.Garcon;
import br.com.maximasolutions.food.service.GarcomService;
import br.com.maximasolutions.food.validator.GarcomValidator;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class GarcomFormController
extends MaximaController
implements Initializable {
    private Garcon garcom;
    @Autowired
    GarcomService garcomService;
    @Lazy
    @Autowired
    StageManager stageManager;
    @FXML
    TextField tfId;
    @FXML
    TextField tfNome;
    @FXML
    TextField tfTelefone;
    @FXML
    TextField tfLogin;
    @FXML
    TextField tfSenha;
    @FXML
    CheckBox cbAtivo;
    @FXML
    Button btnSalva;

    public void initialize(URL url, ResourceBundle rb) {
        this.registraAcoes();
    }

    private void setForm() {
        if (this.garcom == null) {
            return;
        }
        this.tfId.setText(this.garcom.getId().toString());
        this.tfNome.setText(this.garcom.getNome());
        this.cbAtivo.setSelected(this.garcom.getAtivo().booleanValue());
        this.tfLogin.setText(this.garcom.getLogin());
        this.tfSenha.setText(AES.decrypt((String)this.garcom.getSenha(), (String)"maxima6459"));
        this.tfTelefone.setText(this.garcom.getTelefone());
    }

    public void inicializa(Garcon garcom1) {
        this.garcom = garcom1;
        if (this.garcom != null) {
            if (this.garcom.getId() != null) {
                this.garcom = (Garcon)this.garcomService.find(this.garcom.getId());
            }
            this.setForm();
        }
    }

    private Garcon getGarcom() {
        if (this.garcom == null) {
            this.garcom = new Garcon();
        }
        if (this.tfId.getText() != null && !this.tfId.getText().isEmpty()) {
            this.garcom.setId(Long.valueOf(Long.parseLong(this.tfId.getText())));
        }
        this.garcom.setNome(this.tfNome.getText().trim());
        this.garcom.setLogin(this.tfLogin.getText().trim());
        this.garcom.setSenha(this.tfSenha.getText().trim());
        this.garcom.setTelefone(this.tfTelefone.getText().trim());
        this.garcom.setAtivo(Boolean.valueOf(this.cbAtivo.isSelected()));
        return this.garcom;
    }

    private void fecha() {
        Stage stage = (Stage)this.btnSalva.getScene().getWindow();
        stage.close();
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.garcom.getNome() == null || this.garcom.getNome().isEmpty()) {
            valido = false;
            this.tfNome.getStyleClass().add((Object)"error");
        } else {
            this.tfNome.getStyleClass().remove((Object)"error");
        }
        if (this.garcom.getLogin() == null || this.garcom.getLogin().isEmpty()) {
            valido = false;
            this.tfLogin.getStyleClass().add((Object)"error");
        } else {
            this.tfLogin.getStyleClass().remove((Object)"error");
        }
        if (this.garcom.getSenha() == null || this.garcom.getSenha().isEmpty()) {
            valido = false;
            this.tfSenha.getStyleClass().add((Object)"error");
        } else {
            this.tfSenha.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    public void salva() {
        this.garcom = this.getGarcom();
        String mensagemError = "";
        if (!mensagemError.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)mensagemError);
            return;
        }
        if (GarcomValidator.isValid((Node[])new Node[]{this.tfNome, this.tfTelefone, this.tfLogin, this.tfSenha})) {
            this.garcom.setSenha(AES.encrypt((String)this.tfSenha.getText(), (String)"maxima6459"));
            this.garcomService.save((Object)this.garcom);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Gar\u00e7om salvo com sucesso.");
            Stage stage = (Stage)this.btnSalva.getScene().getWindow();
            stage.close();
        } else {
            System.out.println("Erro ao validar Emitente");
        }
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.salva());
    }
}

