/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.food.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.estoque.form.CategoriaProdutoForm;
import br.com.maximasolutions.estoque.form.ProdutoComplementoForm;
import br.com.maximasolutions.estoque.form.ProdutoForm;
import br.com.maximasolutions.estoque.form.UnidadeForm;
import br.com.maximasolutions.estoque.service.CategoriaProdutoService;
import br.com.maximasolutions.estoque.service.ProdutoComplementoService;
import br.com.maximasolutions.estoque.service.ProdutoService;
import br.com.maximasolutions.estoque.service.UnidadeService;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class SincronizaFoodController
extends MaximaController
implements Initializable {
    @Autowired
    @Lazy
    private StageManager stageManager;
    @Autowired
    private CategoriaProdutoService categoriaProdutoService;
    @Autowired
    private UnidadeService unidadeService;
    @Autowired
    private ProdutoService produtoService;
    @Autowired
    private ProdutoComplementoService produtoComplementoService;
    @FXML
    private Button btnSincroniza;
    private final String URI_BASE = "http://localhost:8080/maximafood/";

    public void initialize(URL url, ResourceBundle rb) {
        this.registraAcoes();
    }

    private void sincronizaDados() {
        this.sincronizaCategoriasProduto();
        this.sincronizaUnidades();
        this.sincronizaProdutos();
        this.sincronizaComplementos();
    }

    private void sincronizaComplementos() {
        List complementos = this.produtoComplementoService.listaTodos();
        complementos.forEach(complemento -> {
            ProdutoComplementoForm form = new ProdutoComplementoForm(complemento);
            String uri = "http://localhost:8080/maximafood/api/produtos/complementos";
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)new Gson().toJson((Object)form));
            Request request = new Request.Builder().url(uri).post(body).build();
            OkHttpClient client = new OkHttpClient();
            try {
                Response response = client.newCall(request).execute();
                if (response.isSuccessful()) {
                    System.out.println("== SUCESSO: " + response);
                } else {
                    System.out.println("== FALHA: " + response);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(SincronizaFoodController.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
    }

    private void sincronizaProdutos() {
        List produtos = this.produtoService.listaTodos();
        produtos.forEach(prod -> {
            ProdutoForm form = new ProdutoForm(prod);
            String uri = "http://localhost:8080/maximafood/api/produtos";
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)new Gson().toJson((Object)form));
            Request request = new Request.Builder().url(uri).post(body).build();
            OkHttpClient client = new OkHttpClient();
            try {
                Response response = client.newCall(request).execute();
                if (response.isSuccessful()) {
                    System.out.println("== SUCESSO: " + response);
                } else {
                    System.out.println("== FALHA: " + response);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(SincronizaFoodController.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
    }

    private void sincronizaUnidades() {
        List unidades = this.unidadeService.listaTodas();
        unidades.forEach(un -> {
            UnidadeForm form = new UnidadeForm(un);
            String uri = "http://localhost:8080/maximafood/api/unidades";
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)new Gson().toJson((Object)form));
            Request request = new Request.Builder().url(uri).post(body).build();
            OkHttpClient client = new OkHttpClient();
            try {
                Response response = client.newCall(request).execute();
                if (!response.isSuccessful()) return;
            }
            catch (IOException ex) {
                Logger.getLogger(SincronizaFoodController.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
    }

    private void sincronizaCategoriasProduto() {
        List categorias = this.categoriaProdutoService.listaTodas();
        categorias.forEach(cat -> {
            CategoriaProdutoForm form = new CategoriaProdutoForm(cat);
            String uri = "http://localhost:8080/maximafood/api/categorias-produtos";
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)new Gson().toJson((Object)form));
            Request request = new Request.Builder().url(uri).post(body).build();
            OkHttpClient client = new OkHttpClient();
            try {
                Response response = client.newCall(request).execute();
                if (!response.isSuccessful()) return;
            }
            catch (IOException ex) {
                Logger.getLogger(SincronizaFoodController.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
    }

    private void registraAcoes() {
        this.btnSincroniza.setOnAction(evt -> this.sincronizaDados());
    }
}

