/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.food.relatorio.controller;

import br.com.maximasolutions.Projeto;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.controller.RelatorioFormController;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.food.modelo.MesaAberta;
import br.com.maximasolutions.food.service.MesaAbertaService;
import br.com.maximasolutions.sat.modelo.SatCFe;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDate;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class RelatorioComandasCanceladasController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private MesaAbertaService mesaAbertaService;
    @FXML
    private Button btnGeraRelatorio;
    @FXML
    private DatePicker tfDataInicial;
    @FXML
    private DatePicker tfDataFinal;
    private BigDecimal total;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.loadCombos();
        this.loadMascaras();
        this.inicializa();
    }

    public void inicializa() {
    }

    private void geraRelatorio() {
        if (!this.validaForm()) {
            return;
        }
        List canceladas = this.mesaAbertaService.listaCanceladas((LocalDate)this.tfDataInicial.getValue(), (LocalDate)this.tfDataFinal.getValue());
        String conteudo = "";
        for (MesaAberta comanda : canceladas) {
            conteudo = conteudo + MaximaDate.getDataHora((LocalDateTime)comanda.getDataAbertura()) + "     Comanda: " + comanda.getComanda().getNome() + "     Valor: R$ " + MaximaNumber.formataNumero((BigDecimal)comanda.getValorTotal()) + "\n";
            conteudo = conteudo + "Cancelamento: " + MaximaDate.getDataHora((LocalDateTime)comanda.getDataCancelada()) + "     Motivo: " + comanda.getMotivoCancelamento() + "\n";
            conteudo = conteudo + MaximaUtils.completaDireita((String)"", (String)"-", (int)200) + "\n";
        }
        try {
            Stage stage = new MaximaDialogFX().createFrameVBox(this.stageManager, "/fxml/RelatorioForm.fxml", "RELAT\u00d3RIO", new String[0]);
            RelatorioFormController controller = (RelatorioFormController)stage.getUserData();
            controller.setConteudo(conteudo);
            stage.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(Projeto.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um erro ao abrir m\u00f3dulo de pedidos");
        }
    }

    private void calculaTotal(List<SatCFe> notas) {
        this.total = BigDecimal.ZERO;
        notas.stream().forEachOrdered(nfe -> {
            if (!nfe.getCancelado().booleanValue()) {
                this.total = this.total.add(nfe.getTotal());
            }
        });
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.tfDataInicial.getValue() == null) {
            this.tfDataInicial.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataInicial.getStyleClass().remove((Object)"error");
        }
        if (this.tfDataFinal.getValue() == null) {
            this.tfDataFinal.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataFinal.getStyleClass().remove((Object)"error");
        }
        if (valido) {
            if (((LocalDate)this.tfDataInicial.getValue()).isAfter((ChronoLocalDate)this.tfDataFinal.getValue())) {
                this.tfDataFinal.getStyleClass().add((Object)"error");
                valido = false;
            } else {
                this.tfDataFinal.getStyleClass().remove((Object)"error");
            }
        }
        return valido;
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnGeraRelatorio.setGraphic((Node)maximaIcone.getIconeConfirma());
    }

    private void loadMascaras() {
    }

    private void registraAcoes() {
        this.btnGeraRelatorio.setOnAction(t -> this.geraRelatorio());
    }

    private void loadCombos() {
    }
}

