/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.geral.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.geral.controller.MunicipioPesquisaController;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.modelo.Municipio;
import br.com.maximasolutions.geral.modelo.Vendedor;
import br.com.maximasolutions.geral.service.ClienteService;
import br.com.maximasolutions.geral.service.MunicipioService;
import br.com.maximasolutions.geral.service.VendedorService;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import br.com.maximasolutions.vendasexternas.controller.VendedorProdutoLancamentoFormController;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class ClienteFormController
extends MaximaController
implements Initializable {
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private MunicipioService municipioService;
    @Autowired
    private VendedorService vendedorService;
    private Cliente cliente;
    @FXML
    private CheckBox ccbAtivo;
    @FXML
    private CheckBox ccbNegativado;
    @FXML
    private CheckBox ccbTabela2;
    @FXML
    private CheckBox ccbContribuinte;
    @FXML
    private TextField tfId;
    @FXML
    private TextField tfRazaoSocial;
    @FXML
    private TextField tfNomeFantasia;
    @FXML
    private TextField tfCnpj;
    @FXML
    private TextField tfInscEstadual;
    @FXML
    private TextField tfInscMunicipal;
    @FXML
    private TextField tfEndereco;
    @FXML
    private TextField tfEnderecoNumero;
    @FXML
    private TextField tfBairro;
    @FXML
    private TextField tfCep;
    @FXML
    private TextField tfTelefone;
    @FXML
    private TextField tfTelefone2;
    @FXML
    private TextField tfComplemento;
    @FXML
    private TextField tfEmail;
    @FXML
    private TextField tfDataNascimento;
    @FXML
    private TextField tfMunicipioCodigo;
    @FXML
    private TextField tfMunicipioDescricao;
    @FXML
    private TextField tfLimiteCompras;
    @FXML
    private TextField tfVale;
    @FXML
    private TextField tfBonus;
    @FXML
    private TextField tfEnderecoEntrega;
    @FXML
    private TextField tfEnderecoNumeroEntrega;
    @FXML
    private TextField tfBairroEntrega;
    @FXML
    private TextField tfCepEntrega;
    @FXML
    private TextField tfMunicipioCodigoEntrega;
    @FXML
    private TextField tfMunicipioDescricaoEntrega;
    @FXML
    private TextField tfComplementoEntrega;
    @FXML
    private TextArea tfObservacao;
    @FXML
    private ComboBox<Vendedor> cbbVendedor;
    @FXML
    private Button btnSalva;
    @FXML
    private Button btnMunicipio;
    @FXML
    private Button btnMunicipioEntrega;
    @FXML
    private AnchorPane frame;
    @Autowired
    @Lazy
    private StageManager stageManager;
    private Municipio municipio;
    private Municipio municipioEntrega;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.loadCombos();
        this.setMascaras();
        this.registraAcoes();
    }

    public void inicializa(Cliente cliente) {
        this.municipio = null;
        this.municipioEntrega = null;
        this.cliente = null;
        if (MaximaConfig.getDeluxe().booleanValue()) {
            this.ccbTabela2.setSelected(true);
        }
        if (cliente != null) {
            this.cliente = this.clienteService.getById(cliente.getId());
            this.loadCliente(cliente);
        }
    }

    private void loadCliente(Cliente cliente) {
        if (cliente != null) {
            this.tfId.setText(cliente.getId().toString());
            this.ccbAtivo.setSelected(cliente.getAtivo().booleanValue());
            this.ccbNegativado.setSelected(cliente.isNegativado().booleanValue());
            this.tfRazaoSocial.setText(cliente.getNome());
            this.tfNomeFantasia.setText(cliente.getFantasia());
            this.tfTelefone.setText(cliente.getTelefone());
            this.tfTelefone2.setText(cliente.getCelular1());
            this.tfCnpj.setText(cliente.getCpf());
            this.tfInscEstadual.setText(cliente.getRg());
            this.tfDataNascimento.setText(cliente.getDataNascimento() == null ? "" : cliente.getDataNascimento().format(DateTimeFormatter.ofPattern("dd/MM/yyyy")));
            this.tfEndereco.setText(cliente.getEndereco());
            this.tfEnderecoNumero.setText(cliente.getNumero());
            this.tfBairro.setText(cliente.getBairro());
            this.tfComplemento.setText(cliente.getComplemento());
            this.tfCep.setText(cliente.getCep());
            this.municipio = cliente.getMunicipio();
            this.tfEmail.setText(cliente.getEmail());
            this.tfObservacao.setText(cliente.getObservacao());
            this.cbbVendedor.getSelectionModel().select((Object)cliente.getVendedor());
            this.tfMunicipioCodigo.setText(cliente.getMunicipio().getId().toString());
            this.tfMunicipioDescricao.setText(cliente.getMunicipio().getNome() + " - " + cliente.getMunicipio().getEstado().getSigla());
            this.tfLimiteCompras.setText(MaximaNumber.bigDecimalToString((BigDecimal)cliente.getLimite(), (int)2));
            this.tfVale.setText(MaximaNumber.bigDecimalToString((BigDecimal)cliente.getVale(), (int)2));
            this.tfBonus.setText(MaximaNumber.bigDecimalToString((BigDecimal)cliente.getBonus(), (int)2));
            this.tfEnderecoEntrega.setText(cliente.getEntregaEndereco());
            this.tfEnderecoNumeroEntrega.setText(cliente.getEntregaEnderecoNumero());
            this.tfBairroEntrega.setText(cliente.getEntregaEnderecoBairro());
            this.tfComplementoEntrega.setText(cliente.getEntregaEnderecoComplemento());
            this.tfCepEntrega.setText(cliente.getEntregaEnderecoCep());
            this.municipioEntrega = cliente.getEntregaMunicipio();
            if (this.municipioEntrega != null) {
                this.tfMunicipioCodigoEntrega.setText(cliente.getEntregaMunicipio().getId().toString());
                this.tfMunicipioDescricaoEntrega.setText(cliente.getEntregaMunicipio().getNome() + " - " + cliente.getEntregaMunicipio().getEstado().getSigla());
            }
            this.ccbTabela2.setSelected(cliente.getTabela2().booleanValue());
            this.ccbContribuinte.setSelected(cliente.getContribuinteIcms().booleanValue());
        }
    }

    public Cliente getCliente() {
        return this.cliente;
    }

    private void save() {
        this.loadCliente();
        if (!this.validaForm()) {
            return;
        }
        if (!this.validaModelo().booleanValue()) {
            return;
        }
        try {
            this.cliente.setSincronizado(Boolean.valueOf(false));
            this.cliente = this.clienteService.save(this.cliente);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Dados do cliente salvos com sucesso.");
            this.close();
        }
        catch (MaximaException ex) {
            Logger.getLogger(ClienteFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void loadCliente() {
        if (this.cliente == null) {
            this.cliente = new Cliente();
        }
        this.cliente.setAtivo(Boolean.valueOf(this.ccbAtivo.isSelected()));
        this.cliente.setNegativado(Boolean.valueOf(this.ccbNegativado.isSelected()));
        this.cliente.setNome(MaximaUtils.getText((String)this.tfRazaoSocial.getText()));
        this.cliente.setFantasia(MaximaUtils.getText((String)this.tfNomeFantasia.getText()));
        this.cliente.setTelefone(MaximaUtils.removeCaracteres((String)this.tfTelefone.getText()));
        this.cliente.setCelular1(MaximaUtils.removeCaracteres((String)this.tfTelefone2.getText()));
        this.cliente.setCpf(MaximaUtils.removeCaracteres((String)this.tfCnpj.getText()));
        this.cliente.setRg(MaximaUtils.removeAcentos((String)this.tfInscEstadual.getText()));
        this.cliente.setDataNascimento(MaximaDate.convertToLocalDate((String)this.tfDataNascimento.getText()));
        this.cliente.setEndereco(MaximaUtils.getText((String)this.tfEndereco.getText()));
        this.cliente.setNumero(MaximaUtils.getText((String)this.tfEnderecoNumero.getText()));
        this.cliente.setBairro(MaximaUtils.getText((String)this.tfBairro.getText()));
        this.cliente.setComplemento(MaximaUtils.getText((String)this.tfComplemento.getText()));
        this.cliente.setCep(MaximaUtils.removeCaracteres((String)this.tfCep.getText()));
        this.cliente.setMunicipio(this.municipio);
        this.cliente.setEmail(MaximaUtils.getText((String)this.tfEmail.getText()));
        this.cliente.setObservacao(this.tfObservacao.getText());
        this.cliente.setVendedor((Vendedor)this.cbbVendedor.getSelectionModel().getSelectedItem());
        this.cliente.setLimite(MaximaNumber.moneyToBigDecimal((String)this.tfLimiteCompras.getText()));
        this.cliente.setEntregaEndereco(MaximaUtils.getText((String)this.tfEnderecoEntrega.getText()));
        this.cliente.setEntregaEnderecoNumero(MaximaUtils.getText((String)this.tfEnderecoNumeroEntrega.getText()));
        this.cliente.setEntregaEnderecoBairro(MaximaUtils.getText((String)this.tfBairroEntrega.getText()));
        this.cliente.setEntregaEnderecoComplemento(MaximaUtils.getText((String)this.tfComplementoEntrega.getText()));
        this.cliente.setEntregaEnderecoCep(MaximaUtils.removeCaracteres((String)this.tfCepEntrega.getText()));
        this.cliente.setEntregaMunicipio(this.municipioEntrega);
        this.cliente.setTabela2(Boolean.valueOf(this.ccbTabela2.isSelected()));
        this.cliente.setContribuinteIcms(Boolean.valueOf(this.ccbContribuinte.isSelected()));
    }

    private void close() {
        Stage stage = (Stage)this.btnSalva.getScene().getWindow();
        stage.close();
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void loadCombos() {
        this.cbbVendedor.setItems(FXCollections.observableArrayList((Collection)this.vendedorService.list()));
    }

    private void setMascaras() {
        MaximaMask.dateField((TextField)this.tfDataNascimento);
        MaximaMask.monetaryField((TextField)this.tfLimiteCompras);
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.save());
        this.btnMunicipio.setOnAction(event -> this.pesquisaMunicipioForm());
        this.tfMunicipioCodigo.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaMunicipio();
            }
        });
        this.btnMunicipioEntrega.setOnAction(event -> this.pesquisaMunicipioFormEntrega());
        this.tfMunicipioCodigoEntrega.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaMunicipioEntrega();
            }
        });
    }

    private void pesquisaMunicipio() {
        String municipioCodigo = this.tfMunicipioCodigo.getText().trim();
        if (municipioCodigo.isEmpty()) {
            return;
        }
        try {
            Long municipioCodigoNumero = Long.valueOf(municipioCodigo);
            Municipio municipioPesquisa = this.municipioService.load(municipioCodigoNumero.longValue());
            if (municipioPesquisa != null) {
                this.municipio = municipioPesquisa;
                this.loadDadosMunicipio();
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.pesquisaMunicipioForm();
    }

    private void pesquisaMunicipioForm() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/geral/municipio/MunicipioPesquisa.fxml", "Pesquisa de cidades");
            MunicipioPesquisaController controller = (MunicipioPesquisaController)stage.getUserData();
            controller.setValorPesquisa(this.tfMunicipioCodigo.getText().trim());
            stage.showAndWait();
            Municipio municipioPesquisa = controller.getMunicipioSelecionado();
            if (municipioPesquisa != null) {
                this.municipio = municipioPesquisa;
                this.loadDadosMunicipio();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(VendedorProdutoLancamentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.alerta((String)("Ocorreu um erro ao abrir janela de pesquisa de vendedores.\n" + ex.getMessage()));
        }
    }

    private void loadDadosMunicipio() {
        if (this.municipio != null) {
            this.tfMunicipioCodigo.setText(this.municipio.getId().toString());
            this.tfMunicipioDescricao.setText(this.municipio.getNome().toUpperCase() + " - " + this.municipio.getEstado().getSigla());
            this.tfEmail.requestFocus();
        } else {
            this.tfMunicipioCodigo.setText("");
            this.tfMunicipioDescricao.setText("");
            this.tfMunicipioCodigo.requestFocus();
        }
    }

    private void pesquisaMunicipioEntrega() {
        String municipioCodigo = this.tfMunicipioCodigoEntrega.getText().trim();
        if (municipioCodigo.isEmpty()) {
            return;
        }
        try {
            Long municipioCodigoNumero = Long.valueOf(municipioCodigo);
            Municipio municipioPesquisa = this.municipioService.load(municipioCodigoNumero.longValue());
            if (municipioPesquisa != null) {
                this.municipioEntrega = municipioPesquisa;
                this.loadDadosMunicipioEntrega();
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.pesquisaMunicipioFormEntrega();
    }

    private void pesquisaMunicipioFormEntrega() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/geral/municipio/MunicipioPesquisa.fxml", "Pesquisa de cidades");
            MunicipioPesquisaController controller = (MunicipioPesquisaController)stage.getUserData();
            controller.setValorPesquisa(this.tfMunicipioCodigoEntrega.getText().trim());
            stage.showAndWait();
            Municipio municipioPesquisa = controller.getMunicipioSelecionado();
            if (municipioPesquisa != null) {
                this.municipioEntrega = municipioPesquisa;
                this.loadDadosMunicipioEntrega();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(VendedorProdutoLancamentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.alerta((String)("Ocorreu um erro ao abrir janela de pesquisa de vendedores.\n" + ex.getMessage()));
        }
    }

    private void loadDadosMunicipioEntrega() {
        if (this.municipioEntrega != null) {
            this.tfMunicipioCodigoEntrega.setText(this.municipioEntrega.getId().toString());
            this.tfMunicipioDescricaoEntrega.setText(this.municipioEntrega.getNome().toUpperCase() + " - " + this.municipioEntrega.getEstado().getSigla());
        } else {
            this.tfMunicipioCodigoEntrega.setText("");
            this.tfMunicipioDescricaoEntrega.setText("");
            this.tfMunicipioCodigoEntrega.requestFocus();
        }
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.cliente.getNome() == null || this.cliente.getNome().isEmpty()) {
            this.tfRazaoSocial.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfRazaoSocial.getStyleClass().remove((Object)"error");
        }
        if (this.cliente.getTelefone() == null || this.cliente.getTelefone().isEmpty()) {
            valido = false;
            this.tfTelefone.getStyleClass().add((Object)"error");
        } else {
            this.tfTelefone.getStyleClass().remove((Object)"error");
        }
        if (this.cliente.getMunicipio() == null) {
            valido = false;
            this.tfMunicipioCodigo.getStyleClass().add((Object)"error");
            this.tfMunicipioDescricao.getStyleClass().add((Object)"error");
        } else {
            this.tfMunicipioCodigo.getStyleClass().remove((Object)"error");
            this.tfMunicipioDescricao.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private Boolean validaModelo() {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set violations = validator.validate((Object)this.cliente, new Class[0]);
        String mensagemError = "";
        mensagemError = violations.stream().map(obj -> obj.getMessage() + "\n").reduce(mensagemError, String::concat);
        if (!mensagemError.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)mensagemError);
            return false;
        }
        return true;
    }
}

