/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.geral.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.geral.controller.ClienteFormController;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.service.ClienteService;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class ClientePesquisaController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private Button btnPesquisa;
    @FXML
    private Button btnSelecionar;
    @FXML
    private Button btnNovoCliente;
    @FXML
    private Button btnFechar;
    @FXML
    private TextField tfPesquisa;
    @FXML
    private TableView<Cliente> tabela;
    @FXML
    private TableColumn<Cliente, String> colCnpj;
    @FXML
    private TableColumn<Cliente, String> colNome;
    @FXML
    private TableColumn<Cliente, String> colEndereco;
    @FXML
    private TableColumn<Cliente, String> colCidade;
    @FXML
    private TableColumn<Cliente, String> colTelefone;
    @Autowired
    private ClienteService clienteService;
    private ObservableList<Cliente> clienteList;
    private Cliente clienteSelecionado;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.clienteList = FXCollections.observableArrayList();
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
        this.tfPesquisa.selectAll();
        this.tfPesquisa.requestFocus();
    }

    public void inicializa() {
        this.clienteSelecionado = null;
    }

    public Cliente getClienteSelecionado() {
        return this.clienteSelecionado;
    }

    public void setValorPesquisa(String valor) {
        this.tfPesquisa.setText(valor);
        this.tfPesquisa.selectAll();
        this.tfPesquisa.requestFocus();
        if (valor != null && !valor.isEmpty()) {
            this.loadTabela();
        }
    }

    private void seleciona() {
        this.clienteSelecionado = (Cliente)this.tabela.getSelectionModel().getSelectedItem();
        if (this.clienteSelecionado == null) {
            MaximaAlert.alerta((String)"Selecione um cliente para continuar.");
            return;
        }
        this.fechaForm();
    }

    private void loadTabela() {
        String valorPesquisa = this.tfPesquisa.getText().trim();
        this.clienteList.clear();
        List list = new ArrayList();
        if (!valorPesquisa.isEmpty()) {
            list = this.clienteService.pesquisa(valorPesquisa);
        }
        this.clienteList.addAll(list);
        this.tabela.setItems(this.clienteList);
    }

    private void carregaIcones() {
        this.btnSelecionar.setGraphic((Node)new MaximaIcone().getIconeConfirma());
        this.btnFechar.setGraphic((Node)new MaximaIcone().getIconeDelete());
        this.btnPesquisa.setGraphic((Node)new MaximaIcone().getPesquisa());
    }

    private void setColumnProperties() {
        this.colCnpj.setCellValueFactory((Callback)new PropertyValueFactory("cpf"));
        this.colNome.setCellValueFactory((Callback)new PropertyValueFactory("nome"));
        this.colEndereco.setCellValueFactory((Callback)new PropertyValueFactory("enderecoNumeroBairro"));
        this.colCidade.setCellValueFactory((Callback)new PropertyValueFactory("municipio"));
        this.colTelefone.setCellValueFactory((Callback)new PropertyValueFactory("telefone"));
    }

    private void novoCliente() {
        try {
            Stage formNovoCliente = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/geral/cliente/ClienteForm.fxml", "Cadastro de Cliente");
            ClienteFormController controller = (ClienteFormController)formNovoCliente.getUserData();
            controller.inicializa(null);
            formNovoCliente.showAndWait();
            if (controller.getCliente() != null) {
                this.tfPesquisa.setText(controller.getCliente().getNome());
                this.loadTabela();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ClientePesquisaController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel abrir cadstro de cliente.");
        }
    }

    private void registraAcoes() {
        this.btnNovoCliente.setOnAction(evt -> this.novoCliente());
        this.btnPesquisa.setOnAction(event -> this.loadTabela());
        this.btnFechar.setOnAction(evt -> this.fechaForm());
        this.tfPesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.loadTabela();
            }
            if (event.getCode() == KeyCode.DOWN) {
                this.tabela.requestFocus();
            }
        });
        this.btnSelecionar.setOnAction(event -> this.seleciona());
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.seleciona();
            }
        });
        this.tabela.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER && this.tabela.getSelectionModel().getSelectedItem() != null) {
                this.seleciona();
            }
        });
    }

    private void fechaForm() {
        Stage stage = (Stage)this.btnPesquisa.getScene().getWindow();
        stage.close();
    }
}

