/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.geral.controller;

import br.com.maximasolutions.administrativo.core.PermissaoControleValida;
import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.modelo.PermissaoControleAcao;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.geral.controller.EstadoFormController;
import br.com.maximasolutions.geral.modelo.Estado;
import br.com.maximasolutions.geral.service.EstadoService;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class EstadoController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private Button btnNovo;
    @FXML
    private Button btnEdita;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnPesquisa;
    @FXML
    private TextField tfPesquisa;
    @FXML
    private TableView<Estado> tabela;
    @FXML
    private TableColumn<Estado, String> colNome;
    @FXML
    private TableColumn<Estado, String> colSigla;
    @Autowired
    private EstadoService estadoService;
    @Autowired
    private UsuarioService usuarioService;
    private ObservableList<Estado> estadoList;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.estadoList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.editaEstado();
            }
        });
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
    }

    public void inicializa() {
        this.acoes = this.usuarioService.acoes(this.stageManager.getUsuario(), PermissaoControle.Estado);
    }

    private void novoEstado() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.ADD).booleanValue()) {
            return;
        }
        this.formEstado(null);
        this.loadTabela();
    }

    private void editaEstado() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.EDIT).booleanValue()) {
            return;
        }
        Estado estado = (Estado)this.tabela.getSelectionModel().getSelectedItem();
        if (estado == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um estado para editar.");
            return;
        }
        this.formEstado(estado);
        this.loadTabela();
    }

    private void formEstado(Estado estado) {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/geral/estado/EstadoForm.fxml", "Novo Estado");
            EstadoFormController controller = (EstadoFormController)stage.getUserData();
            controller.inicializa(estado);
            stage.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(EstadoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.alerta((String)("Ocorreu um erro ao abrir form estado.\n" + ex.getMessage()));
        }
    }

    private void deleteEstado() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.DELETE).booleanValue()) {
            return;
        }
        Estado estado = (Estado)this.tabela.getSelectionModel().getSelectedItem();
        if (estado == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um estado para remover.");
            return;
        }
        if (MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)("Deseja remover o estado: '" + estado.getNome() + "'?"))) {
            try {
                this.estadoService.deleteById(estado.getId());
                MaximaAlert.informe((StageManager)this.stageManager, (String)"Estado deletado com sucesso.");
                this.loadTabela();
            }
            catch (MaximaException ex) {
                Logger.getLogger(EstadoController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
            }
        }
    }

    private void loadTabela() {
        this.estadoList.clear();
        this.estadoList.addAll((Collection)this.estadoService.lista(this.tfPesquisa.getText().trim()));
        this.tabela.setItems(this.estadoList);
    }

    private void carregaIcones() {
        this.btnNovo.setGraphic((Node)new MaximaIcone().getIconeNovo());
        this.btnEdita.setGraphic((Node)new MaximaIcone().edita());
        this.btnDelete.setGraphic((Node)new MaximaIcone().getIconeDelete());
        this.btnPesquisa.setGraphic((Node)new MaximaIcone().getPesquisa());
    }

    private void setColumnProperties() {
        this.colNome.setCellValueFactory((Callback)new PropertyValueFactory("nome"));
        this.colSigla.setCellValueFactory((Callback)new PropertyValueFactory("sigla"));
    }

    private void registraAcoes() {
        this.btnNovo.setOnAction(event -> this.novoEstado());
        this.btnEdita.setOnAction(event -> this.editaEstado());
        this.btnDelete.setOnAction(event -> this.deleteEstado());
        this.btnPesquisa.setOnAction(event -> this.loadTabela());
        this.tfPesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.loadTabela();
            }
        });
    }
}

