/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.geral.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.geral.modelo.Estado;
import br.com.maximasolutions.geral.service.EstadoService;
import br.com.maximasolutions.utils.MaximaUtils;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class EstadoFormController
extends MaximaController
implements Initializable {
    @Autowired
    private EstadoService estadoService;
    private Estado estado;
    @FXML
    private TextField tfId;
    @FXML
    private TextField tfNome;
    @FXML
    private TextField tfSigla;
    @FXML
    private Button btnSalva;
    @FXML
    private AnchorPane frame;
    @Autowired
    @Lazy
    private StageManager stageManager;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.loadCombos();
        this.setMascaras();
        this.registraAcoes();
    }

    public void inicializa(Estado estado) {
        this.estado = null;
        if (estado != null) {
            this.estado = this.estadoService.load(estado.getId().longValue());
            this.loadEstado(estado);
        }
    }

    private void loadEstado(Estado estado) {
        if (estado != null) {
            this.tfId.setText(estado.getId().toString());
            this.tfNome.setText(estado.getNome());
            this.tfSigla.setText(estado.getSigla());
        }
    }

    private void save() {
        this.loadEstado();
        if (!this.validaForm()) {
            return;
        }
        if (!this.validaModelo().booleanValue()) {
            return;
        }
        try {
            this.estado = this.estadoService.save(this.estado);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Dados do estado salvos com sucesso.");
            this.close();
        }
        catch (MaximaException ex) {
            Logger.getLogger(EstadoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void loadEstado() {
        if (this.estado == null) {
            this.estado = new Estado();
        }
        this.estado.setNome(MaximaUtils.getText((String)this.tfNome.getText()));
        this.estado.setSigla(MaximaUtils.getText((String)this.tfSigla.getText()));
    }

    private void close() {
        Stage stage = (Stage)this.btnSalva.getScene().getWindow();
        stage.close();
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void loadCombos() {
    }

    private void setMascaras() {
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.save());
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.estado.getNome() == null || this.estado.getNome().isEmpty()) {
            this.tfNome.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfNome.getStyleClass().remove((Object)"error");
        }
        if (this.estado.getSigla() == null || this.estado.getSigla().isEmpty()) {
            valido = false;
            this.tfSigla.getStyleClass().add((Object)"error");
        } else {
            this.tfSigla.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private Boolean validaModelo() {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set violations = validator.validate((Object)this.estado, new Class[0]);
        String mensagemError = "";
        mensagemError = violations.stream().map(obj -> obj.getMessage() + "\n").reduce(mensagemError, String::concat);
        if (!mensagemError.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)mensagemError);
            return false;
        }
        return true;
    }
}

