/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.geral.controller;

import br.com.maximasolutions.administrativo.core.PermissaoControleValida;
import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.modelo.PermissaoControleAcao;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.geral.controller.FornecedorFormController;
import br.com.maximasolutions.geral.modelo.Fornecedor;
import br.com.maximasolutions.geral.service.FornecedorService;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class FornecedorController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private Button btnNovo;
    @FXML
    private Button btnEdita;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnPesquisa;
    @FXML
    private TextField tfPesquisa;
    @FXML
    private TableView<Fornecedor> tabela;
    @FXML
    private TableColumn<Fornecedor, String> colNome;
    @FXML
    private TableColumn<Fornecedor, String> colEndereco;
    @FXML
    private TableColumn<Fornecedor, String> colTelefone;
    @FXML
    private TableColumn<Fornecedor, String> colCidade;
    @FXML
    private TableColumn<Fornecedor, Long> colId;
    @Autowired
    private FornecedorService fornecedorService;
    @Autowired
    private UsuarioService usuarioService;
    private ObservableList<Fornecedor> fornecedorList;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.fornecedorList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.editaFornecedor();
            }
        });
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
    }

    public void inicializa() {
        this.acoes = this.usuarioService.acoes(this.stageManager.getUsuario(), PermissaoControle.Fornecedor);
    }

    private void novoFornecedor() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.ADD).booleanValue()) {
            return;
        }
        this.formFornecedor(null);
        this.loadTabela();
    }

    private void editaFornecedor() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.EDIT).booleanValue()) {
            return;
        }
        Fornecedor fornecedor = (Fornecedor)this.tabela.getSelectionModel().getSelectedItem();
        if (fornecedor == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um fornecedor para editar.");
            return;
        }
        this.formFornecedor(fornecedor);
        this.loadTabela();
    }

    private void formFornecedor(Fornecedor fornecedor) {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/geral/fornecedor/FornecedorForm.fxml", "Edita Fornecedor");
            FornecedorFormController controller = (FornecedorFormController)stage.getUserData();
            controller.inicializa(fornecedor);
            stage.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(FornecedorController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao abrir form fornecedor.\n" + ex.getMessage()));
        }
    }

    private void deleteFornecedor() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.DELETE).booleanValue()) {
            return;
        }
        Fornecedor fornecedor = (Fornecedor)this.tabela.getSelectionModel().getSelectedItem();
        if (fornecedor == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um fornecedor para remover.");
            return;
        }
        if (MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)("Deseja remover o fornecedor: '" + fornecedor.getNome() + "'?"))) {
            try {
                this.fornecedorService.delete(fornecedor);
                MaximaAlert.informe((StageManager)this.stageManager, (String)"Fornecedor deletado com sucesso.");
                this.loadTabela();
            }
            catch (MaximaException ex) {
                Logger.getLogger(FornecedorController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
            }
        }
    }

    private void loadTabela() {
        this.fornecedorList.clear();
        this.fornecedorList.addAll((Collection)this.fornecedorService.list(this.tfPesquisa.getText().trim()));
        this.tabela.setItems(this.fornecedorList);
    }

    private void carregaIcones() {
        this.btnNovo.setGraphic((Node)new MaximaIcone().getIconeNovo());
        this.btnEdita.setGraphic((Node)new MaximaIcone().edita());
        this.btnDelete.setGraphic((Node)new MaximaIcone().getIconeDelete());
        this.btnPesquisa.setGraphic((Node)new MaximaIcone().getPesquisa());
    }

    private void setColumnProperties() {
        this.colId.setCellValueFactory((Callback)new PropertyValueFactory("id"));
        this.colNome.setCellValueFactory((Callback)new PropertyValueFactory("nome"));
        this.colEndereco.setCellValueFactory((Callback)new PropertyValueFactory("enderecoCompleto"));
        this.colTelefone.setCellValueFactory((Callback)new PropertyValueFactory("telefone"));
        this.colCidade.setCellValueFactory((Callback)new PropertyValueFactory("municipio"));
    }

    private void registraAcoes() {
        this.btnNovo.setOnAction(event -> this.novoFornecedor());
        this.btnEdita.setOnAction(event -> this.editaFornecedor());
        this.btnDelete.setOnAction(event -> this.deleteFornecedor());
        this.btnPesquisa.setOnAction(event -> this.loadTabela());
        this.tfPesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.loadTabela();
            }
        });
    }
}

