/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.geral.controller;

import br.com.maximasolutions.administrativo.core.PermissaoControleValida;
import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.modelo.PermissaoControleAcao;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.geral.controller.MunicipioFormController;
import br.com.maximasolutions.geral.modelo.Municipio;
import br.com.maximasolutions.geral.service.MunicipioService;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class MunicipioController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private Button btnNovo;
    @FXML
    private Button btnEdita;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnPesquisa;
    @FXML
    private TextField tfPesquisa;
    @FXML
    private TableView<Municipio> tabela;
    @FXML
    private TableColumn<Municipio, String> colNome;
    @FXML
    private TableColumn<Municipio, String> colCodigo;
    @FXML
    private TableColumn<Municipio, String> colEstado;
    @Autowired
    private MunicipioService municipioService;
    @Autowired
    private UsuarioService usuarioService;
    private ObservableList<Municipio> municipioList;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.municipioList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.editaMunicipio();
            }
        });
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
    }

    public void inicializa() {
        this.acoes = this.usuarioService.acoes(this.stageManager.getUsuario(), PermissaoControle.Municipio);
    }

    private void novoMunicipio() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.ADD).booleanValue()) {
            return;
        }
        this.formMunicipio(null);
        this.loadTabela();
    }

    private void editaMunicipio() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.EDIT).booleanValue()) {
            return;
        }
        Municipio municipio = (Municipio)this.tabela.getSelectionModel().getSelectedItem();
        if (municipio == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um municipio para editar.");
            return;
        }
        this.formMunicipio(municipio);
        this.loadTabela();
    }

    private void formMunicipio(Municipio municipio) {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/geral/municipio/MunicipioForm.fxml", "Novo Municipio");
            MunicipioFormController controller = (MunicipioFormController)stage.getUserData();
            controller.inicializa(municipio);
            stage.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(MunicipioController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.alerta((String)("Ocorreu um erro ao abrir form municipio.\n" + ex.getMessage()));
        }
    }

    private void deleteMunicipio() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.DELETE).booleanValue()) {
            return;
        }
        Municipio municipio = (Municipio)this.tabela.getSelectionModel().getSelectedItem();
        if (municipio == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um municipio para remover.");
            return;
        }
        if (MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)("Deseja remover o municipio: '" + municipio.getNome() + "'?"))) {
            try {
                this.municipioService.deleteById(municipio.getId());
                MaximaAlert.informe((StageManager)this.stageManager, (String)"Municipio deletado com sucesso.");
                this.loadTabela();
            }
            catch (MaximaException ex) {
                Logger.getLogger(MunicipioController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
            }
        }
    }

    private void loadTabela() {
        this.municipioList.clear();
        this.municipioList.addAll((Collection)this.municipioService.lista(this.tfPesquisa.getText().trim()));
        this.tabela.setItems(this.municipioList);
    }

    private void carregaIcones() {
        this.btnNovo.setGraphic((Node)new MaximaIcone().getIconeNovo());
        this.btnEdita.setGraphic((Node)new MaximaIcone().edita());
        this.btnDelete.setGraphic((Node)new MaximaIcone().getIconeDelete());
        this.btnPesquisa.setGraphic((Node)new MaximaIcone().getPesquisa());
    }

    private void setColumnProperties() {
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("codigoIBGE"));
        this.colNome.setCellValueFactory((Callback)new PropertyValueFactory("nome"));
        this.colEstado.setCellValueFactory((Callback)new PropertyValueFactory("estado"));
    }

    private void registraAcoes() {
        this.btnNovo.setOnAction(event -> this.novoMunicipio());
        this.btnEdita.setOnAction(event -> this.editaMunicipio());
        this.btnDelete.setOnAction(event -> this.deleteMunicipio());
        this.btnPesquisa.setOnAction(event -> this.loadTabela());
        this.tfPesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.loadTabela();
            }
        });
    }
}

