/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.geral.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.geral.controller.MunicipioPesquisaController;
import br.com.maximasolutions.geral.modelo.Municipio;
import br.com.maximasolutions.geral.modelo.Transportadora;
import br.com.maximasolutions.geral.service.MunicipioService;
import br.com.maximasolutions.geral.service.TransportadoraService;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaUtils;
import br.com.maximasolutions.vendasexternas.controller.VendedorProdutoLancamentoFormController;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class TransportadoraFormController
extends MaximaController
implements Initializable {
    @Autowired
    private TransportadoraService transportadoraService;
    @Autowired
    private MunicipioService municipioService;
    private Transportadora transportadora;
    @FXML
    private CheckBox ccbAtivo;
    @FXML
    private TextField tfId;
    @FXML
    private TextField tfRazaoSocial;
    @FXML
    private TextField tfNomeFantasia;
    @FXML
    private TextField tfCnpj;
    @FXML
    private TextField tfInscEstadual;
    @FXML
    private TextField tfEndereco;
    @FXML
    private TextField tfEnderecoNumero;
    @FXML
    private TextField tfBairro;
    @FXML
    private TextField tfCep;
    @FXML
    private TextField tfTelefone;
    @FXML
    private TextField tfTelefone2;
    @FXML
    private TextField tfComplemento;
    @FXML
    private TextField tfEmail;
    @FXML
    private TextField tfMunicipioCodigo;
    @FXML
    private TextField tfMunicipioDescricao;
    @FXML
    private TextArea tfObservacao;
    @FXML
    private Button btnSalva;
    @FXML
    private Button btnMunicipio;
    @FXML
    private AnchorPane frame;
    @Autowired
    @Lazy
    private StageManager stageManager;
    private Municipio municipio;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.loadCombos();
        this.setMascaras();
        this.registraAcoes();
    }

    public void inicializa(Transportadora transportadora) {
        this.municipio = null;
        this.transportadora = null;
        if (transportadora != null) {
            this.transportadora = this.transportadoraService.getById(transportadora.getId());
            this.loadTransportadora(transportadora);
        }
    }

    private void loadTransportadora(Transportadora transportadora) {
        if (transportadora != null) {
            this.tfId.setText(transportadora.getId().toString());
            this.ccbAtivo.setSelected(transportadora.getAtivo().booleanValue());
            this.tfRazaoSocial.setText(transportadora.getNome());
            this.tfNomeFantasia.setText(transportadora.getFantasia());
            this.tfTelefone.setText(transportadora.getTelefone());
            this.tfTelefone2.setText(transportadora.getCelular1());
            this.tfCnpj.setText(transportadora.getCpf());
            this.tfInscEstadual.setText(transportadora.getRg());
            this.tfEndereco.setText(transportadora.getEndereco());
            this.tfEnderecoNumero.setText(transportadora.getNumero());
            this.tfBairro.setText(transportadora.getBairro());
            this.tfComplemento.setText(transportadora.getComplemento());
            this.tfCep.setText(transportadora.getCep());
            this.municipio = transportadora.getMunicipio();
            this.tfEmail.setText(transportadora.getEmail());
            this.tfObservacao.setText(transportadora.getObservacao());
            this.tfMunicipioCodigo.setText(transportadora.getMunicipio().getId().toString());
            this.tfMunicipioDescricao.setText(transportadora.getMunicipio().getNome() + " - " + transportadora.getMunicipio().getEstado().getSigla());
        }
    }

    private void save() {
        this.loadTransportadora();
        if (!this.validaForm()) {
            return;
        }
        if (!this.validaModelo().booleanValue()) {
            return;
        }
        try {
            this.transportadora = this.transportadoraService.save(this.transportadora);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Dados do transportadora salvos com sucesso.");
            this.close();
        }
        catch (MaximaException ex) {
            Logger.getLogger(TransportadoraFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void loadTransportadora() {
        if (this.transportadora == null) {
            this.transportadora = new Transportadora();
        }
        this.transportadora.setAtivo(Boolean.valueOf(this.ccbAtivo.isSelected()));
        this.transportadora.setNome(MaximaUtils.getText((String)this.tfRazaoSocial.getText()));
        this.transportadora.setFantasia(MaximaUtils.getText((String)this.tfNomeFantasia.getText()));
        this.transportadora.setTelefone(MaximaUtils.removeCaracteres((String)this.tfTelefone.getText()));
        this.transportadora.setCelular1(MaximaUtils.removeCaracteres((String)this.tfTelefone2.getText()));
        this.transportadora.setCpf(MaximaUtils.removeCaracteres((String)this.tfCnpj.getText()));
        this.transportadora.setRg(MaximaUtils.removeAcentos((String)this.tfInscEstadual.getText()));
        this.transportadora.setEndereco(MaximaUtils.getText((String)this.tfEndereco.getText()));
        this.transportadora.setNumero(MaximaUtils.getText((String)this.tfEnderecoNumero.getText()));
        this.transportadora.setBairro(MaximaUtils.getText((String)this.tfBairro.getText()));
        this.transportadora.setComplemento(MaximaUtils.getText((String)this.tfComplemento.getText()));
        this.transportadora.setCep(MaximaUtils.removeCaracteres((String)this.tfCep.getText()));
        this.transportadora.setMunicipio(this.municipio);
        this.transportadora.setEmail(MaximaUtils.getText((String)this.tfEmail.getText()));
        this.transportadora.setObservacao(this.tfObservacao.getText());
    }

    private void close() {
        Stage stage = (Stage)this.btnSalva.getScene().getWindow();
        stage.close();
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void loadCombos() {
    }

    private void setMascaras() {
        MaximaMask.cnpjField((TextField)this.tfCnpj);
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.save());
        this.btnMunicipio.setOnAction(event -> this.pesquisaMunicipioForm());
        this.tfMunicipioCodigo.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaMunicipio();
            }
        });
    }

    private void pesquisaMunicipio() {
        String municipioCodigo = this.tfMunicipioCodigo.getText().trim();
        if (municipioCodigo.isEmpty()) {
            return;
        }
        try {
            Long municipioCodigoNumero = Long.valueOf(municipioCodigo);
            Municipio municipioPesquisa = this.municipioService.load(municipioCodigoNumero.longValue());
            if (municipioPesquisa != null) {
                this.municipio = municipioPesquisa;
                this.loadDadosMunicipio();
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.pesquisaMunicipioForm();
    }

    private void pesquisaMunicipioForm() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/geral/municipio/MunicipioPesquisa.fxml", "Pesquisa de cidades");
            MunicipioPesquisaController controller = (MunicipioPesquisaController)stage.getUserData();
            controller.setValorPesquisa(this.tfMunicipioCodigo.getText().trim());
            stage.showAndWait();
            Municipio municipioPesquisa = controller.getMunicipioSelecionado();
            if (municipioPesquisa != null) {
                this.municipio = municipioPesquisa;
                this.loadDadosMunicipio();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(VendedorProdutoLancamentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.alerta((String)("Ocorreu um erro ao abrir janela de pesquisa de vendedores.\n" + ex.getMessage()));
        }
    }

    private void loadDadosMunicipio() {
        if (this.municipio != null) {
            this.tfMunicipioCodigo.setText(this.municipio.getId().toString());
            this.tfMunicipioDescricao.setText(this.municipio.getNome().toUpperCase() + " - " + this.municipio.getEstado().getSigla());
            this.tfEmail.requestFocus();
        } else {
            this.tfMunicipioCodigo.setText("");
            this.tfMunicipioDescricao.setText("");
            this.tfMunicipioCodigo.requestFocus();
        }
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.transportadora.getNome() == null || this.transportadora.getNome().isEmpty()) {
            this.tfRazaoSocial.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfRazaoSocial.getStyleClass().remove((Object)"error");
        }
        if (this.transportadora.getCpf() == null || this.transportadora.getCpf().isEmpty()) {
            valido = false;
            this.tfCnpj.getStyleClass().add((Object)"error");
        } else {
            this.tfCnpj.getStyleClass().remove((Object)"error");
        }
        if (this.transportadora.getRg() == null || this.transportadora.getRg().isEmpty()) {
            valido = false;
            this.tfInscEstadual.getStyleClass().add((Object)"error");
        } else {
            this.tfInscEstadual.getStyleClass().remove((Object)"error");
        }
        if (this.transportadora.getEndereco() == null || this.transportadora.getEndereco().isEmpty()) {
            valido = false;
            this.tfEndereco.getStyleClass().add((Object)"error");
        } else {
            this.tfEndereco.getStyleClass().remove((Object)"error");
        }
        if (this.transportadora.getNumero() == null || this.transportadora.getNumero().isEmpty()) {
            valido = false;
            this.tfEnderecoNumero.getStyleClass().add((Object)"error");
        } else {
            this.tfEnderecoNumero.getStyleClass().remove((Object)"error");
        }
        if (this.transportadora.getBairro() == null || this.transportadora.getBairro().isEmpty()) {
            valido = false;
            this.tfBairro.getStyleClass().add((Object)"error");
        } else {
            this.tfBairro.getStyleClass().remove((Object)"error");
        }
        if (this.transportadora.getCep() == null || this.transportadora.getCep().isEmpty()) {
            valido = false;
            this.tfCep.getStyleClass().add((Object)"error");
        } else {
            this.tfCep.getStyleClass().remove((Object)"error");
        }
        if (this.transportadora.getMunicipio() == null) {
            valido = false;
            this.tfMunicipioCodigo.getStyleClass().add((Object)"error");
            this.tfMunicipioDescricao.getStyleClass().add((Object)"error");
        } else {
            this.tfMunicipioCodigo.getStyleClass().remove((Object)"error");
            this.tfMunicipioDescricao.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private Boolean validaModelo() {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set violations = validator.validate((Object)this.transportadora, new Class[0]);
        String mensagemError = "";
        mensagemError = violations.stream().map(obj -> obj.getMessage() + "\n").reduce(mensagemError, String::concat);
        if (!mensagemError.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)mensagemError);
            return false;
        }
        return true;
    }
}

