/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.geral.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.geral.controller.VeiculoFormController;
import br.com.maximasolutions.geral.modelo.Veiculo;
import br.com.maximasolutions.geral.service.VeiculoService;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class VeiculoController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private Button btnNovo;
    @FXML
    private Button btnEdita;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnPesquisa;
    @FXML
    private TextField tfPesquisa;
    @FXML
    private TableView<Veiculo> tabela;
    @FXML
    private TableColumn<Veiculo, String> colNome;
    @FXML
    private TableColumn<Veiculo, String> colCodigo;
    @FXML
    private TableColumn<Veiculo, String> colEstado;
    @Autowired
    private VeiculoService veiculoService;
    private ObservableList<Veiculo> veiculoList;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.veiculoList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.editaVeiculo();
            }
        });
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
    }

    private void novoVeiculo() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/geral/veiculo/VeiculoForm.fxml", "Novo Veiculo");
            VeiculoFormController controller = (VeiculoFormController)stage.getUserData();
            controller.inicializa(null);
            stage.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(VeiculoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.alerta((String)("Ocorreu um erro ao abrir form veiculo.\n" + ex.getMessage()));
        }
        this.loadTabela();
    }

    private void editaVeiculo() {
        Veiculo veiculo = (Veiculo)this.tabela.getSelectionModel().getSelectedItem();
        if (veiculo == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um veiculo para editar.");
            return;
        }
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/geral/veiculo/VeiculoForm.fxml", "Edita Veiculo");
            VeiculoFormController controller = (VeiculoFormController)stage.getUserData();
            controller.inicializa(veiculo.getId());
            stage.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(VeiculoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao abrir form veiculo.\n" + ex.getMessage()));
        }
        this.loadTabela();
    }

    private void deleteVeiculo() {
        Veiculo veiculo = (Veiculo)this.tabela.getSelectionModel().getSelectedItem();
        if (veiculo == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um veiculo para remover.");
            return;
        }
        if (MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)("Deseja remover o veiculo: '" + veiculo.getNome() + "'?"))) {
            try {
                this.veiculoService.deleteById(veiculo.getId());
                MaximaAlert.informe((StageManager)this.stageManager, (String)"Veiculo deletado com sucesso.");
                this.loadTabela();
            }
            catch (MaximaException ex) {
                Logger.getLogger(VeiculoController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
            }
        }
    }

    private void loadTabela() {
        this.veiculoList.clear();
        this.veiculoList.addAll((Collection)this.veiculoService.lista(this.tfPesquisa.getText().trim()));
        this.tabela.setItems(this.veiculoList);
    }

    private void carregaIcones() {
        this.btnNovo.setGraphic((Node)new MaximaIcone().getIconeNovo());
        this.btnEdita.setGraphic((Node)new MaximaIcone().edita());
        this.btnDelete.setGraphic((Node)new MaximaIcone().getIconeDelete());
        this.btnPesquisa.setGraphic((Node)new MaximaIcone().getPesquisa());
    }

    private void setColumnProperties() {
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("placa"));
        this.colNome.setCellValueFactory((Callback)new PropertyValueFactory("nome"));
        this.colEstado.setCellValueFactory((Callback)new PropertyValueFactory("estado"));
    }

    private void registraAcoes() {
        this.btnNovo.setOnAction(event -> this.novoVeiculo());
        this.btnEdita.setOnAction(event -> this.editaVeiculo());
        this.btnDelete.setOnAction(event -> this.deleteVeiculo());
        this.btnPesquisa.setOnAction(event -> this.loadTabela());
        this.tfPesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.loadTabela();
            }
        });
    }
}

