/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.geral.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.geral.modelo.Estado;
import br.com.maximasolutions.geral.modelo.Veiculo;
import br.com.maximasolutions.geral.service.EstadoService;
import br.com.maximasolutions.geral.service.VeiculoService;
import br.com.maximasolutions.utils.MaximaUtils;
import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class VeiculoFormController
extends MaximaController
implements Initializable {
    @Autowired
    private VeiculoService veiculoService;
    @Autowired
    private EstadoService estadoService;
    private Veiculo veiculo;
    @FXML
    private TextField tfId;
    @FXML
    private TextField tfDescricao;
    @FXML
    private TextField tfPlaca;
    @FXML
    private ComboBox<Estado> cbbEstado;
    @FXML
    private Button btnSalva;
    @FXML
    private AnchorPane frame;
    @Autowired
    @Lazy
    private StageManager stageManager;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.loadCombos();
        this.setMascaras();
        this.registraAcoes();
    }

    public void inicializa(Long veiculoId) {
        this.veiculo = null;
        if (veiculoId != null) {
            this.veiculo = this.veiculoService.load(veiculoId.longValue());
            this.loadVeiculo(this.veiculo);
        }
    }

    private void loadVeiculo(Veiculo veiculo) {
        if (veiculo != null) {
            this.tfId.setText(veiculo.getId().toString());
            this.tfDescricao.setText(veiculo.getNome());
            this.tfPlaca.setText(veiculo.getPlaca());
            this.cbbEstado.getSelectionModel().select((Object)veiculo.getEstado());
        }
    }

    private void save() {
        this.loadVeiculo();
        if (!this.validaForm()) {
            return;
        }
        if (!this.validaModelo().booleanValue()) {
            return;
        }
        try {
            this.veiculo = this.veiculoService.save(this.veiculo);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Dados do veiculo salvos com sucesso.");
            this.close();
        }
        catch (MaximaException ex) {
            Logger.getLogger(VeiculoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void loadVeiculo() {
        if (this.veiculo == null) {
            this.veiculo = new Veiculo();
        }
        this.veiculo.setNome(MaximaUtils.getText((String)this.tfDescricao.getText()));
        this.veiculo.setPlaca(MaximaUtils.removeCaracteres((String)this.tfPlaca.getText()));
        this.veiculo.setEstado((Estado)this.cbbEstado.getSelectionModel().getSelectedItem());
    }

    private void close() {
        Stage stage = (Stage)this.btnSalva.getScene().getWindow();
        stage.close();
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void loadCombos() {
        this.cbbEstado.setItems(FXCollections.observableArrayList((Collection)this.estadoService.list()));
    }

    private void setMascaras() {
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.save());
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.veiculo.getNome() == null || this.veiculo.getNome().isEmpty()) {
            this.tfDescricao.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDescricao.getStyleClass().remove((Object)"error");
        }
        if (this.veiculo.getPlaca() == null || this.veiculo.getPlaca().isEmpty()) {
            valido = false;
            this.tfPlaca.getStyleClass().add((Object)"error");
        } else {
            this.tfPlaca.getStyleClass().remove((Object)"error");
        }
        if (this.veiculo.getEstado() == null) {
            valido = false;
            this.cbbEstado.getStyleClass().add((Object)"error");
        } else {
            this.cbbEstado.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private Boolean validaModelo() {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set violations = validator.validate((Object)this.veiculo, new Class[0]);
        String mensagemError = "";
        mensagemError = violations.stream().map(obj -> obj.getMessage() + "\n").reduce(mensagemError, String::concat);
        if (!mensagemError.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)mensagemError);
            return false;
        }
        return true;
    }
}

