/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.geral.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.geral.controller.MunicipioPesquisaController;
import br.com.maximasolutions.geral.modelo.Municipio;
import br.com.maximasolutions.geral.modelo.Vendedor;
import br.com.maximasolutions.geral.service.MunicipioService;
import br.com.maximasolutions.geral.service.VendedorService;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaUtils;
import br.com.maximasolutions.vendasexternas.controller.VendedorProdutoLancamentoFormController;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class VendedorFormController
extends MaximaController
implements Initializable {
    @Autowired
    @Lazy
    private StageManager stageManager;
    @Autowired
    private VendedorService vendedorService;
    @Autowired
    private MunicipioService municipioService;
    private Vendedor vendedor;
    private Municipio municipio;
    @FXML
    private TextField tfNome;
    @FXML
    private TextField tfCPF;
    @FXML
    private TextField tfRg;
    @FXML
    private TextField tfTelefone;
    @FXML
    private TextField tfLogin;
    @FXML
    private TextField tfSenha;
    @FXML
    private TextField tfId;
    @FXML
    private TextField tfEndereco;
    @FXML
    private TextField tfEnderecoNumero;
    @FXML
    private TextField tfBairro;
    @FXML
    private TextField tfCep;
    @FXML
    private TextField tfComplemento;
    @FXML
    private TextField tfEmail;
    @FXML
    private TextField tfMunicipioCodigo;
    @FXML
    private TextField tfMunicipioDescricao;
    @FXML
    private TextArea tfObservacao;
    @FXML
    private CheckBox ccbAtivo;
    @FXML
    private CheckBox ccbEstoqueEmpresa;
    @FXML
    private Button btnSalva;
    @FXML
    private Button btnMunicipio;

    public void initialize(URL url, ResourceBundle rb) {
        this.vendedor = null;
        this.carregaIcones();
        this.registraAcoes();
        this.carregaCombos();
        this.carregaMascaras();
    }

    private void salva() {
        this.getVendedor();
        if (!this.validaForm()) {
            return;
        }
        try {
            this.vendedor.setSincronizado(Boolean.valueOf(false));
            this.vendedorService.save(this.vendedor);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Vendedor salvo com sucesso.");
            this.fechaForm();
        }
        catch (MaximaException ex) {
            Logger.getLogger(VendedorFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Erro: n\u00e3o foi poss\u00edvel salvar o vendedor.\n" + ex.getMessage()));
        }
    }

    private Vendedor getVendedor() {
        if (this.vendedor == null) {
            this.vendedor = new Vendedor();
        }
        this.vendedor.setAtivo(Boolean.valueOf(this.ccbAtivo.isSelected()));
        this.vendedor.setNome(MaximaUtils.getText((String)this.tfNome.getText()));
        this.vendedor.setTelefone(MaximaUtils.removeCaracteres((String)this.tfTelefone.getText()));
        this.vendedor.setCpf(MaximaUtils.removeCaracteres((String)this.tfCPF.getText()));
        this.vendedor.setRg(MaximaUtils.removeAcentos((String)this.tfRg.getText()));
        this.vendedor.setEndereco(MaximaUtils.getText((String)this.tfEndereco.getText()));
        this.vendedor.setNumero(MaximaUtils.getText((String)this.tfEnderecoNumero.getText()));
        this.vendedor.setBairro(MaximaUtils.getText((String)this.tfBairro.getText()));
        this.vendedor.setComplemento(MaximaUtils.getText((String)this.tfComplemento.getText()));
        this.vendedor.setCep(MaximaUtils.removeCaracteres((String)this.tfCep.getText()));
        this.vendedor.setMunicipio(this.municipio);
        this.vendedor.setEmail(MaximaUtils.getText((String)this.tfEmail.getText()));
        this.vendedor.setObservacao(this.tfObservacao.getText());
        String login = this.tfLogin.getText();
        if (login != null && !login.isEmpty()) {
            this.vendedor.setLogin(login);
            this.vendedor.setSenha(this.tfSenha.getText());
        }
        this.vendedor.setEstoqueEmpresa(Boolean.valueOf(this.ccbEstoqueEmpresa.isSelected()));
        return this.vendedor;
    }

    public void inicializa(Vendedor vendedor1) {
        this.municipio = null;
        this.vendedor = vendedor1;
        if (this.vendedor != null) {
            this.loadVendendor();
        }
    }

    private void loadVendendor() {
        this.municipio = this.vendedor.getMunicipio();
        System.out.println("Vendedor: " + this.vendedor + " | " + this.vendedor.getId());
        this.tfId.setText(this.vendedor.getId().toString());
        this.ccbAtivo.setSelected(this.vendedor.getAtivo().booleanValue());
        this.tfNome.setText(this.vendedor.getNome());
        this.tfCPF.setText(this.vendedor.getCpf());
        this.tfRg.setText(this.vendedor.getRg());
        this.tfTelefone.setText(this.vendedor.getTelefone());
        this.tfEndereco.setText(this.vendedor.getEndereco());
        this.tfEnderecoNumero.setText(this.vendedor.getNumero());
        this.tfBairro.setText(this.vendedor.getBairro());
        this.tfComplemento.setText(this.vendedor.getComplemento());
        this.tfCep.setText(this.vendedor.getCep());
        this.tfEmail.setText(this.vendedor.getEmail());
        this.tfObservacao.setText(this.vendedor.getObservacao());
        if (this.vendedor.getMunicipio() != null) {
            this.tfMunicipioCodigo.setText(this.vendedor.getMunicipio().getId().toString());
            this.tfMunicipioDescricao.setText(this.vendedor.getMunicipio().getNome() + " - " + this.vendedor.getMunicipio().getEstado().getSigla());
        }
        if (this.vendedor.getId() != null && this.vendedor.getLogin() != null && !this.vendedor.getLogin().isEmpty()) {
            this.tfLogin.setDisable(true);
        }
        this.tfLogin.setText(this.vendedor.getLogin());
        this.tfSenha.setText(this.vendedor.getSenha());
        this.ccbEstoqueEmpresa.setSelected(this.vendedor.getEstoqueEmpresa().booleanValue());
        this.tfNome.selectAll();
        this.tfNome.requestFocus();
    }

    private void carregaCombos() {
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.salva());
        this.btnMunicipio.setOnAction(event -> this.pesquisaMunicipioForm());
        this.tfMunicipioCodigo.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaMunicipio();
            }
        });
    }

    private void carregaMascaras() {
        MaximaMask.cpfField((TextField)this.tfCPF);
    }

    private boolean validaForm() {
        if (this.vendedor == null) {
            MaximaAlert.alerta((String)"Preencha corretamento os dados do vendedor.");
            return false;
        }
        String msgErro = "";
        if (this.vendedor.getNome() == null || this.vendedor.getNome().length() < 10) {
            msgErro = msgErro + "Informe o nome completo do vendedor.\n";
        }
        if (this.vendedor.getCpf() == null || !MaximaUtils.removeCaracteres((String)this.vendedor.getCpf()).isEmpty()) {
            // empty if block
        }
        if (this.vendedor.getTelefone() == null || MaximaUtils.removeCaracteres((String)this.vendedor.getTelefone()).length() < 8) {
            msgErro = msgErro + "Informe um telefone v\u00e1lido para o vendedor.\n";
        }
        if (this.vendedor.getLogin() != null && !this.vendedor.getLogin().isEmpty()) {
            if (this.vendedor.getLogin().contains(" ")) {
                msgErro = msgErro + "O login de usu\u00e1rio n\u00e3o pode contem caracter em branco (espa\u00e7o).\n";
            }
            if (this.vendedor.getSenha() == null || this.vendedor.getSenha().length() < 5) {
                msgErro = msgErro + "A senha deve conter ao mentos 5 caracteres.\n";
            }
        }
        if (!msgErro.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)msgErro);
            return false;
        }
        return true;
    }

    private void pesquisaMunicipio() {
        String municipioCodigo = this.tfMunicipioCodigo.getText().trim();
        if (municipioCodigo.isEmpty()) {
            return;
        }
        try {
            Long municipioCodigoNumero = Long.valueOf(municipioCodigo);
            Municipio municipioPesquisa = this.municipioService.load(municipioCodigoNumero.longValue());
            if (municipioPesquisa != null) {
                this.municipio = municipioPesquisa;
                this.loadDadosMunicipio();
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.pesquisaMunicipioForm();
    }

    private void pesquisaMunicipioForm() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/geral/municipio/MunicipioPesquisa.fxml", "Pesquisa de cidades");
            MunicipioPesquisaController controller = (MunicipioPesquisaController)stage.getUserData();
            controller.setValorPesquisa(this.tfMunicipioCodigo.getText().trim());
            stage.showAndWait();
            Municipio municipioPesquisa = controller.getMunicipioSelecionado();
            if (municipioPesquisa != null) {
                this.municipio = municipioPesquisa;
                this.loadDadosMunicipio();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(VendedorProdutoLancamentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.alerta((String)("Ocorreu um erro ao abrir janela de pesquisa de vendedores.\n" + ex.getMessage()));
        }
    }

    private void loadDadosMunicipio() {
        if (this.municipio != null) {
            this.tfMunicipioCodigo.setText(this.municipio.getId().toString());
            this.tfMunicipioDescricao.setText(this.municipio.getNome().toUpperCase() + " - " + this.municipio.getEstado().getSigla());
            this.tfEmail.requestFocus();
        } else {
            this.tfMunicipioCodigo.setText("");
            this.tfMunicipioDescricao.setText("");
            this.tfMunicipioCodigo.requestFocus();
        }
    }

    private void fechaForm() {
        Stage stage = (Stage)this.tfNome.getScene().getWindow();
        stage.close();
    }
}

