/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.geral.relatorio.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.PrintReport;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.modelo.Mes;
import br.com.maximasolutions.geral.relatorio.controller.AniversarianteBean;
import br.com.maximasolutions.geral.relatorio.controller.RelatorioClienteController;
import br.com.maximasolutions.geral.service.ClienteService;
import java.net.URL;
import java.sql.SQLException;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class RelatorioAniversarianteController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private UsuarioService usuarioService;
    @FXML
    private Button btnGeraRelatorio;
    @FXML
    private ComboBox<Mes> comboMes;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.loadCombos();
        this.loadMascaras();
        this.inicializa();
    }

    public void inicializa() {
        this.acoes = this.usuarioService.acoes(this.stageManager.getUsuario(), PermissaoControle.RelatorioCliente);
    }

    private void geraRelatorio() {
        Mes mes = (Mes)this.comboMes.getSelectionModel().getSelectedItem();
        if (mes == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um m\u00eas para gerar o relat\u00f3rio.");
            return;
        }
        List clienteList = new ArrayList();
        try {
            clienteList = this.clienteService.listaDeAniversariantes(mes.getValor().intValue());
        }
        catch (Exception ex) {
            Logger.getLogger(RelatorioAniversarianteController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ops. Ocorreu um erro ao recuperar lista de aniversariantes.\n" + ex.getMessage()));
            return;
        }
        if (clienteList.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum cliente encontrado no per\u00edodo digitado.");
            return;
        }
        ArrayList<AniversarianteBean> list = new ArrayList<AniversarianteBean>();
        for (Cliente cliente : clienteList) {
            list.add(new AniversarianteBean(cliente.getNome(), "-", cliente.getDataNascimento().format(DateTimeFormatter.ofPattern("dd-MM-yyyy")), cliente.getTelefone(), cliente.getCelular1()));
        }
        Collections.sort(list);
        Configuracao conf = this.configuracaoService.load();
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("DESCRICAO", "ANIVERSARIANTES - M\u00caS DE " + mes.toString().toUpperCase());
            params.put("EMPRESA", conf.getNomeEmpresa().toUpperCase() + " | " + conf.getTelefoneEmpresa());
            JRBeanCollectionDataSource jrds = new JRBeanCollectionDataSource(list);
            new PrintReport().showReport("/jasper/geral/cliente/aniversariantes.jasper", (JRDataSource)jrds, params);
        }
        catch (JRException ex) {
            Logger.getLogger("").log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao gerar relat\u00f3rio.\n" + ex.getMessage()));
        }
        catch (ClassNotFoundException | SQLException ex) {
            Logger.getLogger(RelatorioClienteController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao gerar relat\u00f3rio.\n" + ex.getMessage()));
        }
    }

    private void carregaIcones() {
        this.btnGeraRelatorio.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void loadMascaras() {
    }

    private void registraAcoes() {
        this.btnGeraRelatorio.setOnAction(t -> this.geraRelatorio());
    }

    private void loadCombos() {
        this.comboMes.setItems(FXCollections.observableArrayList((Object[])Mes.values()));
    }
}

