/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.geral.repository;

import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.repository.ClienteRepositoryCustom;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ClienteRepository
extends JpaRepository<Cliente, Long>,
ClienteRepositoryCustom {
    @Query(value="select o from Cliente o where o.ativo = true and o.nome like :valor order by o.municipio.nome")
    public List<Cliente> listaPorCidades(@Param(value="valor") String var1);

    @Query(value="select o from Cliente o where o.ativo = true and o.cpf like :valor")
    public List<Cliente> listaPorCpf(@Param(value="valor") String var1);

    @Query(value="select o from Cliente o where o.ativo = true and (o.nome like :valor or o.cpf like :valor or o.municipio.nome like :valor) order by o.nome")
    public List<Cliente> pesquisa(@Param(value="valor") String var1);

    @Query(value="select o from Cliente o where o.municipio.id = :municipioId and o.ativo = true and o.nome like :valor order by o.nome")
    public List<Cliente> pesquisa(@Param(value="valor") String var1, @Param(value="municipioId") Long var2);

    @Query(value="select o from Cliente o where o.nome like :valor order by o.nome")
    public List<Cliente> pesquisaTodos(@Param(value="valor") String var1);

    @Query(value="select o from Cliente o where o.municipio.id = :municipioId and o.nome like :valor order by o.nome")
    public List<Cliente> pesquisaTodos(@Param(value="valor") String var1, @Param(value="municipioId") Long var2);

    @Query(value="SELECT o FROM Cliente o WHERE o.ativo = true AND month(o.dataNascimento) = :mes ORDER BY day(o.dataNascimento), o.nome")
    public List<Cliente> listaDeAniversariantes(@Param(value="mes") int var1);

    @Query(value="select o from Cliente o where o.vendedor.id is not null and (o.sincronizado is null or o.sincronizado = false) order by o.nome")
    public List<Cliente> sincronizar();

    @Query(value="select o from Cliente o where o.uuid = :uuid")
    public Cliente get(@Param(value="uuid") String var1);
}

