/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.geral.repository;

import br.com.maximasolutions.geral.modelo.Municipio;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface MunicipioRepository
extends JpaRepository<Municipio, Long> {
    @Query(value="select o from Municipio o order by o.nome")
    public List<Municipio> list();

    @Query(value="select o from Municipio o where o.estado.id = :estadoId order by o.nome")
    public List<Municipio> list(@Param(value="estadoId") Long var1);

    @Query(value="select o from Municipio o where o.codigoIBGE = :codigoIBGE ")
    public Municipio getByIbge(@Param(value="codigoIBGE") String var1);

    @Query(value="select o from Municipio o where o.nome like :cidade AND o.estado.sigla like :uf")
    public Municipio getByCidadeUF(@Param(value="cidade") String var1, @Param(value="uf") String var2);

    @Query(value="select o from Municipio o where o.nome like :valor order by o.nome")
    public List<Municipio> pesquisa(@Param(value="valor") String var1);

    @Query(value="select o from Municipio o order by o.nome")
    public List<Municipio> list(Pageable var1);

    @Query(value="select count(o.id) from Municipio o")
    public long count();

    @Query(value="SELECT o FROM Municipio o WHERE o.sincronizado is null OR o.sincronizado = FALSE ORDER BY o.id")
    public List<Municipio> sincronizar();

    @Query(value="select o from Municipio o where o.uuid = :uuid ")
    public Municipio get(@Param(value="uuid") String var1);
}

