/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.geral.repository;

import br.com.maximasolutions.geral.modelo.Vendedor;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface VendedorRepository
extends JpaRepository<Vendedor, Long> {
    @Query(value="select o from Vendedor o where o.ativo = true and o.login = :login")
    public Vendedor getByLogin(@Param(value="login") String var1);

    @Query(value="select o from Vendedor o where o.ativo = true order by o.nome")
    public List<Vendedor> list();

    @Query(value="select o from Vendedor o where o.ativo = true and o.nome like :valor order by o.nome")
    public List<Vendedor> pesquisa(@Param(value="valor") String var1);

    @Query(value="select o from Vendedor o where (o.sincronizado is null or o.sincronizado = false) and (o.login is not null) order by o.nome")
    public List<Vendedor> sincronizar();

    @Query(value="select o from Vendedor o order by o.nome")
    public List<Vendedor> list(Pageable var1);

    @Query(value="select o from Vendedor o where o.login is not null order by o.nome")
    public List<Vendedor> listaVendasExternas();

    @Query(value="select o from Vendedor o where o.login is not null and o.estoqueEmpresa = true order by o.nome")
    public List<Vendedor> listaEstoqueEmpresa();

    @Query(value="select count(o.id) from Vendedor o")
    public long count();

    @Query(value="select o from Vendedor o where o.uuid like :uuid")
    public Vendedor get(@Param(value="uuid") String var1);

    @Query(value="select o from Vendedor o where o.id = :id")
    public Vendedor get(@Param(value="id") long var1);
}

