/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.geral.service;

import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.geral.modelo.Estado;
import br.com.maximasolutions.geral.modelo.Municipio;
import br.com.maximasolutions.geral.repository.MunicipioRepository;
import br.com.maximasolutions.geral.service.MunicipioService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={MaximaException.class})
public class MunicipioServiceImpl
implements MunicipioService {
    @Autowired
    private MunicipioRepository municipioRepository;

    @Transactional(readOnly=true)
    public List<Municipio> list() {
        return this.municipioRepository.list();
    }

    @Transactional(readOnly=true)
    public List<Municipio> list(Estado estado) {
        return this.municipioRepository.list(estado.getId());
    }

    @Transactional(readOnly=true)
    public Municipio load(long id) {
        Optional municipio = this.municipioRepository.findById((Object)id);
        if (municipio.isPresent()) {
            return (Municipio)municipio.get();
        }
        return null;
    }

    public Municipio save(Municipio municipio) throws MaximaException {
        municipio.setSincronizado(Boolean.FALSE);
        return (Municipio)this.municipioRepository.save((Object)municipio);
    }

    public void deleteById(Long id) throws MaximaException {
        this.municipioRepository.deleteById((Object)id);
    }

    @Transactional(readOnly=true)
    public List<Municipio> lista(String valor) {
        return this.municipioRepository.pesquisa("%" + valor + "%");
    }

    @Transactional(readOnly=true)
    public Municipio getByIbge(String ibge) {
        return this.municipioRepository.getByIbge(ibge);
    }

    @Transactional(readOnly=true)
    public List<Municipio> listaSincronizar() {
        return this.municipioRepository.sincronizar();
    }
}

