/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.geral.service;

import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.geral.modelo.Estado;
import br.com.maximasolutions.geral.modelo.Veiculo;
import br.com.maximasolutions.geral.repository.VeiculoRepository;
import br.com.maximasolutions.geral.service.VeiculoService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={MaximaException.class})
public class VeiculoServiceImpl
implements VeiculoService {
    @Autowired
    private VeiculoRepository veiculoRepository;

    @Transactional(readOnly=true)
    public List<Veiculo> list() {
        return this.veiculoRepository.list();
    }

    @Transactional(readOnly=true)
    public List<Veiculo> list(Estado estado) {
        return this.veiculoRepository.list(estado.getId());
    }

    @Transactional(readOnly=true)
    public Veiculo load(long id) {
        Optional veiculo = this.veiculoRepository.findById((Object)id);
        if (veiculo.isPresent()) {
            return (Veiculo)veiculo.get();
        }
        return null;
    }

    public Veiculo save(Veiculo veiculo) throws MaximaException {
        return (Veiculo)this.veiculoRepository.save((Object)veiculo);
    }

    public void deleteById(Long id) throws MaximaException {
        this.veiculoRepository.deleteById((Object)id);
    }

    public List<Veiculo> lista(String valor) {
        return this.veiculoRepository.pesquisa("%" + valor + "%");
    }

    public List<Veiculo> combo() {
        ArrayList<Veiculo> lista = new ArrayList<Veiculo>();
        lista.add(null);
        lista.addAll(this.veiculoRepository.pesquisa("%%"));
        return lista;
    }
}

