/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.geral.service;

import br.com.maximasolutions.administrativo.modelo.Usuario;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.geral.modelo.Vendedor;
import br.com.maximasolutions.geral.repository.VendedorRepository;
import br.com.maximasolutions.geral.service.VendedorService;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class VendedorServiceImpl
implements VendedorService {
    @Autowired
    private VendedorRepository vendedorRepository;
    @Autowired
    private UsuarioService usuarioService;

    @Transactional(readOnly=true)
    public List<Vendedor> list() {
        return this.vendedorRepository.list();
    }

    @Transactional(readOnly=true)
    public Vendedor load(long id) {
        Optional vendedor = this.vendedorRepository.findById((Object)id);
        if (vendedor.isPresent()) {
            return (Vendedor)vendedor.get();
        }
        return null;
    }

    public Vendedor save(Vendedor vendedor) throws MaximaException {
        if (vendedor.getLogin() != null && !vendedor.getLogin().isEmpty()) {
            Vendedor existe = this.vendedorRepository.getByLogin(vendedor.getLogin());
            if (!(existe == null || vendedor.getId() != null && existe.getId().equals(vendedor.getId()))) {
                throw new MaximaException("Login j\u00e1 cadastrado no sistema.");
            }
        } else {
            vendedor.setLogin(null);
            vendedor.setSenha(null);
        }
        vendedor.setSincronizado(Boolean.valueOf(false));
        vendedor = (Vendedor)this.vendedorRepository.save((Object)vendedor);
        Usuario usuarioVendedor = null;
        if (vendedor.getLogin() != null) {
            if (vendedor.getUsuario() == null) {
                if (this.usuarioService.findByLogin(vendedor.getLogin()) != null) {
                    throw new MaximaException("Login j\u00e1 cadastrado no sistema.");
                }
                Usuario usuario = new Usuario();
                usuario.setAtivo(Boolean.TRUE);
                usuario.setNome(vendedor.getNome());
                usuario.setLogin(vendedor.getLogin());
                usuario.setSenha(vendedor.getSenha());
                usuario.setUltimaAlteracao(LocalDateTime.now());
                usuarioVendedor = this.usuarioService.save(usuario);
            } else {
                Usuario usuario = this.usuarioService.findByLogin(vendedor.getLogin());
                usuario.setNome(vendedor.getNome());
                usuario.setSenha(vendedor.getSenha());
                usuario.setUltimaAlteracao(LocalDateTime.now());
                usuarioVendedor = this.usuarioService.save(usuario);
            }
        }
        vendedor.setUsuario(usuarioVendedor);
        if (vendedor.getUsuario() != null) {
            vendedor.setSenha(vendedor.getUsuario().getSenha());
        }
        return (Vendedor)this.vendedorRepository.save((Object)vendedor);
    }

    public void deleteById(Long id) {
        Vendedor vendedor = (Vendedor)this.vendedorRepository.findById((Object)id).get();
        vendedor.setAtivo(Boolean.valueOf(false));
        this.vendedorRepository.save((Object)vendedor);
    }

    @Transactional(readOnly=true)
    public List<Vendedor> pesquisa(String valor) {
        return this.vendedorRepository.pesquisa("%" + valor + "%");
    }

    @Transactional(readOnly=true)
    public List<Vendedor> listaSincronizar() {
        return this.vendedorRepository.sincronizar();
    }

    @Transactional(readOnly=true)
    public List<Vendedor> listaVendedorEstoqueEmpresa() {
        return this.vendedorRepository.listaEstoqueEmpresa();
    }
}

