/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.nfce.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.fiscal.certificado.AssinaturaDigitalA3;
import br.com.maximasolutions.fiscal.certificado.MaximaCertificado;
import br.com.maximasolutions.fiscal.config.NFeConfigMaxima;
import br.com.maximasolutions.nfce.modelo.NFCeCabecalho;
import br.com.maximasolutions.nfe.controller.NotaFiscalCancelaXml;
import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.nfe400.NotaFiscalChaveParser;
import com.fincatto.documentofiscal.nfe400.classes.evento.cancelamento.NFEnviaEventoCancelamento;
import com.fincatto.documentofiscal.nfe400.classes.evento.cancelamento.NFEventoCancelamento;
import com.fincatto.documentofiscal.nfe400.classes.evento.cancelamento.NFInfoCancelamento;
import com.fincatto.documentofiscal.nfe400.classes.evento.cancelamento.NFInfoEventoCancelamento;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NFCeCancelamentoXml {
    private static final String DESCRICAO_EVENTO = "Cancelamento";
    private static final BigDecimal VERSAO_LEIAUTE = new BigDecimal("1.00");
    private static final String EVENTO_CANCELAMENTO = "110111";

    public String geraXml(NFCeCabecalho nf, String motivo, Configuracao conf) throws Exception {
        try {
            NFeConfigMaxima config = new NFeConfigMaxima(conf);
            new MaximaCertificado().loadCertificado(conf.getAliasCertificado(), conf.getSenhaCertificado());
            String xml = this.gerarDadosCancelamento(nf.getChaveAcesso() + nf.getDigitoChaveAcesso(), nf.getProtocolo(), motivo).toString();
            xml = xml.replace("\n", "#");
            return new AssinaturaDigitalA3().assinaCancNFe(xml, config.getCertificadoA3Senha(), conf.getAliasCertificado());
        }
        catch (Exception e) {
            Logger.getLogger(NotaFiscalCancelaXml.class.getSimpleName()).log(Level.SEVERE, null, e);
            throw new Exception(e);
        }
    }

    private NFEnviaEventoCancelamento gerarDadosCancelamento(String chaveAcesso, String numeroProtocolo, String motivo) {
        NotaFiscalChaveParser chaveParser = new NotaFiscalChaveParser(chaveAcesso);
        NFInfoCancelamento cancelamento = new NFInfoCancelamento();
        cancelamento.setDescricaoEvento(DESCRICAO_EVENTO);
        cancelamento.setVersao(VERSAO_LEIAUTE);
        cancelamento.setJustificativa(motivo);
        cancelamento.setProtocoloAutorizacao(numeroProtocolo);
        NFInfoEventoCancelamento infoEvento = new NFInfoEventoCancelamento();
        DFAmbiente ambiente = DFAmbiente.PRODUCAO;
        if (MaximaConfig.getInstance().getProperty("nfambiente") != null && MaximaConfig.getInstance().getProperty("nfambiente").equalsIgnoreCase("homologacao")) {
            ambiente = DFAmbiente.HOMOLOGACAO;
        }
        infoEvento.setAmbiente(ambiente);
        infoEvento.setChave(chaveAcesso);
        infoEvento.setCnpj(chaveParser.getCnpjEmitente());
        infoEvento.setDataHoraEvento(ZonedDateTime.now());
        infoEvento.setId(String.format("ID%s%s0%s", EVENTO_CANCELAMENTO, chaveAcesso, "1"));
        infoEvento.setNumeroSequencialEvento(1);
        infoEvento.setOrgao(chaveParser.getNFUnidadeFederativa());
        infoEvento.setCodigoEvento(EVENTO_CANCELAMENTO);
        infoEvento.setVersaoEvento(VERSAO_LEIAUTE);
        infoEvento.setCancelamento(cancelamento);
        NFEventoCancelamento evento = new NFEventoCancelamento();
        evento.setInfoEvento(infoEvento);
        evento.setVersao(VERSAO_LEIAUTE);
        NFEnviaEventoCancelamento enviaEvento = new NFEnviaEventoCancelamento();
        enviaEvento.setEvento(Collections.singletonList(evento));
        enviaEvento.setIdLote(Long.toString(System.currentTimeMillis()));
        enviaEvento.setVersao(VERSAO_LEIAUTE);
        return enviaEvento;
    }
}

