/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.nfce.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.modelo.VendaProdutoFaturamento;
import br.com.maximasolutions.estoque.modelo.VendaProdutoItem;
import br.com.maximasolutions.fiscal.core.NFeUtil;
import br.com.maximasolutions.fiscal.modelo.NFeStatus;
import br.com.maximasolutions.fiscal.modelo.Ncm;
import br.com.maximasolutions.fiscal.service.NcmService;
import br.com.maximasolutions.nfce.modelo.NFCeCabecalho;
import br.com.maximasolutions.nfce.modelo.NFCeDestinatario;
import br.com.maximasolutions.nfce.modelo.NFCeDetalhe;
import br.com.maximasolutions.nfce.modelo.NFCeEmitente;
import br.com.maximasolutions.nfce.modelo.NFCePagamento;
import br.com.maximasolutions.nfce.service.NFCeService;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFTipoEmissao;
import com.fincatto.documentofiscal.nfe400.classes.NFFinalidade;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoSituacaoTributariaCOFINS;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoSituacaoTributariaPIS;
import com.fincatto.documentofiscal.nfe400.classes.NFTipo;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFOperacaoConsumidorFinal;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

public class NFCeImportaVenda {
    private final Configuracao conf;
    private final NFCeService nFCeService;

    public NFCeImportaVenda(Configuracao configuracao, NFCeService nFCeService1) {
        this.conf = configuracao;
        this.nFCeService = nFCeService1;
    }

    private String getCodigoNumero() {
        long cod = (long)(Math.random() * 9.9999999E7);
        String codigo = String.valueOf(cod);
        while (codigo.length() < 8) {
            cod = (long)(Math.random() * 9.9999999E7);
            codigo = String.valueOf(cod);
        }
        return codigo;
    }

    private NFCeCabecalho setChaveAcesso(NFCeCabecalho nfce) {
        String ibge = DFUnidadeFederativa.valueOfCodigo((String)this.conf.getEmpresaNFe().getMunicipio().getEstado().getSigla()).getCodigoIbge();
        String ano = nfce.getDataEmissao().format(DateTimeFormatter.ofPattern("yy"));
        String mes = nfce.getDataEmissao().format(DateTimeFormatter.ofPattern("MM"));
        String cnpj = nfce.getEmpresa().getCpf();
        String codModelo = nfce.getCodigoModelo();
        String serie = MaximaUtils.completaZeroEsquerda((String)nfce.getSerie().trim(), (Integer)3);
        String numero = MaximaUtils.completaZeroEsquerda((String)nfce.getNumero().trim(), (Integer)9);
        String codNumerico = nfce.getCodigoNumerico();
        if (codNumerico == null || codNumerico.isEmpty()) {
            codNumerico = this.getCodigoNumero();
        }
        String chaveAcesso = ibge + ano + mes + cnpj + codModelo + serie + numero + nfce.getTipoEmissao().getCodigo() + codNumerico;
        String digChaveAcesso = NFeUtil.modulo11((String)chaveAcesso).toString();
        nfce.setChaveAcesso(chaveAcesso);
        nfce.setDigitoChaveAcesso(digChaveAcesso);
        nfce.setCodigoNumerico(codNumerico);
        return nfce;
    }

    public NFCeCabecalho getNFCe(VendaProduto vendaProduto, List<VendaProdutoItem> itens) throws MaximaException {
        String serie = MaximaConfig.getInstance().getProperty("nfserie", "01");
        NFCeCabecalho nfce = new NFCeCabecalho();
        nfce.setEmpresa(this.conf.getEmpresaNFe());
        Integer numero = vendaProduto.getMovimentoCaixa().getCaixa().getNfceNumero();
        nfce.setNumero(numero.toString());
        BigDecimal valorDesconto = BigDecimal.ZERO;
        BigDecimal valorProdutos = BigDecimal.ZERO;
        BigDecimal valorTotal = BigDecimal.ZERO;
        for (VendaProdutoItem item : itens) {
            valorDesconto = valorDesconto.add(item.getDesconto());
            valorProdutos = valorProdutos.add(item.getPrecoUnitario().multiply(item.getQuantidade()).setScale(2, RoundingMode.HALF_EVEN));
            valorTotal = valorTotal.add(item.getPrecoTotal());
        }
        nfce.setDataEmissao(LocalDateTime.now());
        nfce.setDataEntradaSaida(null);
        nfce.setHoraEntradaSaida(null);
        nfce.setCodigoModelo("65");
        nfce.setTipoOperacao(NFTipo.SAIDA);
        nfce.setFinalidadeEmissao(NFFinalidade.NORMAL);
        nfce.setTipoEmissao(NFTipoEmissao.EMISSAO_NORMAL);
        nfce.setNaturezaOperacao("VENDA");
        nfce.setStatusNota(NFeStatus.EM_DIGITACAO);
        nfce.setSerie(MaximaUtils.completaZeroEsquerda((String)serie, (Integer)2));
        nfce.setValorFrete(BigDecimal.ZERO);
        nfce.setValorDespesasAcessorias(BigDecimal.ZERO);
        nfce.setValorSeguro(BigDecimal.ZERO);
        nfce.setValorDesconto(valorDesconto);
        nfce.setValorTotal(valorTotal);
        nfce.setValorTotalProdutos(valorProdutos);
        nfce.setInformacoesAddContribuinte("");
        nfce.setBaseCalculoIcms(BigDecimal.ZERO);
        nfce.setValorIpi(BigDecimal.ZERO);
        nfce.setValorCofins(BigDecimal.ZERO);
        nfce.setValorPis(BigDecimal.ZERO);
        nfce.setValorIcms(BigDecimal.ZERO);
        nfce.setBaseCalculoIcmsSt(BigDecimal.ZERO);
        nfce.setValorIcmsSt(BigDecimal.ZERO);
        nfce.setConsumidorFinal(NFOperacaoConsumidorFinal.SIM);
        nfce.setCliente(vendaProduto.getCliente());
        nfce.setCondicaoPagamento(null);
        nfce.setFormaPagamento(null);
        nfce.setModalidadeFrete(null);
        nfce.setValorTributosEstadual(valorTotal);
        String obsVenda = vendaProduto.getObservacao();
        obsVenda = obsVenda == null ? "" : "#" + obsVenda;
        nfce = this.setChaveAcesso(nfce);
        return nfce;
    }

    public NFCeEmitente getEmitente() {
        if (this.conf == null || this.conf.getEmpresaNFe() == null) {
            return null;
        }
        NFCeEmitente emitente = new NFCeEmitente();
        emitente.setBairro(MaximaUtils.getText((String)this.conf.getEmpresaNFe().getBairro()));
        emitente.setCep(MaximaUtils.removeCaracteres((String)this.conf.getEmpresaNFe().getCep()));
        emitente.setCodigoMunicipio(Integer.valueOf(Integer.parseInt(this.conf.getEmpresaNFe().getMunicipio().getCodigoIBGE())));
        emitente.setCodigoPais(Integer.valueOf(1058));
        emitente.setCpfCnpj(MaximaUtils.removeCaracteres((String)this.conf.getEmpresaNFe().getCpf()));
        if (this.conf.getEmpresaNFe().getFantasia() != null && !this.conf.getEmpresaNFe().getFantasia().isEmpty()) {
            emitente.setFantasia(MaximaUtils.getText((String)this.conf.getEmpresaNFe().getFantasia()));
        }
        emitente.setIe(MaximaUtils.removeCaracteres((String)this.conf.getEmpresaNFe().getRg()));
        emitente.setLogradouro(MaximaUtils.getText((String)this.conf.getEmpresaNFe().getEndereco()));
        emitente.setMunicipio(this.conf.getEmpresaNFe().getMunicipio());
        emitente.setNomeMunicipio(MaximaUtils.getText((String)this.conf.getEmpresaNFe().getMunicipio().getNome()));
        emitente.setNomePais("BRASIL");
        emitente.setNumero(MaximaUtils.getText((String)this.conf.getEmpresaNFe().getNumero()));
        emitente.setRazaoSocial(MaximaUtils.limitaTexto((String)MaximaUtils.getText((String)this.conf.getEmpresaNFe().getNome()), (int)60));
        if (this.conf.getEmpresaNFe().getTelefone() != null && !this.conf.getEmpresaNFe().getTelefone().isEmpty()) {
            emitente.setTelefone(MaximaUtils.removeCaracteres((String)this.conf.getEmpresaNFe().getTelefone()));
        }
        emitente.setUf(this.conf.getEmpresaNFe().getMunicipio().getEstado().getSigla());
        return emitente;
    }

    public NFCeDestinatario getDestinatario(String cpfCnpj, String nome) {
        if (cpfCnpj == null || cpfCnpj.isEmpty()) {
            return null;
        }
        NFCeDestinatario dest = new NFCeDestinatario();
        dest.setRazaoSocial(nome);
        dest.setCpfCnpj(MaximaUtils.removeCaracteres((String)cpfCnpj));
        return dest;
    }

    public List<NFCeDetalhe> getItensNFe(VendaProduto vendaProduto, List<VendaProdutoItem> list, NcmService ncmService) {
        ArrayList<NFCeDetalhe> itens = new ArrayList<NFCeDetalhe>();
        int count = 1;
        for (VendaProdutoItem v : list) {
            Ncm ncm;
            NFCeDetalhe item = new NFCeDetalhe();
            item.setProduto(v.getProduto());
            item.setCfop(Integer.valueOf(Integer.parseInt(v.getProduto().getCfop())));
            item.setCodigoProduto(v.getProduto().getCodigo());
            item.setNcm(v.getProduto().getNcm());
            item.setGtin(null);
            item.setGtinUnidadeTributavel(null);
            item.setNomeProduto(v.getDescricao());
            item.setOrigemMercadoria(v.getProduto().getOrigem().getCodigo());
            item.setQuantidadeComercial(v.getQuantidade());
            item.setUnidadeComercial(v.getProduto().getUnidade().getSigla().toUpperCase());
            item.setValorBrutoProdutos(v.getPrecoTotalBruto());
            item.setValorUnitarioComercial(v.getPrecoUnitario());
            item.setValorTotal(v.getPrecoTotal());
            item.setValorDesconto(v.getDesconto());
            item.setUnidadeTributavel(v.getProduto().getUnidade().getSigla().toUpperCase());
            item.setQuantidadeTributavel(item.getQuantidadeComercial());
            item.setValorUnitarioTributacao(item.getValorUnitarioComercial());
            item.setValorSubtotal(v.getPrecoTotal());
            item.setCsosn(v.getProduto().getIcmsSN().getCodigo());
            item.setInformacoesAdicionais(v.getObservacao());
            if (v.getProduto().getPis().equals((Object)NFNotaInfoSituacaoTributariaPIS.OPERACAO_ISENTA_CONTRIBUICAO) || v.getProduto().getPis().equals((Object)NFNotaInfoSituacaoTributariaPIS.OPERACAO_SEM_INCIDENCIA_CONTRIBUICAO) || v.getProduto().getPis().equals((Object)NFNotaInfoSituacaoTributariaPIS.OPERACAO_TRIBUTAVEL_MONOFASICA_ALIQUOTA_ZERO)) {
                item.setValorBaseCalculoPis(BigDecimal.ZERO);
                item.setAliquotaPisPercentual(BigDecimal.ZERO);
                item.setValorPis(BigDecimal.ZERO);
                item.setCstPis(v.getProduto().getPis().getCodigo());
            }
            if (v.getProduto().getCofins().equals((Object)NFNotaInfoSituacaoTributariaCOFINS.OPERACAO_ISENTA_CONTRIBUICAO) || v.getProduto().getCofins().equals((Object)NFNotaInfoSituacaoTributariaCOFINS.OPERACAO_SEM_INCIDENCIA_CONTRIBUICAO) || v.getProduto().getCofins().equals((Object)NFNotaInfoSituacaoTributariaCOFINS.OPERACAO_TRIBUTAVEL_MONOFASICA_ALIQUOTA_ZERO)) {
                item.setCstCofins(v.getProduto().getCofins().getCodigo());
                item.setBaseCalculoCofins(BigDecimal.ZERO);
                item.setAliquotaCofinsPercentual(BigDecimal.ZERO);
                item.setValorCofins(BigDecimal.ZERO);
            }
            if ((ncm = ncmService.loadByNCM(Long.parseLong(item.getNcm()))) == null) {
                item.setTributoNacional(BigDecimal.ZERO);
                item.setTributoEstadual(BigDecimal.ZERO);
                item.setTributoMunicipal(BigDecimal.ZERO);
            } else {
                item.setTributoNacional(MaximaNumber.calculaPercentual((BigDecimal)item.getValorTotal(), (BigDecimal)ncm.getAliqNac()));
                item.setTributoEstadual(MaximaNumber.calculaPercentual((BigDecimal)item.getValorTotal(), (BigDecimal)ncm.getAliqEstadual()));
                item.setTributoMunicipal(BigDecimal.ZERO);
            }
            item.setNumeroItem(Integer.valueOf(count));
            itens.add(item);
            ++count;
        }
        return itens;
    }

    public List<NFCePagamento> pagamentos(List<VendaProdutoFaturamento> faturamentos) {
        ArrayList<NFCePagamento> lista = new ArrayList<NFCePagamento>();
        faturamentos.forEach(fat -> {
            NFCePagamento pagamento = new NFCePagamento();
            pagamento.setCondicaoRecebimento(fat.getCondicaoRecebimento());
            pagamento.setDataEntrada(fat.getDataEntrada());
            pagamento.setValor(fat.getValor());
            pagamento.setValorTroco(fat.getValorTroco());
            lista.add(pagamento);
        });
        return lista;
    }
}

