/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.nfce.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.fiscal.certificado.AssinaturaDigitalA3;
import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe400.classes.evento.inutilizacao.NFEnviaEventoInutilizacao;
import com.fincatto.documentofiscal.nfe400.classes.evento.inutilizacao.NFEventoInutilizacaoDados;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;

public class NFCeInutilizacaoXml {
    private static final String VERSAO_SERVICO = "4.00";
    private static final String NOME_SERVICO = "INUTILIZAR";

    public String geraXml(String cnpj, String serie, String numero, DFUnidadeFederativa uf, Configuracao conf) throws Exception {
        LocalDate localDate = LocalDate.now();
        String anoTxt = DateTimeFormatter.ofPattern("yy").format(localDate);
        Integer ano = Integer.parseInt(anoTxt);
        NFEnviaEventoInutilizacao evento = this.geraDadosInutilizacao(ano.intValue(), cnpj, serie, numero, numero, "N\u00famero n\u00e3o utilizado devido a erro de preenchimento.", DFModelo.NFCE, uf);
        return new AssinaturaDigitalA3().assinaInutilizacao("inutNFe", evento.toString(), conf.getSenhaCertificado(), "infInut", conf.getAliasCertificado());
    }

    private NFEnviaEventoInutilizacao geraDadosInutilizacao(int anoInutilizacaoNumeracao, String cnpjEmitente, String serie, String numeroInicial, String numeroFinal, String justificativa, DFModelo modelo, DFUnidadeFederativa uf) {
        NFEnviaEventoInutilizacao inutilizacao = new NFEnviaEventoInutilizacao();
        NFEventoInutilizacaoDados dados = new NFEventoInutilizacaoDados();
        DFAmbiente ambiente = DFAmbiente.PRODUCAO;
        if (MaximaConfig.getInstance().getProperty("nfambiente") != null && MaximaConfig.getInstance().getProperty("nfambiente").equalsIgnoreCase("homologacao")) {
            ambiente = DFAmbiente.HOMOLOGACAO;
        }
        dados.setAmbiente(ambiente);
        dados.setAno(Integer.valueOf(anoInutilizacaoNumeracao));
        dados.setCnpj(cnpjEmitente);
        dados.setJustificativa(justificativa);
        dados.setModeloDocumentoFiscal(modelo.getCodigo());
        dados.setNomeServico(NOME_SERVICO);
        dados.setNumeroNFInicial(numeroInicial);
        dados.setNumeroNFFinal(numeroFinal);
        dados.setSerie(serie);
        dados.setUf(uf);
        String numeroInicialTamanhoMaximo = StringUtils.leftPad((String)numeroInicial, (int)9, (String)"0");
        String numeroFinalTamanhoMaximo = StringUtils.leftPad((String)numeroFinal, (int)9, (String)"0");
        String serieTamanhoMaximo = StringUtils.leftPad((String)serie, (int)3, (String)"0");
        dados.setIdentificador("ID" + uf.getCodigoIbge() + anoInutilizacaoNumeracao + cnpjEmitente + modelo.getCodigo() + serieTamanhoMaximo + numeroInicialTamanhoMaximo + numeroFinalTamanhoMaximo);
        inutilizacao.setVersao(new BigDecimal(VERSAO_SERVICO));
        inutilizacao.setDados(dados);
        return inutilizacao;
    }
}

