/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.nfce.print;

import br.com.maximasolutions.core.ESCPrinter;
import br.com.maximasolutions.utils.MaximaFormat;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNota;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfo;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoFormaPagamento;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItem;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaProcessada;
import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.List;

public class NFCeImpressao {
    public String getTextoCupom(NFNotaProcessada notaProcessada) {
        NFNota nota = notaProcessada.getNota();
        String texto = ESCPrinter.iniciaImpressao();
        texto = texto + this.getCabecalho(nota.getInfo());
        texto = texto + this.getLinhaSeparadora();
        texto = texto + this.getItens(nota.getInfo().getItens());
        texto = texto + this.getLinhaSeparadora();
        texto = texto + this.getTotal(nota.getInfo());
        texto = texto + this.getLinhaSeparadora();
        texto = texto + this.getRodape(nota, notaProcessada);
        return texto;
    }

    private String getCabecalho(NFNotaInfo nota) {
        String texto = ESCPrinter.centraliza((String)ESCPrinter.fonteMenor((String)("CNPJ " + nota.getEmitente().getCnpj() + " " + ESCPrinter.negrita((String)nota.getEmitente().getRazaoSocial().toUpperCase())))) + "\n";
        texto = texto + ESCPrinter.centraliza((String)ESCPrinter.fonteMenor((String)(nota.getEmitente().getEndereco().getLogradouro() + ", " + nota.getEmitente().getEndereco().getNumero() + ", " + nota.getEmitente().getEndereco().getBairro() + " - " + nota.getEmitente().getEndereco().getDescricaoMunicipio() + "/" + nota.getEmitente().getEndereco().getUf()))) + "\n";
        texto = texto + ESCPrinter.centraliza((String)ESCPrinter.fonteMenor((String)"DOCUMENTO AUXILIAR DA NOTA FISCAL DE CONSUMIDOR ELETR\u00d4NICA")) + "\n";
        return texto;
    }

    private String getItens(List<NFNotaInfoItem> itens) {
        String texto = ESCPrinter.fonteMenor((String)ESCPrinter.negrita((String)(MaximaUtils.completaDireita((String)"C\u00d3DIGO", (String)" ", (int)14) + MaximaUtils.completaDireita((String)"DESCRI\u00c7\u00c3O", (String)" ", (int)22) + MaximaUtils.completaEsquerda((String)"QTDE", (String)" ", (int)6) + " UN " + MaximaUtils.completaEsquerda((String)"VL UNIT", (String)" ", (int)9) + MaximaUtils.completaEsquerda((String)"VL TOTAL", (String)" ", (int)9)))) + "\n";
        for (NFNotaInfoItem item : itens) {
            texto = texto + ESCPrinter.fonteMenor((String)(MaximaUtils.completaDireita((String)item.getProduto().getCodigo(), (String)" ", (int)13) + " " + MaximaUtils.completaDireita((String)item.getProduto().getDescricao(), (String)" ", (int)22) + MaximaUtils.completaEsquerda((String)MaximaNumber.quantidadeToString((BigDecimal)new BigDecimal(item.getProduto().getQuantidadeComercial())), (String)" ", (int)6) + MaximaUtils.centraliza((String)item.getProduto().getUnidadeComercial(), (int)4) + MaximaUtils.completaEsquerda((String)MaximaNumber.bigDecimalToString((BigDecimal)new BigDecimal(item.getProduto().getValorUnitario()), (int)2), (String)" ", (int)9) + MaximaUtils.completaEsquerda((String)MaximaNumber.bigDecimalToString((BigDecimal)new BigDecimal(item.getProduto().getValorTotalBruto()), (int)2), (String)" ", (int)9))) + "\n";
        }
        return texto;
    }

    private String getTotal(NFNotaInfo notaInfo) {
        BigDecimal valorTroco;
        String texto = "";
        texto = texto + MaximaUtils.completaDireita((String)"QTDE TOTAL DE ITENS", (String)" ", (int)30) + MaximaUtils.completaEsquerda((String)String.valueOf(notaInfo.getItens().size()), (String)" ", (int)18) + "\n";
        texto = texto + MaximaUtils.completaDireita((String)"VALOR TOTAL R$", (String)" ", (int)30) + MaximaUtils.completaEsquerda((String)MaximaNumber.bigDecimalToString((BigDecimal)new BigDecimal(notaInfo.getTotal().getIcmsTotal().getValorTotalDosProdutosServicos()), (int)2), (String)" ", (int)18) + "\n";
        BigDecimal valorDesconto = new BigDecimal(notaInfo.getTotal().getIcmsTotal().getValorTotalDesconto());
        if (valorDesconto.compareTo(BigDecimal.ZERO) > 0) {
            texto = texto + MaximaUtils.completaDireita((String)"DESCONTO R$", (String)" ", (int)30) + MaximaUtils.completaEsquerda((String)MaximaNumber.bigDecimalToString((BigDecimal)valorDesconto, (int)2), (String)" ", (int)18) + "\n";
        }
        texto = texto + ESCPrinter.negrita((String)(MaximaUtils.completaDireita((String)"VALOR A PAGAR R$", (String)" ", (int)30) + MaximaUtils.completaEsquerda((String)MaximaNumber.bigDecimalToString((BigDecimal)new BigDecimal(notaInfo.getTotal().getIcmsTotal().getValorTotalNFe()), (int)2), (String)" ", (int)18))) + "\n";
        texto = texto + MaximaUtils.completaDireita((String)"FORMA PAGAMENTO", (String)" ", (int)30) + MaximaUtils.completaEsquerda((String)"VALOR PAGO R$", (String)" ", (int)18) + "\n";
        for (NFNotaInfoFormaPagamento det : notaInfo.getPagamento().getDetalhamentoFormasPagamento()) {
            texto = texto + MaximaUtils.completaDireita((String)det.getMeioPagamento().getDescricao(), (String)" ", (int)30) + MaximaUtils.completaEsquerda((String)MaximaNumber.bigDecimalToString((BigDecimal)new BigDecimal(det.getValorPagamento()), (int)2), (String)" ", (int)18) + "\n";
        }
        if (notaInfo.getPagamento().getValorTroco() != null && !notaInfo.getPagamento().getValorTroco().isEmpty() && (valorTroco = new BigDecimal(notaInfo.getPagamento().getValorTroco())).compareTo(BigDecimal.ZERO) > 0) {
            texto = texto + MaximaUtils.completaDireita((String)"TROCO R$", (String)" ", (int)30) + MaximaUtils.completaEsquerda((String)MaximaNumber.bigDecimalToString((BigDecimal)valorTroco, (int)2), (String)" ", (int)18) + "\n";
        }
        return texto;
    }

    private String getRodape(NFNota nota, NFNotaProcessada notaProcessada) {
        String texto = ESCPrinter.fonteMenor((String)ESCPrinter.centraliza((String)ESCPrinter.negrita((String)"Consulte pela chave de acesso em:"))) + "\n";
        texto = texto + ESCPrinter.fonteMenor((String)ESCPrinter.centraliza((String)nota.getInfoSuplementar().getUrlConsultaChaveAcesso())) + "\n";
        texto = texto + ESCPrinter.fonteMenor((String)ESCPrinter.centraliza((String)MaximaFormat.formataChaveNfe((String)nota.getInfo().getChaveAcesso()))) + "\n";
        if (nota.getInfo().getDestinatario() != null) {
            texto = nota.getInfo().getDestinatario().getCpf() != null ? texto + ESCPrinter.centraliza((String)ESCPrinter.fonteMenor((String)ESCPrinter.negrita((String)("CONSUMIDOR CPF: " + nota.getInfo().getDestinatario().getCpf())))) + "\n" : texto + ESCPrinter.centraliza((String)ESCPrinter.fonteMenor((String)ESCPrinter.negrita((String)("CONSUMIDOR CNPJ: " + nota.getInfo().getDestinatario().getCnpj())))) + "\n";
        }
        texto = texto + ESCPrinter.centraliza((String)ESCPrinter.fonteMenor((String)ESCPrinter.negrita((String)("NFC-e n\u00ba " + MaximaUtils.completaZeroEsquerda((String)nota.getInfo().getIdentificacao().getNumeroNota(), (Integer)9) + " S\u00c9RIE: " + MaximaUtils.completaZeroEsquerda((String)nota.getInfo().getIdentificacao().getSerie(), (Integer)3) + "  " + nota.getInfo().getIdentificacao().getDataHoraEmissao().format(DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss")))))) + "\n";
        texto = texto + ESCPrinter.centraliza((String)ESCPrinter.fonteMenor((String)(ESCPrinter.negrita((String)"Protocolo de autoriza\u00e7\u00e3o: ") + notaProcessada.getProtocolo().getProtocoloInfo().getNumeroProtocolo()))) + "\n";
        texto = texto + ESCPrinter.centraliza((String)ESCPrinter.fonteMenor((String)(ESCPrinter.negrita((String)"Data de autoriza\u00e7\u00e3o: ") + notaProcessada.getProtocolo().getProtocoloInfo().getDataRecebimento().format(DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss"))))) + "\n";
        return texto;
    }

    public String getTributosIbpt(BigDecimal valorTributos) {
        String texto = ESCPrinter.fonteMenor((String)("Tributos Totais Incidentes (Lei Federal 12.741/2012): R$ " + MaximaNumber.bigDecimalToString((BigDecimal)valorTributos, (int)2))) + "\n";
        texto = texto + ESCPrinter.finaliza();
        return texto;
    }

    private String getLinhaSeparadora() {
        return ESCPrinter.fonteMenor((String)MaximaUtils.completaDireita((String)"", (String)"-", (int)64)) + "\n";
    }
}

