/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.nfce.service;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.repository.ConfiguracaoRepository;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaFile;
import br.com.maximasolutions.core.MaximaImpressao;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.repository.VendaProdutoRepository;
import br.com.maximasolutions.financeiro.service.CaixaService;
import br.com.maximasolutions.fiscal.certificado.AssinaturaDigitalA3;
import br.com.maximasolutions.fiscal.certificado.MaximaCertificado;
import br.com.maximasolutions.fiscal.config.NFeConfigMaxima;
import br.com.maximasolutions.fiscal.modelo.NFeStatus;
import br.com.maximasolutions.nfce.controller.NFCeCancelamentoXml;
import br.com.maximasolutions.nfce.controller.NFCeController;
import br.com.maximasolutions.nfce.controller.NFCeGeraXml;
import br.com.maximasolutions.nfce.modelo.NFCeCabecalho;
import br.com.maximasolutions.nfce.modelo.NFCeDestinatario;
import br.com.maximasolutions.nfce.modelo.NFCeDetalhe;
import br.com.maximasolutions.nfce.modelo.NFCeEmitente;
import br.com.maximasolutions.nfce.modelo.NFCeInutilizacao;
import br.com.maximasolutions.nfce.modelo.NFCePagamento;
import br.com.maximasolutions.nfce.print.NFCeImpressao;
import br.com.maximasolutions.nfce.repository.NFCeDestinatarioRepository;
import br.com.maximasolutions.nfce.repository.NFCeDetalheRepository;
import br.com.maximasolutions.nfce.repository.NFCeEmitenteRepository;
import br.com.maximasolutions.nfce.repository.NFCeInutilizacaoRepository;
import br.com.maximasolutions.nfce.repository.NFCePagamentoRepository;
import br.com.maximasolutions.nfce.repository.NFCeRepository;
import br.com.maximasolutions.nfce.service.NFCeService;
import br.com.maximasolutions.nfe.controller.NotaFiscalFormController;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.nfe.NFTipoEmissao;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe400.classes.NFProtocolo;
import com.fincatto.documentofiscal.nfe400.classes.evento.NFEnviaEventoRetorno;
import com.fincatto.documentofiscal.nfe400.classes.evento.NFEventoRetorno;
import com.fincatto.documentofiscal.nfe400.classes.evento.cancelamento.NFEnviaEventoCancelamento;
import com.fincatto.documentofiscal.nfe400.classes.evento.cancelamento.NFEventoCancelamento;
import com.fincatto.documentofiscal.nfe400.classes.evento.cancelamento.NFProtocoloEventoCancelamento;
import com.fincatto.documentofiscal.nfe400.classes.evento.inutilizacao.NFRetornoEventoInutilizacao;
import com.fincatto.documentofiscal.nfe400.classes.lote.consulta.NFLoteConsultaRetorno;
import com.fincatto.documentofiscal.nfe400.classes.lote.envio.NFLoteEnvio;
import com.fincatto.documentofiscal.nfe400.classes.lote.envio.NFLoteEnvioRetorno;
import com.fincatto.documentofiscal.nfe400.classes.lote.envio.NFLoteIndicadorProcessamento;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNota;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaProcessada;
import com.fincatto.documentofiscal.nfe400.webservices.WSFacade;
import com.fincatto.documentofiscal.utils.DFPersister;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class NFCeServiceImpl
implements NFCeService {
    @Autowired
    private NFCeRepository nFCeRepository;
    @Autowired
    private NFCeEmitenteRepository nFCeEmitenteRepository;
    @Autowired
    private NFCeDestinatarioRepository nFCeDestinatarioRepository;
    @Autowired
    private NFCeDetalheRepository nFCeDetalheRepository;
    @Autowired
    private VendaProdutoRepository vendaProdutoRepository;
    @Autowired
    private ConfiguracaoRepository configuracaoRepository;
    @Autowired
    private NFCePagamentoRepository nFCePagamentoRepository;
    @Autowired
    private NFCeInutilizacaoRepository nFCeInutilizacaoRepository;
    @Autowired
    private CaixaService caixaService;

    public NFCeCabecalho salva(NFCeCabecalho nfce) throws MaximaException {
        return (NFCeCabecalho)this.nFCeRepository.save((Object)nfce);
    }

    public NFCeCabecalho salva(NFCeCabecalho nfce, NFCeEmitente emitente, NFCeDestinatario destinatario, List<NFCeDetalhe> itens, List<NFCePagamento> pagamentos, VendaProduto vendaProduto, Configuracao conf) throws MaximaException {
        String path = null;
        try {
            String diretorioRaiz = MaximaConfig.getNfceDiretorio();
            path = diretorioRaiz + nfce.getDataEmissao().format(DateTimeFormatter.ofPattern("yyyy-MM")) + "/";
            File diretorio = new File(path);
            if (!diretorio.exists()) {
                diretorio.mkdir();
            }
        }
        catch (Exception e) {
            throw new MaximaException("AVISO: Diret\u00f3rio para emiss\u00e3o de NFC-e n\u00e3o configurado ou inexistente.");
        }
        nfce = (NFCeCabecalho)this.nFCeRepository.save((Object)nfce);
        emitente.setnFCeCabecalho(nfce);
        this.nFCeEmitenteRepository.save((Object)emitente);
        if (destinatario != null) {
            destinatario.setNfceCabecalho(nfce);
            this.nFCeDestinatarioRepository.save((Object)destinatario);
        }
        BigDecimal tributosNacional = BigDecimal.ZERO;
        BigDecimal tributosEstadual = BigDecimal.ZERO;
        BigDecimal tributosMunicipal = BigDecimal.ZERO;
        for (NFCeDetalhe det : itens) {
            det.setnFCeCabecalho(nfce);
            det = (NFCeDetalhe)this.nFCeDetalheRepository.save((Object)det);
            tributosNacional = tributosNacional.add(det.getTributoNacional());
            tributosEstadual = tributosEstadual.add(det.getTributoEstadual());
            tributosMunicipal = tributosMunicipal.add(det.getTributoMunicipal());
        }
        for (NFCePagamento pagamento : pagamentos) {
            pagamento.setnFCeCabecalho(nfce);
            this.nFCePagamentoRepository.save((Object)pagamento);
        }
        nfce.setValorTributosEstadual(tributosEstadual);
        nfce.setValorTributosMunicipal(tributosMunicipal);
        nfce.setValorTributosNacional(tributosNacional);
        NFNota nfceXml = new NFCeGeraXml(conf).getNFCe(nfce, itens, emitente, destinatario, pagamentos);
        ArrayList<NFNota> notas = new ArrayList<NFNota>();
        notas.add(nfceXml);
        NFLoteEnvio lote = new NFLoteEnvio();
        lote.setIndicadorProcessamento(NFLoteIndicadorProcessamento.PROCESSAMENTO_SINCRONO);
        lote.setNotas(notas);
        lote.setVersao(NFeConfigMaxima.VERSAO_NFE);
        lote.setIdLote(nfceXml.getInfo().getIdentificacao().getNumeroNota());
        String documentoAssinado = new AssinaturaDigitalA3().assinaEnviNFe(lote.toString(), conf.getSenhaCertificado(), conf.getAliasCertificado());
        NFNota nfNota = null;
        try {
            NFLoteEnvio loteAssinado = (NFLoteEnvio)new DFPersister().read(NFLoteEnvio.class, documentoAssinado);
            nfNota = (NFNota)loteAssinado.getNotas().get(0);
        }
        catch (Exception ex) {
            Logger.getLogger(NFCeServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException("AVISO: Falha ao recuperar assinatura do arquivo xml da NFCe.");
        }
        if (nfce.getTipoEmissao().equals((Object)NFTipoEmissao.CONTIGENCIA_OFFLINE)) {
            System.out.println("==== CONTING\u00caNCIA");
            try {
                lote = (NFLoteEnvio)new DFPersister().read(NFLoteEnvio.class, documentoAssinado);
                ((NFNota)lote.getNotas().get(0)).setInfoSuplementar(new NFCeGeraXml(conf).getInfoSuplementar(nfce, (NFNota)lote.getNotas().get(0), emitente));
                documentoAssinado = lote.toString();
            }
            catch (Exception ex) {
                Logger.getLogger(NFCeServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        try {
            MaximaFile.escreveTexto((String)"C:/Maxima/nfce/nfce_envia.xml", (String)documentoAssinado);
        }
        catch (IOException ex) {
            Logger.getLogger(NFCeServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        NFeConfigMaxima nfeConfigMaxima = new NFeConfigMaxima(conf);
        try {
            WSFacade facade = new WSFacade((NFeConfig)nfeConfigMaxima);
            new MaximaCertificado().loadCertificado(conf.getAliasCertificado(), conf.getSenhaCertificado());
            System.out.println("==== enviar nfce");
            NFLoteEnvioRetorno retorno = facade.enviaLoteAssinado(documentoAssinado, DFModelo.NFCE);
            System.out.println("=== retorno: " + retorno);
            if (retorno.getStatus().equals("104")) {
                if (!retorno.getProtocoloInfo().getStatus().equals("100")) {
                    throw new MaximaException("AVISO: Falha ao emitir nota fiscal consumidor.\nMotivo: " + retorno.getProtocoloInfo().getMotivo());
                }
            } else {
                throw new MaximaException("AVISO: Falha ao emitir nota fiscal consumidor.");
            }
            NFNotaProcessada notaProcessada = new NFNotaProcessada();
            notaProcessada.setVersao(new BigDecimal(NFeConfigMaxima.VERSAO_NFE));
            NFProtocolo nFProtocolo = new NFProtocolo();
            nFProtocolo.setAssinatura(retorno.getAssinatura());
            nFProtocolo.setProtocoloInfo(retorno.getProtocoloInfo());
            nFProtocolo.setVersao(retorno.getVersao());
            notaProcessada.setProtocolo(nFProtocolo);
            notaProcessada.setNota(nfNota);
            nfce.setXmlTxt(notaProcessada.toString());
            nfce.setStatusNota(NFeStatus.AUTORIZADA);
            nfce.setProtocolo(retorno.getProtocoloInfo().getNumeroProtocolo());
            nfce = (NFCeCabecalho)this.nFCeRepository.save((Object)nfce);
            vendaProduto.setNfce(nfce);
            this.vendaProdutoRepository.save((Object)vendaProduto);
            this.caixaService.incrementaNfce(vendaProduto.getMovimentoCaixa().getCaixa().getId());
        }
        catch (IOException ex) {
            Logger.getLogger(NFCeServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException("AVISO: Falha ao emitir nota fiscal consumidor.");
        }
        catch (KeyManagementException ex) {
            Logger.getLogger(NFCeServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException("AVISO: Falha ao emitir nota fiscal consumidor.");
        }
        catch (UnrecoverableKeyException ex) {
            Logger.getLogger(NFCeServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException("AVISO: Falha ao emitir nota fiscal consumidor.");
        }
        catch (KeyStoreException ex) {
            Logger.getLogger(NFCeServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException("AVISO: Falha ao emitir nota fiscal consumidor.");
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(NFCeServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException("AVISO: Falha ao emitir nota fiscal consumidor.");
        }
        catch (CertificateException ex) {
            Logger.getLogger(NFCeServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException("AVISO: Falha com o certificado digital.");
        }
        catch (MaximaException ex) {
            Logger.getLogger(NFCeServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            System.out.println("================= exception: " + ex.getMessage());
            throw new MaximaException(ex.getMessage());
        }
        catch (Exception ex) {
            Logger.getLogger(NFCeServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException("AVISO: Falha ao escrever o arquivo xml.");
        }
        if (nfce != null && nfce.getStatusNota().equals((Object)NFeStatus.AUTORIZADA)) {
            String caminhoArquivo = path + nfce.getChaveAcesso() + nfce.getDigitoChaveAcesso() + "-NCFe.xml";
            try {
                MaximaFile.escreveTexto((String)caminhoArquivo, (String)nfce.getXmlTxt());
            }
            catch (IOException ex) {
                Logger.getLogger(NFCeServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return nfce;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NFCeCabecalho consultaStatus(NFCeCabecalho nfce) throws MaximaException {
        String path;
        block13: {
            path = null;
            try {
                String diretorioRaiz = MaximaConfig.getNfceDiretorio();
                path = diretorioRaiz + nfce.getDataEmissao().format(DateTimeFormatter.ofPattern("yyyy-MM")) + "/";
                File diretorio = new File(path);
                if (!diretorio.exists()) {
                    diretorio.mkdir();
                }
            }
            catch (Exception e) {
                throw new MaximaException("AVISO: Diret\u00f3rio para emiss\u00e3o de NFC-e n\u00e3o configurado ou inexistente.");
            }
            Configuracao conf = this.configuracaoRepository.load();
            if (!nfce.getRetornoStatus().equals("103")) throw new MaximaException("AVISO: N\u00e3o foi poss\u00edvel consultar o cupom fiscal NFCe.");
            try {
                new MaximaCertificado().loadCertificado(conf.getAliasCertificado(), conf.getSenhaCertificado());
            }
            catch (MaximaException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException ex) {
                Logger.getLogger(NotaFiscalFormController.class.getName()).log(Level.SEVERE, null, ex);
                throw new MaximaException(ex);
            }
            try {
                NFLoteConsultaRetorno retorno2 = new WSFacade((NFeConfig)new NFeConfigMaxima(conf)).consultaLote(nfce.getRecibo(), DFModelo.NFCE);
                MaximaFile.escreveTexto((String)"C:/Maxima/nfce_retorno.txt", (String)retorno2.toString());
                if (retorno2.getStatus().equals("105")) {
                    throw new MaximaException("Lote em processamento. Aguarde 3 minutos e consulte novamente");
                }
                if (retorno2.getProtocolos() != null && ((NFProtocolo)retorno2.getProtocolos().get(0)).getProtocoloInfo().getStatus().equals("100")) {
                    NFLoteEnvio lote = (NFLoteEnvio)new DFPersister().read(NFLoteEnvio.class, nfce.getXmlTxt());
                    if (lote != null && lote.getNotas().size() > 0) {
                        NFNotaProcessada notaProcessada = new NFNotaProcessada();
                        notaProcessada.setVersao(new BigDecimal(NFeConfigMaxima.VERSAO_NFE));
                        notaProcessada.setProtocolo((NFProtocolo)retorno2.getProtocolos().get(0));
                        notaProcessada.setNota((NFNota)lote.getNotas().get(0));
                        nfce.setXmlTxt(notaProcessada.toString());
                        nfce.setStatusNota(NFeStatus.AUTORIZADA);
                        nfce.setProtocolo(((NFProtocolo)retorno2.getProtocolos().get(0)).getProtocoloInfo().getNumeroProtocolo());
                        nfce = (NFCeCabecalho)this.nFCeRepository.save((Object)nfce);
                    }
                    break block13;
                }
                if (retorno2.getProtocolos() == null || retorno2.getProtocolos().size() <= 0) throw new MaximaException("Nota Fiscal Eletr\u00f4nica REJEITADA.\nMotivo:" + retorno2.getMotivo());
                throw new MaximaException("Nota Fiscal Eletr\u00f4nica REJEITADA.\nMotivo:" + ((NFProtocolo)retorno2.getProtocolos().get(0)).getProtocoloInfo().getMotivo());
            }
            catch (IOException ex) {
                Logger.getLogger(NotaFiscalFormController.class.getName()).log(Level.SEVERE, null, ex);
                throw new MaximaException("Diret\u00f3rio para armazenamento da nota fiscal eletr\u00f4nica n\u00e3o encontrado");
            }
            catch (Exception ex) {
                Logger.getLogger(NotaFiscalFormController.class.getName()).log(Level.SEVERE, null, ex);
                throw new MaximaException(ex.getMessage());
            }
        }
        String caminhoArquivo = path + nfce.getChaveAcesso() + nfce.getDigitoChaveAcesso() + "-NCFe.xml";
        try {
            MaximaFile.escreveTexto((String)caminhoArquivo, (String)nfce.getXmlTxt());
            return nfce;
        }
        catch (IOException ex) {
            Logger.getLogger(NFCeServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        return nfce;
    }

    public NFCeCabecalho cancela(NFCeCabecalho nfce) throws MaximaException {
        String xmlCancelamento;
        String xmlCancelamentoAssinado;
        nfce = (NFCeCabecalho)this.nFCeRepository.findById((Object)nfce.getId()).get();
        Configuracao conf = this.configuracaoRepository.load();
        if (!nfce.getStatusNota().equals((Object)NFeStatus.AUTORIZADA)) {
            throw new MaximaException("Opera\u00e7\u00e3o permitida somente para cupom fiscal autorizado");
        }
        try {
            xmlCancelamentoAssinado = new NFCeCancelamentoXml().geraXml(nfce, "Venda cancelada", conf);
        }
        catch (Exception ex) {
            Logger.getLogger(NFCeServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException("ERRO: Falha ao gerar arquivo XML.");
        }
        try {
            NFeConfigMaxima config = new NFeConfigMaxima(conf);
            new MaximaCertificado().loadCertificado(conf.getAliasCertificado(), conf.getSenhaCertificado());
            NFEnviaEventoRetorno retorno = new WSFacade((NFeConfig)config).cancelaNotaAssinada(nfce.getChaveAcesso() + nfce.getDigitoChaveAcesso(), xmlCancelamentoAssinado);
            if (retorno.getCodigoStatusReposta() == 128) {
                if (((NFEventoRetorno)retorno.getEventoRetorno().get(0)).getInfoEventoRetorno().getCodigoStatus() != 135) {
                    throw new MaximaException("AVISO: " + ((NFEventoRetorno)retorno.getEventoRetorno().get(0)).getInfoEventoRetorno().getMotivo());
                }
            } else {
                throw new MaximaException("AVISO: " + retorno.getMotivo());
            }
            String protocolo = ((NFEventoRetorno)retorno.getEventoRetorno().get(0)).getInfoEventoRetorno().getNumeroProtocolo();
            NFProtocoloEventoCancelamento procEvento = new NFProtocoloEventoCancelamento();
            procEvento.setEventoRetorno((NFEventoRetorno)retorno.getEventoRetorno().get(0));
            procEvento.setVersao("1.00");
            NFEnviaEventoCancelamento cancelamento = (NFEnviaEventoCancelamento)new DFPersister().read(NFEnviaEventoCancelamento.class, xmlCancelamentoAssinado);
            procEvento.setEvento((NFEventoCancelamento)cancelamento.getEvento().get(0));
            xmlCancelamento = procEvento.toString();
            nfce.setStatusNota(NFeStatus.CANCELADA);
            nfce.setXmlCancTxt(xmlCancelamento);
            nfce = (NFCeCabecalho)this.nFCeRepository.save((Object)nfce);
            nfce.setStatusNota(NFeStatus.CANCELADA);
            nfce = (NFCeCabecalho)this.nFCeRepository.save((Object)nfce);
        }
        catch (Exception ex) {
            Logger.getLogger(NFCeServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException("Erro ao cancelar cupom fiscal." + ex.getMessage());
        }
        String diretorioRaiz = MaximaConfig.getNfceDiretorio();
        String path = diretorioRaiz + nfce.getDataEmissao().format(DateTimeFormatter.ofPattern("yyyy-MM")) + "/";
        File diretorio = new File(path);
        if (!diretorio.exists()) {
            diretorio.mkdir();
        }
        String caminhoArquivo = path + nfce.getChaveAcesso() + nfce.getDigitoChaveAcesso() + "-Canc.xml";
        try {
            MaximaFile.escreveTexto((String)caminhoArquivo, (String)xmlCancelamento);
        }
        catch (IOException ex) {
            Logger.getLogger(NFCeServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        return nfce;
    }

    public void inutiliza(String xml) throws MaximaException {
        String path = null;
        try {
            String diretorioRaiz = MaximaConfig.getNfceDiretorio();
            path = diretorioRaiz + LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM")) + "/";
            File diretorio = new File(path);
            if (!diretorio.exists()) {
                diretorio.mkdir();
            }
        }
        catch (Exception e) {
            throw new MaximaException("AVISO: Diret\u00f3rio para emiss\u00e3o de NFC-e n\u00e3o configurado ou inexistente.");
        }
        Configuracao conf = this.configuracaoRepository.load();
        NFeConfigMaxima config = new NFeConfigMaxima(conf);
        String xmlRetorno = null;
        String protocolo = null;
        try {
            new MaximaCertificado().loadCertificado(conf.getAliasCertificado(), conf.getSenhaCertificado());
            NFRetornoEventoInutilizacao retorno = new WSFacade((NFeConfig)new NFeConfigMaxima(conf)).inutilizaNotaAssinada(xml, DFModelo.NFCE);
            if (retorno != null && retorno.getDados().getStatus().equals("102")) {
                NFCeInutilizacao inut = new NFCeInutilizacao();
                inut.setAno(retorno.getDados().getAno());
                inut.setNumero(retorno.getDados().getNumeroNFInicial());
                inut.setProtocolo(retorno.getDados().getNumeroProtocolo());
                inut.setSerie(retorno.getDados().getSerie());
                inut.setXml(retorno.toString());
                inut = (NFCeInutilizacao)this.nFCeInutilizacaoRepository.save((Object)inut);
                xmlRetorno = inut.getXml();
                protocolo = inut.getProtocolo();
            }
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
            Logger.getLogger(NFCeServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException("Erro: Falha ao inutilizar n\u00famero NFCe.\n" + ex.getMessage());
        }
        catch (Exception ex) {
            Logger.getLogger(NFCeServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException("Erro: Falha ao inutilizar n\u00famero NFCe.\n" + ex.getMessage());
        }
        String caminhoArquivo = path + protocolo + "-Inut.xml";
        try {
            MaximaFile.escreveTexto((String)caminhoArquivo, xmlRetorno);
        }
        catch (IOException ex) {
            Logger.getLogger(NFCeServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void downloadXml(String chaveAcesso) throws MaximaException {
        Configuracao conf = this.configuracaoRepository.load();
        try {
            new MaximaCertificado().loadCertificado(conf.getAliasCertificado(), conf.getSenhaCertificado());
        }
        catch (Exception ex) {
            Logger.getLogger(NFCeServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException("AVISO: Falha ao carregar o certificado digital.");
        }
    }

    @Transactional(readOnly=true)
    public Integer getProximoNumero(String serie) throws MaximaException {
        try {
            Integer numeroSerie = Integer.valueOf(serie);
            List numero = this.nFCeRepository.getUltimoNumero(numeroSerie, NFeStatus.AUTORIZADA, (Pageable)PageRequest.of((int)0, (int)1));
            if (numero == null || numero.isEmpty()) {
                return 1;
            }
            return Integer.parseInt((String)numero.get(0)) + 1;
        }
        catch (NumberFormatException numberFormatException) {
            throw new MaximaException("ERRO: N\u00famero de s\u00e9rie inv\u00e1lido.");
        }
    }

    public void delete(NFCeCabecalho nfce) throws MaximaException {
        if (nfce == null || nfce.getId() == null) {
            return;
        }
        Optional cupom = this.nFCeRepository.findById((Object)nfce.getId());
        if (!cupom.isPresent()) {
            return;
        }
        nfce = (NFCeCabecalho)cupom.get();
        NFCeEmitente emitente = this.nFCeEmitenteRepository.get(nfce.getId().longValue());
        this.nFCeEmitenteRepository.delete((Object)emitente);
        NFCeDestinatario destinatario = this.nFCeDestinatarioRepository.get(nfce.getId().longValue());
        if (destinatario != null) {
            this.nFCeDestinatarioRepository.delete((Object)destinatario);
        }
        List produtos = this.nFCeDetalheRepository.lista(nfce.getId().longValue());
        produtos.forEach(produto -> this.nFCeDetalheRepository.delete(produto));
        List pagamentos = this.nFCePagamentoRepository.lista(nfce.getId().longValue());
        pagamentos.forEach(pgto -> this.nFCePagamentoRepository.delete(pgto));
        VendaProduto vendaProduto = this.vendaProdutoRepository.getByNFCe(nfce.getId());
        vendaProduto.setNfce(null);
        this.vendaProdutoRepository.save((Object)vendaProduto);
        this.nFCeRepository.delete((Object)nfce);
    }

    @Transactional(readOnly=true)
    public List<NFCeCabecalho> lista(LocalDateTime dataInicio, LocalDateTime dataFim, String filtro) {
        return this.nFCeRepository.lista(dataInicio, dataFim, filtro, "%" + filtro + "%");
    }

    @Transactional(readOnly=true)
    public void imprime(NFCeCabecalho nfce, Configuracao conf) throws MaximaException {
        NFNotaProcessada notaProcessada;
        try {
            notaProcessada = (NFNotaProcessada)new DFPersister().read(NFNotaProcessada.class, nfce.getXmlTxt());
        }
        catch (Exception ex) {
            Logger.getLogger(NFCeController.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException("AVISO: Ocorreu um erro ao converter o arquivo xml em objeto para impress\u00e3o.");
        }
        NFCeImpressao nFCeImpressao = new NFCeImpressao();
        try {
            new MaximaImpressao(conf).printCupomNFCe(nFCeImpressao.getTextoCupom(notaProcessada), notaProcessada.getNota().getInfoSuplementar().getQrCode(), nFCeImpressao.getTributosIbpt(new BigDecimal(notaProcessada.getNota().getInfo().getTotal().getIcmsTotal().getValorTotalTributos())));
        }
        catch (MaximaValidacaoException ex) {
            Logger.getLogger(NFCeController.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException("AVISO: Ocorreu um erro ao imprimir cupom fiscal.\n" + ex.getMessage());
        }
    }
}

