/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.nfe.controller;

import br.com.maximasolutions.administrativo.core.PermissaoControleValida;
import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.modelo.PermissaoControleAcao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.controller.GetNumeroFormController;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaFile;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaResposta;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.core.PrintReport;
import br.com.maximasolutions.estoque.controller.VendaProdutoPesquisaController;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.modelo.VendaProdutoItem;
import br.com.maximasolutions.estoque.service.VendaProdutoService;
import br.com.maximasolutions.fiscal.modelo.NFeCabecalho;
import br.com.maximasolutions.fiscal.modelo.NFeDestinatario;
import br.com.maximasolutions.fiscal.modelo.NFeDetalhe;
import br.com.maximasolutions.fiscal.modelo.NFeEmitente;
import br.com.maximasolutions.fiscal.modelo.NFeStatus;
import br.com.maximasolutions.fiscal.modelo.Ncm;
import br.com.maximasolutions.fiscal.service.NcmService;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.javafx.formatter.ColumnDateFormatter;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.nfe.controller.NFeInutilizacaoXml;
import br.com.maximasolutions.nfe.controller.NotaFiscalController;
import br.com.maximasolutions.nfe.controller.NotaFiscalFormController;
import br.com.maximasolutions.nfe.service.NotaFiscalService;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFTipoEmissao;
import com.fincatto.documentofiscal.nfe400.classes.NFFinalidade;
import com.fincatto.documentofiscal.nfe400.classes.NFIndicadorFormaPagamento;
import com.fincatto.documentofiscal.nfe400.classes.NFModalidadeFrete;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoSituacaoTributariaCOFINS;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoSituacaoTributariaPIS;
import com.fincatto.documentofiscal.nfe400.classes.NFTipo;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFOperacaoConsumidorFinal;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import net.sf.jasperreports.engine.JRException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class NotaFiscalController
extends MaximaController
implements Initializable {
    @FXML
    private Button btnNovo;
    @FXML
    private Button btnImprime;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnImportaVenda;
    @FXML
    private Button btnExporta;
    @FXML
    private Button btnEmail;
    @FXML
    private Button btnInutilizar;
    @FXML
    private Button btnClonar;
    @FXML
    private TableView<NFeCabecalho> tabela;
    @FXML
    private TableColumn<NFeCabecalho, String> colSerie;
    @FXML
    private TableColumn<NFeCabecalho, String> colNumero;
    @FXML
    private TableColumn<NFeCabecalho, String> colData;
    @FXML
    private TableColumn<NFeCabecalho, String> colNaturezaOperacao;
    @FXML
    private TableColumn<NFeCabecalho, String> colDestinatario;
    @FXML
    private TableColumn<NFeCabecalho, String> colStatus;
    @FXML
    private TableColumn<NFeCabecalho, BigDecimal> colValor;
    @FXML
    private DatePicker tfInicio;
    @FXML
    private DatePicker tfFim;
    @FXML
    private TextField tfFiltro;
    @FXML
    private Button btnPesquisa;
    @FXML
    private Label lblTotal;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private NotaFiscalService notaFiscalService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private VendaProdutoService vendaProdutoService;
    @Autowired
    private UsuarioService usuarioService;
    @Autowired
    private NcmService ncmService;
    private ObservableList<NFeCabecalho> notaFiscalList;
    private Configuracao conf;

    public void initialize(URL url, ResourceBundle rb) {
        this.conf = this.configuracaoService.load();
        this.carregaIcones();
        this.tfInicio.setValue((Object)LocalDate.now());
        this.tfFim.setValue((Object)MaximaDate.getUltimoDiaMes());
        this.notaFiscalList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.detalhaNota();
            }
        });
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
    }

    public void inicializa() {
        this.acoes = this.usuarioService.acoes(this.stageManager.getUsuario(), PermissaoControle.NotaFiscal);
    }

    private void deleteNota() {
        NFeCabecalho notaFiscal = (NFeCabecalho)this.tabela.getSelectionModel().getSelectedItem();
        if (notaFiscal == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma nota fiscal para excluir.");
            return;
        }
        if (!notaFiscal.getStatusNota().equals((Object)NFeStatus.EM_DIGITACAO)) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Nota fiscal n\u00e3o pode ser exclu\u00edda.");
            return;
        }
        if (!MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)("Deseja remover a NF-e: " + notaFiscal.getNumero() + " ?"))) {
            return;
        }
        try {
            this.notaFiscalService.delete(notaFiscal);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Nota fiscal exclu\u00edda com sucesso.");
            this.loadTabela();
        }
        catch (MaximaValidacaoException ex) {
            Logger.getLogger(NotaFiscalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void detalhaNota() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.NFE_EMITIR).booleanValue()) {
            return;
        }
        NFeCabecalho notaFiscal = (NFeCabecalho)this.tabela.getSelectionModel().getSelectedItem();
        if (notaFiscal == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma nota fiscal para detalhar.");
            return;
        }
        this.abreForm(notaFiscal);
        this.loadTabela();
    }

    private void novaNota() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.NFE_EMITIR).booleanValue()) {
            return;
        }
        this.abreForm(null);
        this.loadTabela();
    }

    private void abreForm(NFeCabecalho nfe) {
        try {
            Stage notaFiscalForm = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/fiscal/nfe/NotaFiscalForm.fxml", "Nota Fiscal NF-e");
            NotaFiscalFormController controller = (NotaFiscalFormController)notaFiscalForm.getUserData();
            controller.inicializa(notaFiscalForm.getScene());
            if (!controller.inicializa(nfe)) {
                return;
            }
            notaFiscalForm.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(NotaFiscalController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("ERRO: N\u00e3o \u00e9 poss\u00edvel abrir o formul\u00e1rio de nota fiscal.\n" + ex.getMessage()));
        }
    }

    private void setColumnProperties() {
        this.colSerie.setCellValueFactory((Callback)new PropertyValueFactory("serie"));
        this.colNumero.setCellValueFactory((Callback)new PropertyValueFactory("numero"));
        this.colData.setCellValueFactory((Callback)new PropertyValueFactory("dataEmissao"));
        this.colNaturezaOperacao.setCellValueFactory((Callback)new PropertyValueFactory("naturezaOperacao"));
        this.colDestinatario.setCellValueFactory((Callback)new PropertyValueFactory("destinatario"));
        this.colStatus.setCellValueFactory((Callback)new PropertyValueFactory("statusNota"));
        this.colValor.setCellValueFactory((Callback)new PropertyValueFactory("valorTotal"));
        this.colData.setCellFactory((Callback)new ColumnDateFormatter());
        this.colValor.setCellFactory((Callback)new ColumnNumberFormatter());
        this.lblTotal.setAlignment(Pos.CENTER_RIGHT);
    }

    private void loadTabela() {
        this.notaFiscalList.clear();
        LocalDate inicio = (LocalDate)this.tfInicio.getValue();
        LocalDate fim = (LocalDate)this.tfFim.getValue();
        if (inicio == null || fim == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Informe a data de in\u00edcio e fim para pesquisa.");
            return;
        }
        if (inicio.isAfter(fim)) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"A data de in\u00edcio deve ser igual ou anterior a data final.");
            return;
        }
        String filtro = "%";
        if (this.tfFiltro.getText() != null) {
            filtro = filtro + this.tfFiltro.getText().trim();
        }
        filtro = filtro + "%";
        List list = this.notaFiscalService.lista(inicio, fim, filtro);
        BigDecimal valorNotasAutorizadas = BigDecimal.ZERO;
        this.notaFiscalList.addAll((Collection)list);
        this.tabela.setItems(this.notaFiscalList);
        for (NFeCabecalho nfe : list) {
            if (!nfe.getStatusNota().equals((Object)NFeStatus.AUTORIZADA)) continue;
            valorNotasAutorizadas = valorNotasAutorizadas.add(nfe.getValorTotal());
        }
        this.lblTotal.setText("R$ " + MaximaNumber.bigDecimalToString((BigDecimal)valorNotasAutorizadas, (int)2));
    }

    private void carregaIcones() {
        this.btnNovo.setGraphic((Node)new MaximaIcone().getIconeNovo());
        this.btnPesquisa.setGraphic((Node)new MaximaIcone().getPesquisa());
    }

    private void clonar() {
        try {
            NFeCabecalho notaFiscal = (NFeCabecalho)this.tabela.getSelectionModel().getSelectedItem();
            if (notaFiscal == null) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma nota fiscal para clonar.");
                return;
            }
            notaFiscal.setStatusNota(NFeStatus.EM_DIGITACAO);
            NFeDestinatario destinatario = this.notaFiscalService.getDestinatario(notaFiscal);
            destinatario.setId(null);
            NFeEmitente emitente = this.notaFiscalService.getEmitente(notaFiscal);
            emitente.setId(null);
            List produtos = this.notaFiscalService.listaProdutos(notaFiscal);
            for (NFeDetalhe det : produtos) {
                det.setId(null);
            }
            notaFiscal.setId(null);
            String serie = MaximaConfig.getInstance().getProperty("nfserie", "01");
            notaFiscal.setNumero(this.notaFiscalService.getProximoNumero(MaximaUtils.completaZeroEsquerda((String)serie, (Integer)2)).toString());
            this.notaFiscalService.salva(notaFiscal, emitente, destinatario, produtos, new ArrayList(), new ArrayList(), null, null);
            this.loadTabela();
        }
        catch (MaximaValidacaoException ex) {
            Logger.getLogger(NotaFiscalController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ops, ocorreu um erro ao duplicar NF-e.");
        }
    }

    private void imprimeNota() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.NFE_IMPRIMIR).booleanValue()) {
            return;
        }
        NFeCabecalho notaFiscal = (NFeCabecalho)this.tabela.getSelectionModel().getSelectedItem();
        if (notaFiscal == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma nota fiscal para detalhar.");
            return;
        }
        String arquivoXml = "danfe.xml";
        File file = new File(arquivoXml);
        try (FileOutputStream out = new FileOutputStream(file);){
            ((OutputStream)out).write(notaFiscal.getXmlTxt().getBytes("UTF-8"));
        }
        catch (Exception ex) {
            Logger.getLogger(NotaFiscalController.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (!file.exists()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"N\u00e3o foi poss\u00edvel carregar o arquivo XML.");
            return;
        }
        try {
            new PrintReport().showDanfe(file);
        }
        catch (ClassNotFoundException | SQLException | JRException ex) {
            Logger.getLogger(NotaFiscalController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: N\u00e3o foi poss\u00edvel visualizar nota fiscal.\n" + ex.getMessage()));
        }
    }

    private void importaVenda() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.NFE_EMITIR).booleanValue()) {
            return;
        }
        try {
            Stage formPesquisa = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/vendaProduto/VendaProdutoPesquisa.fxml", "Pesquisar venda");
            VendaProdutoPesquisaController controller = (VendaProdutoPesquisaController)formPesquisa.getUserData();
            controller.inicializa(Boolean.valueOf(true));
            formPesquisa.showAndWait();
            VendaProduto vendaProduto = controller.getVendaProduto();
            if (vendaProduto == null) {
                return;
            }
            List itens = this.vendaProdutoService.listItens(vendaProduto);
            ArrayList<VendaProdutoItem> produtos = new ArrayList<VendaProdutoItem>();
            for (VendaProdutoItem item : itens) {
                if (item.getProduto().getServico().booleanValue()) continue;
                produtos.add(item);
            }
            if (this.conf.getAgruparItensImpressao().booleanValue()) {
                // empty if block
            }
            if (!this.validaVenda(vendaProduto, produtos)) {
                return;
            }
            ArrayList documentos = new ArrayList();
            ArrayList cobrancas = new ArrayList();
            this.notaFiscalService.salva(this.getNFe(vendaProduto, produtos), this.getEmitente(), this.getDestinatario(vendaProduto.getCliente()), this.getItensNFe(vendaProduto, produtos), cobrancas, documentos, null, null);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Venda importada para nota fiscal com sucesso.");
            this.loadTabela();
        }
        catch (IOException ex) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel abrir a pesquisa de vendas para emiss\u00e3o de nota fiscal.");
        }
        catch (MaximaException | MaximaValidacaoException ex) {
            Logger.getLogger(NotaFiscalController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("ERRO: N\u00e3o foi poss\u00edvel converter a venda em nota fiscal.\n" + ex.getMessage()));
        }
    }

    private boolean validaVenda(VendaProduto venda, List<VendaProdutoItem> itens) {
        String cep;
        String bairro;
        String numero;
        String msg = "";
        String cpf = MaximaUtils.removeCaracteres((String)venda.getCliente().getCpf());
        if (cpf == null || cpf.isEmpty()) {
            msg = "CPF/CNPJ: campo obrigat\u00f3rio n\u00e3o informado.\n";
        } else if (cpf.length() != 11 && cpf.length() != 14) {
            msg = "CPF/CNPJ: campo preenchido incorretamente.\n";
        }
        String endereco = MaximaUtils.removeAcentos((String)venda.getCliente().getEndereco());
        if (endereco == null || endereco.isEmpty()) {
            msg = msg + "ENDERE\u00c7O: campo obrigat\u00f3rio n\u00e3o informado.\n";
        }
        if ((numero = MaximaUtils.removeAcentos((String)venda.getCliente().getNumero())) == null || numero.isEmpty()) {
            msg = msg + "N\u00daMERO: campo obrigat\u00f3rio n\u00e3o informado.\n";
        }
        if ((bairro = MaximaUtils.removeAcentos((String)venda.getCliente().getBairro())) == null || bairro.isEmpty()) {
            msg = msg + "BAIRRO: campo obrigat\u00f3rio n\u00e3o informado.\n";
        }
        if ((cep = MaximaUtils.removeCaracteres((String)venda.getCliente().getCep())) == null || cep.isEmpty()) {
            msg = msg + "CEP: campo obrigat\u00f3rio n\u00e3o informado.\n";
        }
        if (venda.getCliente().getMunicipio() == null) {
            msg = msg + "MUNIC\u00cdPIO: campo obrigat\u00f3rio n\u00e3o informado.\n";
        }
        for (VendaProdutoItem i : itens) {
            Produto p = i.getProduto();
            if (p.getNcm() == null || p.getNcm().isEmpty() || p.getNcm().equals("00000000")) {
                msg = msg + "PRODUTO [ " + p.getNome() + " ]: ncm n\u00e3o informado.\n";
            }
            if (p.getIcmsSN() == null) {
                msg = msg + "PRODUTO [ " + p.getNome() + " ]: tributa\u00e7\u00e3o n\u00e3o configurada.\n";
            }
            if (p.getOrigem() != null) continue;
            msg = msg + "PRODUTO [ " + p.getNome() + " ]: origem (fiscal) n\u00e3o informada.\n";
        }
        if (!msg.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: N\u00e3o \u00e9 poss\u00edvel importar a venda.\n" + msg));
            return false;
        }
        return true;
    }

    private void exportaNota() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.NFE_IMPRIMIR).booleanValue()) {
            return;
        }
        NFeCabecalho nf = (NFeCabecalho)this.tabela.getSelectionModel().getSelectedItem();
        if (nf == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma nota fiscal para exportar.");
            return;
        }
        String path = MaximaConfig.getInstance().getProperty("fileexport", "C:/Maxima/");
        try {
            MaximaFile.validaDiretorio((String)path);
        }
        catch (MaximaException ex) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
            return;
        }
        String filePdf = path + nf.getNumero() + "-" + nf.getChaveAcesso() + nf.getDigitoChaveAcesso() + "-NFe.pdf";
        String fileXml = path + nf.getNumero() + "-" + nf.getChaveAcesso() + nf.getDigitoChaveAcesso() + "-NFe.xml";
        try {
            PrintReport.exportaPdfXml((String)nf.getXmlTxt(), (String)filePdf, (String)fileXml);
            MaximaAlert.informe((StageManager)this.stageManager, (String)("Arquivos exportados para a pasta: " + path));
        }
        catch (MaximaException ex) {
            Logger.getLogger(NotaFiscalController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void enviaEmail(Stage progress, NFeCabecalho nfe) {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.NFE_IMPRIMIR).booleanValue()) {
            return;
        }
        if (!this.conf.senEmailValido().booleanValue()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Configura\u00e7\u00e3o de e-mail n\u00e3o efetuada.");
            return;
        }
        if (nfe.getCliente().getEmail() == null || nfe.getCliente().getEmail().isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"E-mail do cliente n\u00e3o informado.");
            return;
        }
        1 service = new /* Unavailable Anonymous Inner Class!! */;
        service.setOnSucceeded(arg_0 -> this.lambda$enviaEmail$1(progress, (Service)service, arg_0));
        service.setOnFailed(e -> {});
        service.start();
    }

    private void inutilizarNumero() {
        String xml;
        Integer numero = null;
        try {
            Stage form = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.btnInutilizar.getScene().getWindow(), "/fxml/GetNumeroForm.fxml", "");
            GetNumeroFormController controller = (GetNumeroFormController)form.getUserData();
            form.showAndWait();
            Long retorno = controller.getNumero();
            if (retorno != null) {
                numero = retorno.intValue();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(NotaFiscalController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: Falha ao abrir form get n\u00famero.");
            return;
        }
        if (numero == null) {
            return;
        }
        String cnpj = MaximaUtils.removeCaracteres((String)this.conf.getEmpresaNFe().getCpf());
        DFUnidadeFederativa uf = DFUnidadeFederativa.valueOfCodigo((String)this.conf.getEmpresaNFe().getMunicipio().getEstado().getSigla());
        String serie = MaximaConfig.getInstance().getProperty("nfserie", "1");
        try {
            xml = new NFeInutilizacaoXml().geraXml(cnpj, serie, String.valueOf(numero), uf, this.conf);
        }
        catch (Exception ex) {
            Logger.getLogger(NotaFiscalController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("ERRO: N\u00e3o foi poss\u00edvel gerar o XML de inutiliza\u00e7\u00e3o.\n" + ex.getMessage()));
            return;
        }
        try {
            MaximaFile.escreveTexto((String)"C:/Maxima/inut.txt", (String)xml);
        }
        catch (IOException ex) {
            Logger.getLogger(NotaFiscalController.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            this.notaFiscalService.inutiliza(xml);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Inutiliza\u00e7\u00e3o efetuada com sucesso.");
        }
        catch (MaximaException ex) {
            Logger.getLogger(NotaFiscalController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("ERRO: N\u00e3o foi poss\u00edvel transmitir inutiliza\u00e7\u00e3o da NFCe.\n" + ex.getMessage()));
        }
    }

    private void registraAcoes() {
        this.btnInutilizar.setOnAction(evt -> this.inutilizarNumero());
        this.btnEmail.setOnAction(evt -> {
            NFeCabecalho nfe = (NFeCabecalho)this.tabela.getSelectionModel().getSelectedItem();
            if (nfe == null) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Selecione uma nota fiscal para enviar por e-mail.");
                return;
            }
            Stage progress = new MaximaDialogFX().progress(this.stageManager, "Enviando nota fiscal por e-mail.......");
            progress.show();
            this.enviaEmail(progress, nfe);
        });
        this.btnExporta.setOnAction(evt -> this.exportaNota());
        this.btnImportaVenda.setOnAction(evt -> this.importaVenda());
        this.btnDelete.setOnAction(evt -> this.deleteNota());
        this.btnImprime.setOnAction(evt -> this.imprimeNota());
        this.btnNovo.setOnAction(event -> this.novaNota());
        this.btnPesquisa.setOnAction(event -> this.loadTabela());
        this.btnClonar.setOnAction(event -> this.clonar());
        this.tfFiltro.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.loadTabela();
            }
        });
    }

    private NFeCabecalho getNFe(VendaProduto vendaProduto, List<VendaProdutoItem> itens) {
        String serie = MaximaConfig.getInstance().getProperty("nfserie", "01");
        NFeCabecalho nfe = new NFeCabecalho();
        nfe.setEmpresa(this.conf.getEmpresaNFe());
        try {
            nfe.setNumero(this.notaFiscalService.getProximoNumero(serie).toString());
        }
        catch (MaximaValidacaoException ex) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: N\u00e3o foi poss\u00edvel carregar n\u00famero da nota fiscal.\n" + ex.getMessage()));
        }
        BigDecimal valorDesconto = BigDecimal.ZERO;
        BigDecimal valorProdutos = BigDecimal.ZERO;
        BigDecimal valorTotal = BigDecimal.ZERO;
        for (VendaProdutoItem item : itens) {
            valorDesconto = valorDesconto.add(item.getDesconto());
            valorProdutos = valorProdutos.add(item.getPrecoUnitario().multiply(item.getQuantidade()).setScale(2, RoundingMode.HALF_EVEN));
            valorTotal = valorTotal.add(item.getPrecoTotal());
        }
        String naturezaOperacao = this.conf.getNfeNaturezaOperacao();
        if (naturezaOperacao == null || naturezaOperacao.isEmpty()) {
            naturezaOperacao = "VENDA";
        }
        nfe.setDataEmissao(LocalDate.now());
        nfe.setDataEntradaSaida(null);
        nfe.setHoraEntradaSaida(null);
        nfe.setCodigoModelo("55");
        nfe.setTipoOperacao(NFTipo.SAIDA);
        nfe.setFinalidadeEmissao(NFFinalidade.NORMAL);
        nfe.setTipoEmissao(NFTipoEmissao.EMISSAO_NORMAL);
        nfe.setNaturezaOperacao(naturezaOperacao);
        nfe.setStatusNota(NFeStatus.EM_DIGITACAO);
        nfe.setSerie(MaximaUtils.completaZeroEsquerda((String)serie, (Integer)2));
        nfe.setValorFrete(BigDecimal.ZERO);
        nfe.setValorDespesasAcessorias(BigDecimal.ZERO);
        nfe.setValorSeguro(BigDecimal.ZERO);
        nfe.setValorDesconto(valorDesconto);
        nfe.setValorTotal(valorTotal);
        nfe.setValorTotalProdutos(valorProdutos);
        nfe.setInformacoesAddContribuinte(this.conf.getInfContNfe());
        nfe.setBaseCalculoIcms(BigDecimal.ZERO);
        nfe.setValorIpi(BigDecimal.ZERO);
        nfe.setValorCofins(BigDecimal.ZERO);
        nfe.setValorPis(BigDecimal.ZERO);
        nfe.setValorIcms(BigDecimal.ZERO);
        nfe.setBaseCalculoIcmsSt(BigDecimal.ZERO);
        nfe.setValorIcmsSt(BigDecimal.ZERO);
        nfe.setConsumidorFinal(NFOperacaoConsumidorFinal.SIM);
        nfe.setCliente(vendaProduto.getCliente());
        nfe.setCondicaoPagamento(NFIndicadorFormaPagamento.A_VISTA);
        nfe.setFormaPagamento(null);
        nfe.setModalidadeFrete(NFModalidadeFrete.SEM_OCORRENCIA_TRANSPORTE);
        String obsVenda = vendaProduto.getObservacao();
        obsVenda = obsVenda == null ? "" : "#" + obsVenda;
        if (vendaProduto.getSatCFe() != null) {
            obsVenda = obsVenda + "#Cupom SAT: " + vendaProduto.getSatCFe().getChaveAcesso();
            nfe.setCupomSatRef(vendaProduto.getSatCFe().getChaveAcesso().replace(" ", ""));
        }
        nfe.setInformacoesAddContribuinte(this.conf.getInfContNfe() + obsVenda);
        return nfe;
    }

    private NFeDestinatario getDestinatario(Cliente cliente) {
        NFeDestinatario destinatario = new NFeDestinatario();
        destinatario.setBairro(MaximaUtils.getText((String)cliente.getBairro()));
        destinatario.setCep(MaximaUtils.removeCaracteres((String)cliente.getCep()));
        destinatario.setCodigoMunicipio(Integer.valueOf(Integer.parseInt(cliente.getMunicipio().getCodigoIBGE())));
        destinatario.setCodigoPais(Integer.valueOf(1058));
        if (cliente.getComplemento() != null && !cliente.getComplemento().isEmpty()) {
            destinatario.setComplemento(MaximaUtils.getText((String)cliente.getComplemento()));
        }
        destinatario.setCpfCnpj(MaximaUtils.removeCaracteres((String)cliente.getCpf()));
        if (cliente.getEmail() != null && !cliente.getEmail().isEmpty()) {
            destinatario.setEmail(MaximaUtils.getText((String)cliente.getEmail()));
        }
        if (cliente.getFantasia() != null && !cliente.getFantasia().isEmpty()) {
            destinatario.setFantasia(MaximaUtils.getText((String)cliente.getFantasia()));
        }
        destinatario.setIe(MaximaUtils.removeCaracteres((String)cliente.getRg()));
        destinatario.setLogradouro(MaximaUtils.getText((String)cliente.getEndereco()));
        destinatario.setMunicipio(cliente.getMunicipio());
        destinatario.setNomeMunicipio(MaximaUtils.getText((String)cliente.getMunicipio().getNome()));
        destinatario.setNomePais("BRASIL");
        destinatario.setNumero(MaximaUtils.getText((String)cliente.getNumero()));
        destinatario.setRazaoSocial(MaximaUtils.limitaTexto((String)MaximaUtils.getText((String)cliente.getNome()), (int)60));
        if (cliente.getTelefone() != null && !cliente.getTelefone().isEmpty()) {
            destinatario.setTelefone(MaximaUtils.removeCaracteres((String)cliente.getTelefone()));
        }
        destinatario.setUf(cliente.getMunicipio().getEstado().getSigla());
        return destinatario;
    }

    private NFeEmitente getEmitente() {
        if (this.conf == null || this.conf.getEmpresaNFe() == null) {
            return null;
        }
        NFeEmitente emitente = new NFeEmitente();
        emitente.setBairro(MaximaUtils.getText((String)this.conf.getEmpresaNFe().getBairro()));
        emitente.setCep(MaximaUtils.removeCaracteres((String)this.conf.getEmpresaNFe().getCep()));
        emitente.setCodigoMunicipio(Integer.valueOf(Integer.parseInt(this.conf.getEmpresaNFe().getMunicipio().getCodigoIBGE())));
        emitente.setCodigoPais(Integer.valueOf(1058));
        emitente.setCpfCnpj(MaximaUtils.removeCaracteres((String)this.conf.getEmpresaNFe().getCpf()));
        if (this.conf.getEmpresaNFe().getFantasia() != null && !this.conf.getEmpresaNFe().getFantasia().isEmpty()) {
            emitente.setFantasia(MaximaUtils.getText((String)this.conf.getEmpresaNFe().getFantasia()));
        }
        emitente.setIe(MaximaUtils.removeCaracteres((String)this.conf.getEmpresaNFe().getRg()));
        emitente.setLogradouro(MaximaUtils.getText((String)this.conf.getEmpresaNFe().getEndereco()));
        emitente.setMunicipio(this.conf.getEmpresaNFe().getMunicipio());
        emitente.setNomeMunicipio(MaximaUtils.getText((String)this.conf.getEmpresaNFe().getMunicipio().getNome()));
        emitente.setNomePais("BRASIL");
        emitente.setNumero(MaximaUtils.getText((String)this.conf.getEmpresaNFe().getNumero()));
        emitente.setRazaoSocial(MaximaUtils.limitaTexto((String)MaximaUtils.getText((String)this.conf.getEmpresaNFe().getNome()), (int)60));
        if (this.conf.getEmpresaNFe().getTelefone() != null && !this.conf.getEmpresaNFe().getTelefone().isEmpty()) {
            emitente.setTelefone(MaximaUtils.removeCaracteres((String)this.conf.getEmpresaNFe().getTelefone()));
        }
        emitente.setUf(this.conf.getEmpresaNFe().getMunicipio().getEstado().getSigla());
        return emitente;
    }

    private List<NFeDetalhe> getItensNFe(VendaProduto vendaProduto, List<VendaProdutoItem> list) throws MaximaException {
        ArrayList<NFeDetalhe> itens = new ArrayList<NFeDetalhe>();
        int count = 1;
        for (VendaProdutoItem v : list) {
            NFeDetalhe item = new NFeDetalhe();
            item.setProduto(v.getProduto());
            if (vendaProduto.getCliente().getMunicipio().getEstado().getSigla().equals(this.conf.getEmpresaNFe().getMunicipio().getEstado().getSigla())) {
                if (vendaProduto.getSatCFe() != null) {
                    item.setCfop(Integer.valueOf(5929));
                } else {
                    item.setCfop(Integer.valueOf(v.getProduto().getCfop()));
                }
            } else if (vendaProduto.getSatCFe() != null) {
                item.setCfop(Integer.valueOf(5929));
            } else {
                item.setCfop(Integer.valueOf(v.getProduto().getCfopInterEstad()));
            }
            item.setCodigoProduto(v.getProduto().getCodigo());
            item.setNcm(v.getProduto().getNcm());
            item.setGtin(null);
            item.setGtinUnidadeTributavel(null);
            item.setNomeProduto(v.getDescricao());
            item.setOrigemMercadoria(v.getProduto().getOrigem().getCodigo());
            item.setQuantidadeComercial(v.getQuantidade());
            item.setUnidadeComercial(v.getProduto().getUnidade().getSigla().toUpperCase());
            item.setValorBrutoProdutos(v.getPrecoTotalBruto());
            item.setValorUnitarioComercial(v.getPrecoUnitario());
            item.setValorTotal(v.getPrecoTotal());
            item.setValorDesconto(v.getDesconto());
            item.setUnidadeTributavel(v.getProduto().getUnidade().getSigla().toUpperCase());
            item.setQuantidadeTributavel(item.getQuantidadeComercial());
            item.setValorUnitarioTributacao(item.getValorUnitarioComercial());
            item.setValorSubtotal(v.getPrecoTotal());
            item.setCsosn(v.getProduto().getIcmsSN().getCodigo());
            item.setInformacoesAdicionais(v.getObservacao());
            if (v.getProduto().getPis().equals((Object)NFNotaInfoSituacaoTributariaPIS.OPERACAO_ISENTA_CONTRIBUICAO) || v.getProduto().getPis().equals((Object)NFNotaInfoSituacaoTributariaPIS.OPERACAO_SEM_INCIDENCIA_CONTRIBUICAO) || v.getProduto().getPis().equals((Object)NFNotaInfoSituacaoTributariaPIS.OPERACAO_TRIBUTAVEL_MONOFASICA_ALIQUOTA_ZERO)) {
                item.setValorBaseCalculoPis(BigDecimal.ZERO);
                item.setAliquotaPisPercentual(BigDecimal.ZERO);
                item.setValorPis(BigDecimal.ZERO);
                item.setCstPis(v.getProduto().getPis().getCodigo());
            }
            if (v.getProduto().getCofins().equals((Object)NFNotaInfoSituacaoTributariaCOFINS.OPERACAO_ISENTA_CONTRIBUICAO) || v.getProduto().getCofins().equals((Object)NFNotaInfoSituacaoTributariaCOFINS.OPERACAO_SEM_INCIDENCIA_CONTRIBUICAO) || v.getProduto().getCofins().equals((Object)NFNotaInfoSituacaoTributariaCOFINS.OPERACAO_TRIBUTAVEL_MONOFASICA_ALIQUOTA_ZERO)) {
                item.setCstCofins(v.getProduto().getCofins().getCodigo());
                item.setBaseCalculoCofins(BigDecimal.ZERO);
                item.setAliquotaCofinsPercentual(BigDecimal.ZERO);
                item.setValorCofins(BigDecimal.ZERO);
            }
            item.setNumeroItem(Integer.valueOf(count));
            try {
                Ncm ncm = this.ncmService.loadByNCM(Long.parseLong(item.getNcm()));
                if (ncm == null) {
                    throw new MaximaException("NCM n\u00e3o encontrado na tabela do banco de dados.");
                }
                item.setTributoNacional(ncm.getAliqNac().multiply(item.getValorTotal()).divide(new BigDecimal("100"), 2, RoundingMode.HALF_UP));
                item.setTributoEstadual(ncm.getAliqEstadual().multiply(item.getValorTotal()).divide(new BigDecimal("100"), 2, RoundingMode.HALF_UP));
            }
            catch (NumberFormatException numberFormatException) {
                throw new MaximaException("NCM n\u00e3o encontrado na tabela do banco de dados.");
            }
            itens.add(item);
            ++count;
        }
        return itens;
    }

    private /* synthetic */ void lambda$enviaEmail$1(Stage progress, Service service, Event e) {
        progress.close();
        MaximaResposta retorno = (MaximaResposta)service.getValue();
        if (retorno.getSucesso().booleanValue()) {
            MaximaAlert.informe((StageManager)this.stageManager, (String)retorno.getMensagem());
        } else {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)retorno.getMensagem());
        }
    }

    static /* synthetic */ Configuracao access$000(NotaFiscalController x0) {
        return x0.conf;
    }
}

