/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.nfe.relatorio.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaRelatorio;
import br.com.maximasolutions.core.PrintReport;
import br.com.maximasolutions.nfe.relatorio.bean.RelatorioCupomFiscalBean;
import br.com.maximasolutions.sat.modelo.SatCFe;
import br.com.maximasolutions.sat.service.SatCFeService;
import br.com.maximasolutions.utils.MaximaDate;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class RelatorioSATController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private SatCFeService satCFeService;
    @FXML
    private Button btnGeraRelatorio;
    @FXML
    private DatePicker tfDataInicial;
    @FXML
    private DatePicker tfDataFinal;
    private BigDecimal total;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.loadCombos();
        this.loadMascaras();
        this.inicializa();
    }

    public void inicializa() {
    }

    private void geraRelatorio() {
        if (!this.validaForm()) {
            return;
        }
        List notas = this.satCFeService.lista((LocalDate)this.tfDataInicial.getValue(), (LocalDate)this.tfDataFinal.getValue(), "%%");
        if (notas == null || notas.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum registro encontrado para o filtro informado.");
            return;
        }
        ArrayList<RelatorioCupomFiscalBean> beanList = new ArrayList<RelatorioCupomFiscalBean>();
        for (SatCFe cf : notas) {
            RelatorioCupomFiscalBean bean = new RelatorioCupomFiscalBean();
            bean.setCpfCnpj(cf.getCpfCnpjDest());
            bean.setData(MaximaDate.getData((LocalDate)cf.getDataEmissao()));
            bean.setNumero(cf.getNumeroCupom());
            bean.setTotal(cf.getTotal());
            beanList.add(bean);
        }
        this.calculaTotal(notas);
        Configuracao conf = this.configuracaoService.load();
        try {
            Map params = new MaximaRelatorio().getParametros(conf, Boolean.valueOf(false));
            params.put("DESCRICAO", "RELAT\u00d3RIO DE CUPOM FISCAL - INTERVALO DE " + ((LocalDate)this.tfDataInicial.getValue()).format(DateTimeFormatter.ofPattern("dd-MM-yyyy")) + " AT\u00c9 " + ((LocalDate)this.tfDataFinal.getValue()).format(DateTimeFormatter.ofPattern("dd-MM-yyyy")));
            params.put("EMPRESA", conf.getNomeEmpresa().toUpperCase());
            JRBeanCollectionDataSource jrds = new JRBeanCollectionDataSource(beanList);
            new PrintReport().showReport("/jasper/fiscal/nfe/fiscal_sat.jasper", (JRDataSource)jrds, params);
        }
        catch (JRException ex) {
            Logger.getLogger("").log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao gerar relat\u00f3rio.\n" + ex.getMessage()));
        }
        catch (ClassNotFoundException | SQLException ex) {
            Logger.getLogger(RelatorioSATController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao gerar relat\u00f3rio.\n" + ex.getMessage()));
        }
    }

    private void calculaTotal(List<SatCFe> notas) {
        this.total = BigDecimal.ZERO;
        notas.stream().forEachOrdered(nfe -> {
            if (!nfe.getCancelado().booleanValue()) {
                this.total = this.total.add(nfe.getTotal());
            }
        });
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.tfDataInicial.getValue() == null) {
            this.tfDataInicial.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataInicial.getStyleClass().remove((Object)"error");
        }
        if (this.tfDataFinal.getValue() == null) {
            this.tfDataFinal.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataFinal.getStyleClass().remove((Object)"error");
        }
        if (valido) {
            if (((LocalDate)this.tfDataInicial.getValue()).isAfter((ChronoLocalDate)this.tfDataFinal.getValue())) {
                this.tfDataFinal.getStyleClass().add((Object)"error");
                valido = false;
            } else {
                this.tfDataFinal.getStyleClass().remove((Object)"error");
            }
        }
        return valido;
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnGeraRelatorio.setGraphic((Node)maximaIcone.getIconeConfirma());
    }

    private void loadMascaras() {
    }

    private void registraAcoes() {
        this.btnGeraRelatorio.setOnAction(t -> this.geraRelatorio());
    }

    private void loadCombos() {
    }
}

