/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.nfe.repository;

import br.com.maximasolutions.fiscal.modelo.NFeCabecalho;
import br.com.maximasolutions.fiscal.modelo.NFeStatus;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.modelo.Estado;
import com.fincatto.documentofiscal.nfe400.classes.NFTipo;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface NotaFiscalRepository
extends JpaRepository<NFeCabecalho, Long> {
    @Query(value="select o.numero from NFeCabecalho o where cast(o.serie as int) = :serie and o.excluida = false order by cast(o.numero as int) desc")
    public List<String> getUltimoNumero(@Param(value="serie") Integer var1, Pageable var2);

    @Query(value="SELECT o FROM NFeCabecalho o WHERE o.excluida = false AND (o.dataEmissao between :inicio and :fim) and o.destinatario like :filtro  ORDER BY o.dataEmissao DESC, o.numero DESC")
    public List<NFeCabecalho> lista(@Param(value="inicio") LocalDate var1, @Param(value="fim") LocalDate var2, @Param(value="filtro") String var3);

    @Query(value="SELECT SUM(o.valorTotal) FROM NFeCabecalho o WHERE o.excluida = false AND (o.dataEmissao between :inicio and :fim) and o.destinatario like :filtro")
    public BigDecimal total(@Param(value="inicio") LocalDate var1, @Param(value="fim") LocalDate var2, @Param(value="filtro") String var3);

    @Query(value="SELECT o FROM NFeCabecalho o WHERE (o.statusNota = :autorizada and o.tipoOperacao = :tipoOperacao) AND (o.dataEmissao between :dataInicio and :dataFim) order by o.dataEmissao")
    public List<NFeCabecalho> listaSped(@Param(value="dataInicio") LocalDate var1, @Param(value="dataFim") LocalDate var2, @Param(value="autorizada") NFeStatus var3, @Param(value="tipoOperacao") NFTipo var4);

    @Query(value="SELECT o.cliente FROM NFeCabecalho o WHERE (o.statusNota = :autorizada) AND (o.dataEmissao between :dataInicio and :dataFim) GROUP BY o.cliente.id")
    public List<Cliente> listaSpedClientes(@Param(value="dataInicio") LocalDate var1, @Param(value="dataFim") LocalDate var2, @Param(value="autorizada") NFeStatus var3);

    @Query(value="SELECT sum(o.valorTotal) FROM NFeCabecalho o WHERE (o.statusNota = :autorizada  and o.tipoOperacao = :tipoOperacao) AND (o.dataEmissao between :dataInicio and :dataFim)")
    public BigDecimal valorNotasSped(@Param(value="dataInicio") LocalDate var1, @Param(value="dataFim") LocalDate var2, @Param(value="autorizada") NFeStatus var3, @Param(value="tipoOperacao") NFTipo var4);

    @Query(value="SELECT sum(o.valorIcms) FROM NFeCabecalho o WHERE (o.statusNota = :autorizada  and o.tipoOperacao = :tipoOperacao) AND (o.dataEmissao between :dataInicio and :dataFim)")
    public BigDecimal valorIcmsSped(@Param(value="dataInicio") LocalDate var1, @Param(value="dataFim") LocalDate var2, @Param(value="autorizada") NFeStatus var3, @Param(value="tipoOperacao") NFTipo var4);

    @Query(value="SELECT sum(o.valorIcmsSt) FROM NFeCabecalho o WHERE (o.statusNota = :autorizada  and o.tipoOperacao = :tipoOperacao) AND (o.dataEmissao between :dataInicio and :dataFim)")
    public BigDecimal valorIcmsStSped(@Param(value="dataInicio") LocalDate var1, @Param(value="dataFim") LocalDate var2, @Param(value="autorizada") NFeStatus var3, @Param(value="tipoOperacao") NFTipo var4);

    @Query(value="SELECT sum(o.valorIcmsSt) FROM NFeCabecalho o WHERE o.cliente.municipio.estado.sigla = :uf AND (o.statusNota = :autorizada  and o.tipoOperacao = :tipoOperacao) AND (o.dataEmissao between :dataInicio and :dataFim)")
    public BigDecimal valorUfIcmsStSped(@Param(value="dataInicio") LocalDate var1, @Param(value="dataFim") LocalDate var2, @Param(value="uf") String var3, @Param(value="autorizada") NFeStatus var4, @Param(value="tipoOperacao") NFTipo var5);

    @Query(value="SELECT o.cliente.municipio.estado FROM NFeCabecalho o WHERE (o.statusNota = :autorizada ) AND (o.dataEmissao between :dataInicio and :dataFim) AND o.valorIcmsSt > 0 GROUP BY o.cliente.municipio.estado.id")
    public List<Estado> listaUfIcmsStSped(@Param(value="dataInicio") LocalDate var1, @Param(value="dataFim") LocalDate var2, @Param(value="autorizada") NFeStatus var3);

    @Query(value="SELECT o FROM NFeCabecalho o WHERE o.excluida = false AND (o.dataEmissao between :inicio and :fim) and o.statusNota = :autorizada  ORDER BY o.dataEmissao DESC, o.numero DESC")
    public List<NFeCabecalho> autorizadas(@Param(value="inicio") LocalDate var1, @Param(value="fim") LocalDate var2, @Param(value="autorizada") NFeStatus var3);

    @Query(value="SELECT o FROM NFeCabecalho o WHERE o.excluida = false AND (o.dataEmissao between :inicio and :fim) ORDER BY o.dataEmissao DESC, o.numero DESC")
    public List<NFeCabecalho> relatorio(@Param(value="inicio") LocalDate var1, @Param(value="fim") LocalDate var2);

    @Query(value="SELECT o FROM NFeCabecalho o WHERE o.excluida = false AND (o.dataEmissao between :inicio and :fim) and o.cliente.id = :clienteId ORDER BY o.dataEmissao DESC, o.numero DESC")
    public List<NFeCabecalho> relatorio(@Param(value="inicio") LocalDate var1, @Param(value="fim") LocalDate var2, @Param(value="clienteId") Long var3);
}

