/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.sat.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.controller.ProdutoPesquisaController;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.modelo.ProdutoComplemento;
import br.com.maximasolutions.estoque.modelo.ProdutoObservacao;
import br.com.maximasolutions.estoque.service.ProdutoService;
import br.com.maximasolutions.sat.controller.CupomSatFechamentoFormController;
import br.com.maximasolutions.sat.controller.SATController;
import br.com.maximasolutions.sat.core.ControleSAT;
import br.com.maximasolutions.sat.modelo.SatCFe;
import br.com.maximasolutions.sat.modelo.SatCFeItem;
import br.com.maximasolutions.sat.modelo.SatModelo;
import br.com.maximasolutions.sat.print.SatImpressaoController;
import br.com.maximasolutions.sat.service.SatCFeService;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class CupomFiscalFormController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    private Produto produtoSelecionado;
    private List<SatCFeItem> satCFeItems;
    @Autowired
    private SatCFeService satCFeService;
    @Autowired
    private ProdutoService produtoService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    private Configuracao conf;
    private List<ProdutoComplemento> complementoList;
    private List<ProdutoObservacao> observacaoList;
    @FXML
    private MenuItem btnVerificaSat;
    @FXML
    private MenuItem btnImprimeUltimoCupom;
    @FXML
    private Button btnLancarProduto;
    @FXML
    private Button btnFinalizarComanda;
    @FXML
    private TextField tfProdutoCodigo;
    @FXML
    private TextField tfProdutoDescricao;
    @FXML
    private TextField tfQuantidade;
    @FXML
    private TextField tfValorUnitario;
    @FXML
    private TableView<SatCFeItem> tabela;
    @FXML
    private TableColumn<SatCFeItem, String> colCodigo;
    @FXML
    private TableColumn<SatCFeItem, String> colNome;
    @FXML
    private TableColumn<SatCFeItem, BigDecimal> colQuantidade;
    @FXML
    private TableColumn<SatCFeItem, BigDecimal> colPrecoUnitario;
    @FXML
    private TableColumn<SatCFeItem, BigDecimal> colPrecoTotal;
    @FXML
    private Label lbTotal;
    private ControleSAT controleSAT;

    public void initialize(URL url, ResourceBundle rb) {
        this.conf = this.configuracaoService.load();
        this.carregaIcones();
    }

    private void inicializaSAT() {
        String sat = MaximaConfig.getInstance().getProperty("sat", "");
        if (sat == null || sat.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum modelo de SAT configurado.");
            return;
        }
        SatModelo satModelo = SatModelo.get((String)sat);
        if (satModelo == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Modelo de SAT n\u00e3o configurado no sistema.");
            return;
        }
        System.out.println("== MODELO SAT: " + satModelo);
        try {
            this.loadSAT(satModelo);
        }
        catch (MaximaException ex) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
            return;
        }
    }

    private void loadSAT(SatModelo satModelo) throws MaximaException {
        try {
            this.controleSAT = new ControleSAT(satModelo.getDll());
        }
        catch (UnsatisfiedLinkError e) {
            throw new MaximaException("AVISO: Falha ao carregar DLL do equipamento SAT: " + satModelo.toString() + ".");
        }
    }

    public void inicializa() {
        this.inicializaSAT();
        MaximaMask.monetaryField((TextField)this.tfValorUnitario);
        this.registaAcoes();
        this.setColumnProperties();
        this.inicializaCupom();
    }

    private void inicializaCupom() {
        this.satCFeItems = new ArrayList();
        this.inicializaItem();
    }

    private void inicializaItem() {
        this.loadTabela();
        this.produtoSelecionado = null;
        this.tfProdutoCodigo.setText("");
        this.tfProdutoDescricao.setText("");
        this.tfQuantidade.setText("");
        this.tfValorUnitario.setText("");
        this.complementoList = new ArrayList();
        this.observacaoList = new ArrayList();
        this.tfProdutoCodigo.requestFocus();
    }

    private void loadDadosProduto(Produto produto) {
        this.tfProdutoCodigo.setText(produto.getCodigo());
        this.tfProdutoDescricao.setText(produto.getNome().toUpperCase());
        this.tfValorUnitario.setText(MaximaNumber.bigDecimalToString((BigDecimal)produto.getPrecoVenda(), (int)2));
        this.produtoSelecionado = produto;
    }

    private void selecionaProduto() {
        String produtoCodigo = this.tfProdutoCodigo.getText().trim();
        if (produtoCodigo.isEmpty()) {
            return;
        }
        Produto produto = this.produtoService.getByCodigoBarras(produtoCodigo);
        if (produto != null || (produto = this.produtoService.getByCodigoBarras(produtoCodigo)) == null) {
            // empty if block
        }
        if (produto != null) {
            this.loadDadosProduto(produto);
        } else {
            this.pesquisaProdutoForm();
        }
        if (this.produtoSelecionado != null) {
            this.tfQuantidade.requestFocus();
        } else {
            this.tfProdutoCodigo.requestFocus();
        }
    }

    private void pesquisaProdutoForm() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/produto/ProdutoPesquisa.fxml", "Pesquisa de produto");
            ProdutoPesquisaController controller = (ProdutoPesquisaController)stage.getUserData();
            controller.setValorPesquisa(this.tfProdutoCodigo.getText().trim());
            stage.showAndWait();
            Produto produtoPesquisa = controller.getProdutoSelecionado();
            if (produtoPesquisa != null) {
                this.loadDadosProduto(produtoPesquisa);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(CupomFiscalFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao abrir janela de pesquisa.\n" + ex.getMessage()));
        }
    }

    private void addItem() {
        if (this.produtoSelecionado == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum produto selecionado para adicionar.");
            this.inicializaItem();
            return;
        }
        BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText().trim());
        if (quantidade.compareTo(BigDecimal.ZERO) <= 0) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"A quantidade deve ser maior que zero.");
            this.tfQuantidade.selectAll();
            this.tfQuantidade.requestFocus();
            return;
        }
        SatCFeItem item = new SatCFeItem();
        item.setCfop(this.produtoSelecionado.getCfop());
        item.setCodigo(this.produtoSelecionado.getCodigo());
        item.setCofins(this.produtoSelecionado.getCofins().getCodigo());
        item.setCson(this.produtoSelecionado.getIcmsSN().getCodigo());
        item.setDesconto(BigDecimal.ZERO);
        item.setDescricao(this.produtoSelecionado.getNome());
        item.setEan13(null);
        item.setNcm(this.produtoSelecionado.getNcm());
        item.setNumeroItem(String.valueOf(this.satCFeItems.size() + 1));
        item.setOrigem(this.produtoSelecionado.getOrigem().getCodigo());
        item.setPis(this.produtoSelecionado.getPis().getCodigo());
        item.setProduto(this.produtoSelecionado);
        item.setQuantidade(quantidade);
        item.setUnidade(this.produtoSelecionado.getUnidade().getSigla());
        item.setValorUnitario(MaximaNumber.moneyToBigDecimal((String)this.tfValorUnitario.getText()));
        item.setValorProdutos(item.getValorUnitario().multiply(item.getQuantidade()).setScale(2, RoundingMode.HALF_EVEN));
        item.setValorTotalItem(item.getValorProdutos());
        this.satCFeItems.add(item);
        this.inicializaItem();
    }

    private void finalizaCupomFiscal() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/fiscal/CupomSatFechamentoForm.fxml", "Cupom Fiscal SAT - Fechamento");
            CupomSatFechamentoFormController controller = (CupomSatFechamentoFormController)stage.getUserData();
            controller.inicializa(this.controleSAT, this.conf, this.satCFeItems);
            stage.showAndWait();
            this.inicializaCupom();
        }
        catch (IOException ex) {
            Logger.getLogger(CupomFiscalFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um erro ao abrir janela para inserir CPF ou CNPJ.");
        }
    }

    private void carregaIcones() {
        this.btnLancarProduto.setGraphic((Node)new MaximaIcone().getIconeNovo());
        this.btnFinalizarComanda.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void registaAcoes() {
        this.btnImprimeUltimoCupom.setOnAction(evt -> this.imprimeUltimoCupomSAT());
        this.btnVerificaSat.setOnAction(evt -> this.verificaStatusSat());
        this.btnFinalizarComanda.setOnAction(event -> this.finalizaCupomFiscal());
        this.btnLancarProduto.setOnAction(event -> this.addItem());
        this.tfProdutoCodigo.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.selecionaProduto();
            }
        });
        this.tfQuantidade.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER && !this.tfQuantidade.getText().trim().isEmpty()) {
                this.tfValorUnitario.requestFocus();
                this.tfValorUnitario.selectAll();
            }
        });
        this.tfValorUnitario.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER && !this.tfValorUnitario.getText().trim().isEmpty()) {
                this.addItem();
            }
        });
    }

    private void fechaForm() {
        Stage stage = (Stage)this.btnFinalizarComanda.getScene().getWindow();
        stage.close();
    }

    private void loadTabela() {
        ObservableList satcfeItemList = FXCollections.observableArrayList();
        satcfeItemList.clear();
        if (this.satCFeItems != null) {
            satcfeItemList.addAll((Collection)this.satCFeItems);
        }
        BigDecimal total = BigDecimal.ZERO;
        for (SatCFeItem i : this.satCFeItems) {
            total = total.add(i.getValorTotalItem());
        }
        this.lbTotal.setText(MaximaNumber.bigDecimalToString((BigDecimal)total, (int)2));
        this.tabela.setItems(satcfeItemList);
    }

    private void setColumnProperties() {
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("codigo"));
        this.colNome.setCellValueFactory((Callback)new PropertyValueFactory("descricao"));
        this.colQuantidade.setCellValueFactory((Callback)new PropertyValueFactory("quantidade"));
        this.colPrecoUnitario.setCellValueFactory((Callback)new PropertyValueFactory("valorUnitario"));
        this.colPrecoTotal.setCellValueFactory((Callback)new PropertyValueFactory("valorTotalItem"));
    }

    private void imprimeUltimoCupomSAT() {
        SatCFe cupom = this.satCFeService.getUltimo();
        if (cupom == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum cupom fiscal entrado.");
            return;
        }
        try {
            SatImpressaoController.imprimeCupom((byte[])cupom.getXml().getArquivo(), (Configuracao)this.conf, (SatCFe)cupom);
        }
        catch (Exception ex) {
            Logger.getLogger(CupomFiscalFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Falha ao imprimir cupom fiscal.\n" + ex.getMessage()));
        }
    }

    private void verificaStatusSat() {
        boolean falha = false;
        if (this.controleSAT == null) {
            falha = true;
        } else {
            boolean bl = falha = !new SATController(this.controleSAT, this.conf).consultaSat();
        }
        if (falha) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Falha na comunica\u00e7\u00e3o com o equipamento SAT.");
        } else {
            MaximaAlert.informe((StageManager)this.stageManager, (String)"SAT em opera\u00e7\u00e3o.");
        }
    }
}

