/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.sat.controller;

import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.sat.core.ControleArquivos;
import br.com.maximasolutions.sat.core.ControleDados;
import br.com.maximasolutions.sat.modelo.SatCFe;
import br.com.maximasolutions.sat.util.SatUtils;
import br.com.maximasolutions.utils.MaximaUtils;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.awt.HeadlessException;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SatCancelaController {
    public static byte[] tratarResultado(String retorno) throws MaximaException {
        try {
            String mensagemSefaz = "";
            byte[] c = null;
            System.out.println("== RET: " + retorno);
            if (retorno.contains("|")) {
                String[] retArray = ControleDados.quebrarString((String)retorno, (String)"|");
                if (retArray[1] != null && retArray[1].equals("07099")) {
                    throw new MaximaException(retArray[2]);
                }
                mensagemSefaz = retArray[5];
                retorno = retArray[3];
                if (retArray.length > 8) {
                    c = ("<?xml version=\"1.0\" encoding=\"utf-8\"?>" + new String(Base64.decode(retArray[6]))).getBytes("utf-8");
                    ControleArquivos.escreverBytesArquivo((String)("C:/Maxima/cancelado-" + retArray[8].replace("CFe", "") + ".xml"), (byte[])c);
                }
                throw new MaximaException(retorno);
            }
            if (retorno.length() > 0) {
                throw new MaximaException(retorno);
            }
            if (mensagemSefaz.length() > 0) {
                SatUtils.salvarAviso((String)mensagemSefaz);
                throw new MaximaException(mensagemSefaz);
            }
            return c;
        }
        catch (HeadlessException | UnsupportedEncodingException e) {
            Logger.getLogger(SatCancelaController.class.getSimpleName()).log(Level.SEVERE, null, e);
            throw new MaximaException(retorno);
        }
    }

    public static String getXmlCancelamento(SatCFe cupom) {
        String xml = "<CFeCanc>";
        xml = xml + "<infCFe chCanc=\"CFe" + cupom.getChaveAcesso() + "\">";
        xml = xml + "<ide>";
        xml = xml + "<CNPJ>" + MaximaUtils.removeCaracteres((String)cupom.getCnpjSoftwareHouse()) + "</CNPJ>";
        xml = xml + "<signAC>" + cupom.getChaveAssinada().trim() + "</signAC>";
        xml = xml + "<numeroCaixa>" + cupom.getNumeroCaixa() + "</numeroCaixa>";
        xml = xml + "</ide>";
        xml = xml + "<emit/>";
        xml = xml + "<dest/>";
        xml = xml + "<total/>";
        xml = xml + "<infAdic/>";
        xml = xml + "</infCFe>";
        xml = xml + "</CFeCanc>";
        return xml;
    }
}

