/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.sat.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.modelo.VendaProdutoFaturamento;
import br.com.maximasolutions.estoque.modelo.VendaProdutoItem;
import br.com.maximasolutions.financeiro.modelo.FormaPagamento;
import br.com.maximasolutions.fiscal.controller.NcmFuncoesController;
import br.com.maximasolutions.fiscal.modelo.Ncm;
import br.com.maximasolutions.fiscal.service.NcmService;
import br.com.maximasolutions.sat.core.ControleArquivos;
import br.com.maximasolutions.sat.core.ControleDados;
import br.com.maximasolutions.sat.modelo.SatCFe;
import br.com.maximasolutions.sat.modelo.SatCFeItem;
import br.com.maximasolutions.sat.modelo.SatCFePagamento;
import br.com.maximasolutions.sat.util.SatUtils;
import br.com.maximasolutions.sat.xml.modelo.CFe;
import br.com.maximasolutions.sat.xml.modelo.DetalhamentoProdutosCFe;
import br.com.maximasolutions.sat.xml.modelo.InformacoesCOFINS;
import br.com.maximasolutions.sat.xml.modelo.InformacoesICMS;
import br.com.maximasolutions.sat.xml.modelo.InformacoesPIS;
import br.com.maximasolutions.sat.xml.modelo.MP;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaSituacaoOperacionalSimplesNacional;
import com.fincatto.documentofiscal.nfe400.classes.NFRegimeTributario;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class SatEnviaController {
    private static final String VERSAO_007 = "0.08";

    public static SatCFe getDadosCupom(String pathCupom) throws MaximaValidacaoException {
        try {
            SatCFe cupomCFe = new SatCFe();
            String cupom = ControleArquivos.lerBytesArquivo((String)pathCupom);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            String xml = cupom;
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
            Document doc = db.parse(is);
            NodeList raizes = doc.getChildNodes();
            Node raiz = raizes.item(0);
            CFe xmlCFe = new CFe(raiz);
            cupomCFe.setDataEmissao(SatUtils.dateStringToLocalDate((String)xmlCFe.getInfCFe().getIde().getdEmi()));
            cupomCFe.setChaveAssinada(xmlCFe.getInfCFe().getIde().getSignAC());
            cupomCFe.setCnpjSoftwareHouse(xmlCFe.getInfCFe().getIde().getCNPJ());
            cupomCFe.setCnpjEmitente(xmlCFe.getInfCFe().getEmit().getCNPJ());
            cupomCFe.setHoraEmissao(xmlCFe.getInfCFe().getIde().gethEmi());
            cupomCFe.setIeEmitente(xmlCFe.getInfCFe().getEmit().getIE());
            cupomCFe.setNumeroCaixa(xmlCFe.getInfCFe().getIde().getNumeroCaixa());
            cupomCFe.setChaveAcesso(xmlCFe.getInfCFe().getId().replace("CFe", ""));
            cupomCFe.setValorProdutos(new BigDecimal(xmlCFe.getInfCFe().getTotal().getICMSTot().getValorProdutos()));
            cupomCFe.setTotal(new BigDecimal(xmlCFe.getInfCFe().getTotal().getValorCupom()));
            cupomCFe.setNumeroCupom(xmlCFe.getInfCFe().getIde().getnCFe().trim());
            cupomCFe.setNomeConsumidor(xmlCFe.getInfCFe().getDest().getxNome());
            if (xmlCFe.getInfCFe().getDest().getCNPJ() != null) {
                cupomCFe.setCpfCnpjDest(xmlCFe.getInfCFe().getDest().getCNPJ());
            }
            if (xmlCFe.getInfCFe().getDest().getCPF() != null) {
                cupomCFe.setCpfCnpjDest(xmlCFe.getInfCFe().getDest().getCPF());
            }
            return cupomCFe;
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            Logger.getLogger(SatEnviaController.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaValidacaoException("Ocorreu um erro ao recuperar dados do cupom.\n" + ex.getCause());
        }
    }

    public static List<SatCFeItem> getItensCupom(String pathCupom) throws MaximaValidacaoException {
        try {
            String cupom = ControleArquivos.lerBytesArquivo((String)pathCupom);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            String xml = cupom;
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
            Document doc = db.parse(is);
            NodeList raizes = doc.getChildNodes();
            Node raiz = raizes.item(0);
            CFe xmlCFe = new CFe(raiz);
            ArrayList<SatCFeItem> listRetorno = new ArrayList<SatCFeItem>();
            for (DetalhamentoProdutosCFe i : xmlCFe.getInfCFe().getDet()) {
                SatCFeItem item = new SatCFeItem();
                item.setCfop(i.getProd().getCFOP());
                item.setCodigo(i.getProd().getcProd());
                item.setDescricao(i.getProd().getxProd());
                item.setEan13("");
                item.setNcm(i.getProd().getNCM());
                item.setNumeroItem(i.getNItem());
                item.setQuantidade(new BigDecimal(i.getProd().getqCom()));
                item.setUnidade(i.getProd().getuCom());
                if (i.getProd().getvDesc() != null) {
                    item.setDesconto(new BigDecimal(i.getProd().getvDesc()));
                } else {
                    item.setDesconto(BigDecimal.ZERO);
                }
                item.setValorUnitario(new BigDecimal(i.getProd().getvUnCom()));
                item.setValorProdutos(new BigDecimal(i.getProd().getvProd()));
                item.setValorTotalItem(new BigDecimal(i.getProd().getvItem()));
                item.setPis(SatEnviaController.getPis((InformacoesPIS)i.getImposto().getPIS()));
                item.setCofins(SatEnviaController.getCofins((InformacoesCOFINS)i.getImposto().getCOFINS()));
                item.setOrigem(SatEnviaController.getOrigem((InformacoesICMS)i.getImposto().getICMS()));
                item.setCson(SatEnviaController.getCsosn((InformacoesICMS)i.getImposto().getICMS()));
                listRetorno.add(item);
            }
            return listRetorno;
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            Logger.getLogger(SatEnviaController.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaValidacaoException("Ocorreu um erro ao recuperar dados do cupom.\n");
        }
    }

    public static List<SatCFePagamento> getParcelasCupom(String pathCupom) throws MaximaValidacaoException {
        try {
            String cupom = ControleArquivos.lerBytesArquivo((String)pathCupom);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            String xml = cupom;
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
            Document doc = db.parse(is);
            NodeList raizes = doc.getChildNodes();
            Node raiz = raizes.item(0);
            CFe cfe = new CFe(raiz);
            ArrayList<SatCFePagamento> listRetorno = new ArrayList<SatCFePagamento>();
            for (MP i : cfe.getInfCFe().getPgto().getMp()) {
                SatCFePagamento parc = new SatCFePagamento();
                parc.setValor(new BigDecimal(i.getvMP()));
                parc.setFormaPagamento(FormaPagamento.valueOfCodigoSat((String)i.getcMP()));
                listRetorno.add(parc);
            }
            return listRetorno;
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            Logger.getLogger(SatEnviaController.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaValidacaoException("Ocorreu um erro ao recuperar dados do cupom.\n");
        }
    }

    public static byte[] tratarResultadoVenda(String resultado, Configuracao conf) throws Exception {
        byte[] cupomByte;
        block14: {
            cupomByte = null;
            String pathCupom = conf.getCaminhoSAT();
            if (pathCupom == null || pathCupom.isEmpty()) {
                pathCupom = "C:/Maxima/CupomSAT/";
            }
            System.out.println("== RESULTADO: " + resultado);
            try {
                String[] retornoArray = null;
                if (!resultado.contains("|")) {
                    if (resultado.length() > 0) {
                        throw new Exception(resultado);
                    }
                    throw new Exception("Falha na comunica\u00e7\u00e3o com o equipamento SAT.\n Verifique a comunica\u00e7\u00e3o do equipamento com o computador.");
                }
                retornoArray = ControleDados.quebrarString((String)resultado, (String)"|");
                if (retornoArray != null) {
                    String qrCode;
                    if (retornoArray.length >= 9) {
                        ControleArquivos.escreverBytesArquivo((String)(pathCupom + "infCanc.txt"), (byte[])retornoArray[8].getBytes());
                    }
                    if (retornoArray[1].equals("06000")) {
                        if (retornoArray.length > 6) {
                            String textoCupom = new String(Base64.decode(retornoArray[6]));
                            cupomByte = textoCupom.contains("<?xml version=") ? new String(Base64.decode(retornoArray[6])).getBytes("utf-8") : ("<?xml version=\"1.0\" encoding=\"utf-8\"?>" + textoCupom).getBytes("utf-8");
                            ControleArquivos.escreverBytesArquivo((String)"C:/Maxima/ultimoCupom.xml", (byte[])cupomByte);
                            String nome = retornoArray[7] + "-" + retornoArray[8] + ".xml";
                            File pathCupomBck = new File(pathCupom + new SimpleDateFormat("yyyy-MM").format(new Date()) + "/");
                            if (!pathCupomBck.exists()) {
                                pathCupomBck.mkdir();
                            }
                            ControleArquivos.escreverBytesArquivo((String)(pathCupom + new SimpleDateFormat("yyyy-MM").format(new Date()) + "/" + nome), (byte[])cupomByte);
                            if (retornoArray.length > 8) {
                                ControleArquivos.escreverBytesArquivo((String)(pathCupom + "C:/Maxima/" + retornoArray[8].replace("CFe", "") + ".xml"), (byte[])cupomByte);
                            }
                        }
                        qrCode = null;
                        if (retornoArray.length >= 11) {
                            qrCode = retornoArray[11];
                        }
                    } else {
                        System.out.println("******** ===== " + retornoArray[1]);
                        System.out.println("******** ===== " + retornoArray[2]);
                        System.out.println("******** ===== " + retornoArray[3]);
                        throw new Exception(retornoArray[3]);
                    }
                    System.out.println("QRCODE SAT:\n" + qrCode);
                    if (retornoArray[5].length() > 0) {
                        throw new Exception("ATEN\u00c7\u00c3O!\nVoc\u00ea recebeu a seguinte mensagem da SEFAZ:\n" + retornoArray[5]);
                    }
                    break block14;
                }
                throw new MaximaValidacaoException("Error: " + resultado);
            }
            catch (Exception e) {
                Logger.getLogger(SatEnviaController.class.getSimpleName()).log(Level.SEVERE, null, e);
                throw new Exception("Ocorreu um erro ao emitir cupom fiscal.\n" + e.getMessage());
            }
        }
        return cupomByte;
    }

    public static String adicionaTracoQuandoVazio(String texto) {
        if (texto == null || texto.isEmpty()) {
            return "-";
        }
        return texto;
    }

    public static String convertVendaProdutoToXmlCupom(NcmService ncmService, VendaProduto vendaProduto, List<VendaProdutoItem> itens, List<VendaProdutoFaturamento> parcelas, Configuracao conf, String numeroCaixa, String cpfCnpj, String nomeConsumidor) throws MaximaValidacaoException {
        String ambiente = MaximaConfig.getInstance().getProperty("nfambiente", "producao");
        System.out.println("*********** AMB: " + ambiente);
        String xml = "<CFe><infCFe versaoDadosEnt=\"0.08\"><ide>";
        if (ambiente != null && ambiente.equalsIgnoreCase("producao")) {
            xml = xml + "<CNPJ>" + MaximaUtils.removeCaracteres((String)conf.getSatCnpjSoftwareHouse()) + "</CNPJ>";
            xml = xml + "<signAC>" + conf.getSatChaveAssinada().trim() + "</signAC>";
        } else {
            xml = xml + "<CNPJ>09439300000146</CNPJ>";
            xml = xml + "<signAC>OTYOvYpnusfySWptNLLrN58m2RK5BLkr9UvSCG5P86b/mMCWqt5N3Zs1EAO8yUk1bSOYjxaTVvQLetQ4ia5tYvVhl+Morw19LevbGz5c3xgyQvQAMYoEeqab2sfiF1AkQd6fxOaXONHb6TCSB3qToH9gg4T7qzS/xA9XbZnYYPshW+NpLYMUGzrOHihED/yr6VYxbjdhSyHxjAqWVZU+/OikNZFRQomRj7lpi5juzDCRUTi/hZZTyfChYxfOk36Od8Lh07iLFBTIx0fEaX7EOdixdNX2qBJmb8exZIxIaz4rxYy8Ia1TwNl8fduCoTwTc3K1Zi43nxLk7dSBfzLLKg==</signAC>";
        }
        xml = xml + "<numeroCaixa>" + MaximaUtils.completaZeroEsquerda((String)numeroCaixa, (Integer)3) + "</numeroCaixa></ide>";
        if (ambiente != null && ambiente.equalsIgnoreCase("producao")) {
            xml = xml + "<emit><CNPJ>" + MaximaUtils.removeCaracteres((String)conf.getEmpresaNFe().getCpf()) + "</CNPJ>";
            xml = xml + "<IE>" + MaximaUtils.removeCaracteres((String)conf.getEmpresaNFe().getRg()) + "</IE>";
        } else {
            System.out.println("***** HOMOLOGACAO *****");
            xml = xml + "<emit><CNPJ>11111111111111</CNPJ>";
            xml = xml + "<IE>111111111111</IE>";
        }
        xml = xml + "<indRatISSQN>N</indRatISSQN></emit>";
        xml = xml + "<dest>";
        if (cpfCnpj != null && !cpfCnpj.isEmpty()) {
            xml = cpfCnpj.length() == 11 ? xml + "<CPF>" + cpfCnpj + "</CPF>" : xml + "<CNPJ>" + cpfCnpj + "</CNPJ>";
        }
        if (nomeConsumidor != null && !nomeConsumidor.isEmpty()) {
            xml = xml + "<xNome>" + nomeConsumidor + "</xNome>";
        }
        xml = xml + "</dest>";
        if (vendaProduto.getCliente().getEndereco() != null && !vendaProduto.getCliente().getEndereco().isEmpty()) {
            xml = xml + "<entrega>";
            xml = xml + "<xLgr>" + SatEnviaController.adicionaTracoQuandoVazio((String)vendaProduto.getCliente().getEndereco().trim().toUpperCase()) + "</xLgr>";
            xml = xml + "<nro>" + SatEnviaController.adicionaTracoQuandoVazio((String)vendaProduto.getCliente().getNumero().trim().toUpperCase()) + "</nro>";
            xml = xml + "<xCpl>" + SatEnviaController.adicionaTracoQuandoVazio((String)vendaProduto.getCliente().getComplemento().trim().toUpperCase()) + "</xCpl>";
            xml = xml + "<xBairro>" + SatEnviaController.adicionaTracoQuandoVazio((String)vendaProduto.getCliente().getBairro().trim().toUpperCase()) + "</xBairro>";
            xml = xml + "<xMun>" + SatEnviaController.adicionaTracoQuandoVazio((String)vendaProduto.getCliente().getMunicipio().getNome().toUpperCase()) + "</xMun>";
            xml = xml + "<UF>" + SatEnviaController.adicionaTracoQuandoVazio((String)vendaProduto.getCliente().getMunicipio().getEstado().getSigla().trim().toUpperCase()) + "</UF>";
            xml = xml + "</entrega>";
        }
        int numItem = 1;
        String erroProdutoFiscal = "";
        NcmFuncoesController ncmFuncoesController = new NcmFuncoesController(ncmService);
        BigDecimal totalImpostoFederal = BigDecimal.ZERO;
        BigDecimal totalImpostoEstadual = BigDecimal.ZERO;
        for (VendaProdutoItem vendaProdutoItem : itens) {
            if (!vendaProdutoItem.getProduto().validaFiscal().booleanValue()) {
                erroProdutoFiscal = erroProdutoFiscal + "Produto com dados incompletos: " + vendaProdutoItem.getProduto().getNome().toUpperCase() + "\n";
                continue;
            }
            xml = xml + "<det nItem=\"" + numItem + "\"><prod><cProd>" + vendaProdutoItem.getProduto().getCodigo().trim() + "</cProd>";
            BigDecimal totalImpostoItem = BigDecimal.ZERO;
            try {
                System.out.println("***** NCM: " + vendaProdutoItem.getProduto().getNcm());
                Ncm ncm = ncmFuncoesController.load(vendaProdutoItem.getProduto().getNcm());
                totalImpostoItem = totalImpostoItem.add(vendaProdutoItem.getPrecoTotal().multiply(ncm.getAliqNac()).divide(new BigDecimal("100"), 2, RoundingMode.HALF_EVEN));
                totalImpostoItem = totalImpostoItem.add(vendaProdutoItem.getPrecoTotal().multiply(ncm.getAliqEstadual()).divide(new BigDecimal("100"), 2, RoundingMode.HALF_EVEN));
                totalImpostoFederal = totalImpostoFederal.add(vendaProdutoItem.getPrecoTotal().multiply(ncm.getAliqNac()).divide(new BigDecimal("100"), 2, RoundingMode.HALF_EVEN));
                totalImpostoEstadual = totalImpostoEstadual.add(vendaProdutoItem.getPrecoTotal().multiply(ncm.getAliqEstadual()).divide(new BigDecimal("100"), 2, RoundingMode.HALF_EVEN));
            }
            catch (Exception ex) {
                Logger.getLogger(SatEnviaController.class.getName()).log(Level.SEVERE, null, ex);
                throw new MaximaValidacaoException("Erro ao calcular imposto sobre o produto [ " + MaximaUtils.limitaTexto((String)vendaProdutoItem.getDescricao(), (int)50) + " ].\nNCM n\u00e3o encontrado na tabela do IBPT.");
            }
            SatCFeItem item = new SatCFeItem();
            item.setProduto(vendaProdutoItem.getProduto());
            item.setValorTotalItem(vendaProdutoItem.getPrecoTotal());
            xml = xml + "<xProd>" + MaximaUtils.removeAcentos((String)vendaProdutoItem.getDescricao().trim()) + "</xProd><NCM>" + vendaProdutoItem.getProduto().getNcm().trim() + "</NCM><CFOP>" + vendaProdutoItem.getProduto().getCfop().trim() + "</CFOP><uCom>" + vendaProdutoItem.getUnidade().trim() + "</uCom><qCom>" + vendaProdutoItem.getQuantidade().setScale(4, RoundingMode.HALF_EVEN).toString() + "</qCom><vUnCom>" + vendaProdutoItem.getPrecoUnitario().setScale(2, RoundingMode.HALF_EVEN).toString() + "</vUnCom><indRegra>A</indRegra></prod><imposto><vItem12741>" + totalImpostoItem + "</vItem12741>" + SatEnviaController.getIcms((Configuracao)conf, (SatCFeItem)item) + SatEnviaController.setPis((Configuracao)conf, (SatCFeItem)item) + SatEnviaController.setCofins((Configuracao)conf, (SatCFeItem)item) + "</imposto></det>";
            ++numItem;
        }
        xml = xml + "<total>";
        if (vendaProduto.getDesconto() != null && vendaProduto.getDesconto().compareTo(BigDecimal.ZERO) > 0) {
            xml = xml + "<DescAcrEntr><vDescSubtot>" + vendaProduto.getDesconto().setScale(2, RoundingMode.HALF_EVEN).toString() + "</vDescSubtot></DescAcrEntr>";
        }
        xml = xml + "</total><pgto>";
        boolean somouTroco = false;
        for (VendaProdutoFaturamento parcela : parcelas) {
            xml = xml + "<MP><cMP>" + parcela.getCondicaoRecebimento().getFormaPagamento().getCodigoSat() + "</cMP><vMP>" + parcela.getValorTotal().setScale(2, RoundingMode.HALF_EVEN).toString() + "</vMP></MP>";
        }
        xml = xml + "</pgto>";
        BigDecimal bigDecimal = totalImpostoFederal.add(totalImpostoEstadual);
        xml = xml + "<infAdic><infCpl>Trib. Aprox R$ " + MaximaNumber.formataNumero((BigDecimal)totalImpostoFederal) + " FED. R$ " + MaximaNumber.formataNumero((BigDecimal)totalImpostoEstadual) + " EST. R$ 0,00 MUN.";
        xml = xml + "\nTotal aproximado de tributos R$ " + bigDecimal + "\nFONTE IBPT (conforme Lei Fed. 12.741/2012)</infCpl></infAdic>";
        xml = xml + "</infCFe></CFe>";
        if (!erroProdutoFiscal.isEmpty()) {
            throw new MaximaValidacaoException("Arquivo cupom n\u00e3o pode ser emitido. Erro no cadastro dos seguintes produtos:\n" + erroProdutoFiscal);
        }
        return xml;
    }

    public static String convertCupomAvulsoToXmlCupom(NcmService ncmService, SatCFe cupom, List<SatCFeItem> itens, List<SatCFePagamento> parcelas, Configuracao conf, String numeroCaixa, String cpfCnpj, String nomeConsumidor) throws MaximaValidacaoException {
        String ambiente = MaximaConfig.getInstance().getProperty("nfambiente", "producao");
        System.out.println("*********** AMB: " + ambiente);
        String xml = "<CFe><infCFe versaoDadosEnt=\"0.08\"><ide>";
        if (ambiente != null && ambiente.equalsIgnoreCase("producao")) {
            xml = xml + "<CNPJ>" + MaximaUtils.removeCaracteres((String)conf.getSatCnpjSoftwareHouse()) + "</CNPJ>";
            xml = xml + "<signAC>" + conf.getSatChaveAssinada().trim() + "</signAC>";
        } else {
            xml = xml + "<CNPJ>11111111111111</CNPJ>";
            xml = xml + "<signAC>WJkVffaDj1p2d0r7EV01NHEyZbs01BcAvn9y9eRX7QrRFCcyV2CTyixI1m2E1kQti/YOuG3+ByUdX0Gn/qYTp+ZivbvVVJdEO1wQH9J8pYSSF8XQ3O5Goe2I2mmi/PZiLANMyLpUvnv7z5RFFga9qKe5q+QaRjhAW32A61ORuleF0amXuCfuiQzSRjbejwcLrqVVkbrATSp+opY7aWzBgaH9GqR3VYEnXMv1UsE8JwqPZelW8r/vWAqayOz/cSlJZ7KhnqNPRIj50vgmlJ118Pcu80RanGoo9E6yOzi4IObaeMLd6ZRewV/HXESQdGvFUWSaCvRjHNFg6ITEorYwKQ==</signAC>";
        }
        xml = xml + "<numeroCaixa>" + MaximaUtils.completaZeroEsquerda((String)numeroCaixa, (Integer)3) + "</numeroCaixa></ide>";
        if (ambiente != null && ambiente.equalsIgnoreCase("producao")) {
            xml = xml + "<emit><CNPJ>" + MaximaUtils.removeCaracteres((String)conf.getEmpresaNFe().getCpf()) + "</CNPJ>";
            xml = xml + "<IE>" + MaximaUtils.removeCaracteres((String)conf.getEmpresaNFe().getRg()) + "</IE>";
        } else {
            System.out.println("***** HOMOLOGACAO *****");
            xml = xml + "<emit><CNPJ>11111111111111</CNPJ>";
            xml = xml + "<IE>111111111111</IE>";
        }
        xml = xml + "<indRatISSQN>N</indRatISSQN></emit>";
        xml = xml + "<dest>";
        if (cpfCnpj != null && !cpfCnpj.isEmpty()) {
            xml = cpfCnpj.length() == 11 ? xml + "<CPF>" + cpfCnpj + "</CPF>" : xml + "<CNPJ>" + cpfCnpj + "</CNPJ>";
            if (nomeConsumidor != null && !nomeConsumidor.isEmpty()) {
                xml = xml + "<xNome>" + nomeConsumidor + "</xNome>";
            }
        }
        xml = xml + "</dest>";
        int numItem = 1;
        BigDecimal totalImpostoCupom = BigDecimal.ZERO;
        NcmFuncoesController ncmFuncoesController = new NcmFuncoesController(ncmService);
        for (SatCFeItem i : itens) {
            xml = xml + "<det nItem=\"" + numItem + "\"><prod><cProd>" + i.getProduto().getCodigo().trim() + "</cProd>";
            if (i.getProduto().getCodigo() != null && i.getProduto().getCodigo().length() == 13) {
                xml = xml + "<cEAN>" + i.getProduto().getCodigo() + "</cEAN>";
            }
            BigDecimal totalImpostoItem = BigDecimal.ZERO;
            try {
                Ncm ncm = ncmFuncoesController.load(i.getProduto().getNcm());
                totalImpostoItem = totalImpostoItem.add(i.getValorTotalItem().multiply(ncm.getAliqNac()).divide(new BigDecimal("100"), 2, RoundingMode.HALF_EVEN));
                totalImpostoItem = totalImpostoItem.add(i.getValorTotalItem().multiply(ncm.getAliqEstadual()).divide(new BigDecimal("100"), 2, RoundingMode.HALF_EVEN));
            }
            catch (Exception ex) {
                Logger.getLogger(SatEnviaController.class.getName()).log(Level.SEVERE, null, ex);
                throw new MaximaValidacaoException("Erro ao calcular imposto sobre o produto [ " + MaximaUtils.limitaTexto((String)i.getDescricao(), (int)50) + " ].\nNCM n\u00e3o encontrado na tabela do IBPT.");
            }
            totalImpostoCupom = totalImpostoCupom.add(totalImpostoItem);
            xml = xml + "<xProd>" + MaximaUtils.removeAcentos((String)i.getDescricao().trim()) + "</xProd><NCM>" + i.getProduto().getNcm().trim() + "</NCM><CFOP>" + i.getProduto().getCfop().trim() + "</CFOP><uCom>" + i.getUnidade().trim() + "</uCom><qCom>" + i.getQuantidade().setScale(4, RoundingMode.HALF_EVEN).toString() + "</qCom><vUnCom>" + i.getValorUnitario().setScale(2, RoundingMode.HALF_EVEN).toString() + "</vUnCom><indRegra>A</indRegra></prod><imposto><vItem12741>" + totalImpostoItem + "</vItem12741>" + SatEnviaController.getIcms((Configuracao)conf, (SatCFeItem)i) + SatEnviaController.setPis((Configuracao)conf, (SatCFeItem)i) + SatEnviaController.setCofins((Configuracao)conf, (SatCFeItem)i) + "</imposto></det>";
            ++numItem;
        }
        xml = xml + "<total></total><pgto>";
        for (SatCFePagamento parcela : parcelas) {
            xml = xml + "<MP><cMP>" + parcela.getFormaPagamento().getCodigoSat() + "</cMP><vMP>" + parcela.getValor().setScale(2, RoundingMode.HALF_EVEN).toString() + "</vMP></MP>";
        }
        xml = xml + "</pgto>";
        xml = xml + "<infAdic><infCpl>Total aproximado de tributos R$ " + totalImpostoCupom + " - FONTE IBPT</infCpl></infAdic>";
        xml = xml + "</infCFe></CFe>";
        System.out.println("XML CUPOM SAT: " + xml);
        return xml;
    }

    public static String getIcms(Configuracao conf, SatCFeItem item) {
        if (conf.getEmpresaNFe().getRegime().equals((Object)NFRegimeTributario.SIMPLES_NACIONAL) || conf.getEmpresaNFe().getRegime().equals((Object)NFRegimeTributario.MEI)) {
            if (item.getProduto().getIcmsSN().equals((Object)NFNotaSituacaoOperacionalSimplesNacional.ICMS_COBRADO_ANTERIORMENTE_POR_SUBSTITUICAO_TRIBUTARIA_SUBSIDIO_OU_POR_ANTECIPACAO)) {
                return "<ICMS><ICMSSN102><Orig>" + item.getProduto().getOrigem().getCodigo() + "</Orig><CSOSN>" + item.getProduto().getIcmsSN().getCodigo() + "</CSOSN></ICMSSN102></ICMS>";
            }
            if (item.getProduto().getIcmsSN().equals((Object)NFNotaSituacaoOperacionalSimplesNacional.NAO_TRIBUTADA) || item.getProduto().getIcmsSN().equals((Object)NFNotaSituacaoOperacionalSimplesNacional.TRIBUTADA_SEM_PERMISSAO_CREDITO)) {
                return "<ICMS><ICMSSN102><Orig>" + item.getProduto().getOrigem().getCodigo() + "</Orig><CSOSN>102</CSOSN></ICMSSN102></ICMS>";
            }
        } else {
            String cst = item.getProduto().getTributacaoICMS().getCodigo();
            if (cst.equals("10")) {
                cst = "60";
            }
            if (cst.equals("00") || cst.equals("20") || cst.equals("90")) {
                return "<ICMS><ICMS00><Orig>" + item.getProduto().getOrigem().getCodigo() + "</Orig><CST>" + item.getProduto().getTributacaoICMS().getCodigo() + "</CST><pICMS>" + item.getProduto().getAliquotaICMS().setScale(2, RoundingMode.HALF_EVEN).toString() + "</pICMS></ICMS00></ICMS>";
            }
            if (cst.equals("40") || cst.equals("41") || cst.equals("50") || cst.equals("60")) {
                return "<ICMS><ICMS40><Orig>" + item.getProduto().getOrigem().getCodigo() + "</Orig><CST>" + item.getProduto().getTributacaoICMS().getCodigo() + "</CST></ICMS40></ICMS>";
            }
        }
        return "";
    }

    public static String setPis(Configuracao conf, SatCFeItem item) {
        if (conf.getEmpresaNFe().getRegime().equals((Object)NFRegimeTributario.SIMPLES_NACIONAL) || conf.getEmpresaNFe().getRegime().equals((Object)NFRegimeTributario.MEI)) {
            String pis = "<PIS><PISSN><CST>49</CST></PISSN></PIS>";
            return pis;
        }
        String codigoPis = item.getProduto().getPis().getCodigo();
        if (codigoPis.equals("01") || codigoPis.equals("02") || codigoPis.equals("05")) {
            return "<PIS><PISAliq><CST>" + codigoPis + "</CST><vBC>" + item.getValorTotalItem().setScale(2, RoundingMode.HALF_EVEN).toString() + "</vBC><pPIS>" + item.getProduto().getAliquotaPis().divide(new BigDecimal(100), RoundingMode.CEILING).setScale(4, RoundingMode.HALF_EVEN).toString() + "</pPIS></PISAliq></PIS>";
        }
        return "<PIS><PISNT><CST>06</CST></PISNT></PIS>";
    }

    public static String setCofins(Configuracao conf, SatCFeItem item) {
        if (conf.getEmpresaNFe().getRegime().equals((Object)NFRegimeTributario.SIMPLES_NACIONAL) || conf.getEmpresaNFe().getRegime().equals((Object)NFRegimeTributario.MEI)) {
            return "<COFINS><COFINSSN><CST>49</CST></COFINSSN></COFINS>";
        }
        String codigoCofins = item.getProduto().getCofins().getCodigo();
        if (codigoCofins.equals("01") || codigoCofins.equals("02") || codigoCofins.equals("05")) {
            return "<COFINS><COFINSAliq><CST>" + codigoCofins + "</CST><vBC>" + item.getValorTotalItem().setScale(2, RoundingMode.HALF_EVEN).toString() + "</vBC><pCOFINS>" + item.getProduto().getAliquotaCofins().divide(new BigDecimal(100), RoundingMode.CEILING).setScale(4, RoundingMode.HALF_EVEN).toString() + "</pCOFINS></COFINSAliq></COFINS>";
        }
        return "<COFINS><COFINSNT><CST>06</CST></COFINSNT></COFINS>";
    }

    public static String getCsosn(InformacoesICMS icms) {
        if (icms.getICMS00() != null) {
            return icms.getICMS00().getCST();
        }
        if (icms.getICMS40() != null) {
            return icms.getICMS40().getCST();
        }
        if (icms.getICMSSN102() != null) {
            return icms.getICMSSN102().getCSOSN();
        }
        if (icms.getICMSSN900() != null) {
            return icms.getICMSSN900().getCSOSN();
        }
        return null;
    }

    public static String getOrigem(InformacoesICMS icms) {
        if (icms.getICMS00() != null) {
            return icms.getICMS00().getOrig();
        }
        if (icms.getICMS40() != null) {
            return icms.getICMS40().getOrig();
        }
        if (icms.getICMSSN102() != null) {
            return icms.getICMSSN102().getOrig();
        }
        if (icms.getICMSSN900() != null) {
            return icms.getICMSSN900().getOrig();
        }
        return null;
    }

    public static String getPis(InformacoesPIS pis) {
        if (pis.getPISSN() != null) {
            return pis.getPISSN().getCST();
        }
        if (pis.getPISNT() != null) {
            return pis.getPISNT().getCST();
        }
        if (pis.getPISOutr() != null) {
            return pis.getPISOutr().getCST();
        }
        return null;
    }

    public static String getCofins(InformacoesCOFINS pis) {
        if (pis.getCOFINSSN() != null) {
            return pis.getCOFINSSN().getCST();
        }
        if (pis.getCOFINSNT() != null) {
            return pis.getCOFINSNT().getCST();
        }
        if (pis.getCOFINSOutr() != null) {
            return pis.getCOFINSOutr().getCST();
        }
        return null;
    }
}

