/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.sat.print;

import br.com.maximasoft.print.form.PrintCupomForm;
import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.core.ESCPrinter;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.financeiro.modelo.FormaPagamento;
import br.com.maximasolutions.sat.modelo.SatCFe;
import br.com.maximasolutions.sat.print.SatImpressaoBematech;
import br.com.maximasolutions.sat.print.SatImpressaoElgin;
import br.com.maximasolutions.sat.print.SatImpressaoEpson;
import br.com.maximasolutions.sat.print.SatImpressaoTanca;
import br.com.maximasolutions.sat.print.SatPrinter;
import br.com.maximasolutions.sat.xml.modelo.CFeImpressao;
import br.com.maximasolutions.sat.xml.modelo.DetalhamentoProdutosCFe;
import br.com.maximasolutions.sat.xml.modelo.MP;
import br.com.maximasolutions.utils.MaximaUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class SatImpressaoController {
    public static boolean imprimeCupom(byte[] xml, Configuracao conf, SatCFe satCFe) throws Exception {
        boolean imprimiu = false;
        String impressoraTipo = conf.getImpressoraModelo().toString();
        if (!MaximaConfig.getImpressoraCupom().isEmpty()) {
            impressoraTipo = MaximaConfig.getImpressoraCupom();
        }
        if (impressoraTipo == null || impressoraTipo.isEmpty() || impressoraTipo.equalsIgnoreCase("a4")) {
            throw new MaximaException("AVISO: Nenhuma impressora configurada para impress\u00e3o do cupom SAT.");
        }
        if (MaximaConfig.getImpressaoSpooler().booleanValue()) {
            SatImpressaoController.imprimeCupomSpooler((Configuracao)conf, (SatCFe)satCFe, (byte[])xml);
            return true;
        }
        if (impressoraTipo.equalsIgnoreCase("bematech")) {
            SatImpressaoBematech.imprimeCupom((byte[])xml, (Configuracao)conf);
            imprimiu = true;
        }
        if (impressoraTipo.equalsIgnoreCase("elgin")) {
            SatImpressaoElgin.imprimeCupom((byte[])xml, (Configuracao)conf);
            imprimiu = true;
        }
        if (impressoraTipo.equalsIgnoreCase("epson")) {
            SatImpressaoEpson.imprimeCupom((byte[])xml, (Configuracao)conf);
            imprimiu = true;
        }
        if (impressoraTipo.equalsIgnoreCase("tanca")) {
            SatImpressaoTanca.imprimeCupom((byte[])xml, (Configuracao)conf);
            imprimiu = true;
        }
        return imprimiu;
    }

    public static void imprimeCupomSpooler(Configuracao conf, SatCFe satCFe, byte[] xml) throws MaximaValidacaoException, MaximaException {
        try {
            CFeImpressao impressao = SatImpressaoController.getCfe((byte[])xml, (Configuracao)conf);
            PrintCupomForm form = new PrintCupomForm();
            form.setImpressora(conf.getImpressoraCaixaSpooler());
            form.setTexto(SatImpressaoController.getText((CFeImpressao)impressao, (Configuracao)conf));
            form.setCodigoBarras(satCFe.getChaveAcesso());
            form.setQrCode(SatImpressaoController.completarQRCode((CFeImpressao)impressao));
            form.setFooter(ESCPrinter.maximaSoft() + ESCPrinter.finaliza());
            new SatPrinter().imprimeCupom(form);
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            Logger.getLogger(SatImpressaoController.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaValidacaoException("Ops, ocorreu um erro ao imprimir cupom fiscal." + ex.getMessage());
        }
    }

    private static CFeImpressao getCfe(byte[] xml, Configuracao conf) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        ByteArrayInputStream is = new ByteArrayInputStream(xml);
        Document doc = db.parse(is);
        NodeList raizes = doc.getChildNodes();
        Node raiz = raizes.item(0);
        return new CFeImpressao(raiz);
    }

    private static String completarQRCode(CFeImpressao cfeImpressao) {
        String chaveConsulta = cfeImpressao.getInfCFe().getId().replace("CFe", "");
        String timestamp = cfeImpressao.getInfCFe().getIde().getdEmi() + cfeImpressao.getInfCFe().getIde().gethEmi();
        String valor = cfeImpressao.getInfCFe().getTotal().getValorCupom();
        String destinatario = cfeImpressao.getInfCFe().getDest().getCPF();
        if (destinatario == null) {
            destinatario = cfeImpressao.getInfCFe().getDest().getCNPJ();
        }
        if (destinatario == null) {
            destinatario = "";
        }
        String assinatura = cfeImpressao.getInfCFe().getIde().getAssinaturaQRCODE();
        System.out.println("ASS.: " + chaveConsulta.length() + "\n" + chaveConsulta);
        return chaveConsulta.replace("CFe", "") + "|" + timestamp + "|" + valor + "|" + destinatario + "|" + assinatura;
    }

    private static String getText(CFeImpressao impressao, Configuracao conf) throws ParserConfigurationException, SAXException, IOException {
        String nomeFantasia = impressao.getInfCFe().getEmit().getxFant();
        String razao = impressao.getInfCFe().getEmit().getxNome();
        String CNPJ = MaximaUtils.formatCNPJ((String)impressao.getInfCFe().getEmit().getCNPJ().trim());
        String IE = MaximaUtils.formatIE((String)impressao.getInfCFe().getEmit().getIE());
        String IM = impressao.getInfCFe().getEmit().getIM();
        String logradouro = impressao.getInfCFe().getEmit().getEnderEmit().getxLgr();
        String nro = impressao.getInfCFe().getEmit().getEnderEmit().getNro();
        String bairro = impressao.getInfCFe().getEmit().getEnderEmit().getxBairro();
        String cpl = impressao.getInfCFe().getEmit().getEnderEmit().getxCpl();
        String mun = impressao.getInfCFe().getEmit().getEnderEmit().getxMun();
        String nCFe = impressao.getInfCFe().getIde().getnCFe();
        String vImposto = impressao.getInfCFe().getTotal().getvCFeLei12741();
        String destinatario = MaximaUtils.formatCPF((String)impressao.getInfCFe().getDest().getCPF());
        if (destinatario == null) {
            destinatario = MaximaUtils.formatCNPJ((String)impressao.getInfCFe().getDest().getCNPJ());
        }
        String nomeConsumidor = null;
        if (impressao.getInfCFe().getDest() != null && impressao.getInfCFe().getDest().getxNome() != null) {
            nomeConsumidor = impressao.getInfCFe().getDest().getxNome();
        }
        String endereco = "";
        if (logradouro != null) {
            endereco = endereco + logradouro;
        }
        if (nro != null) {
            endereco = endereco + " " + nro;
        }
        if (cpl != null) {
            endereco = endereco + " " + cpl;
        }
        if (bairro != null) {
            endereco = endereco + " " + bairro;
        }
        if (mun != null) {
            endereco = endereco + " " + mun;
        }
        String cabecalho = ESCPrinter.iniciaImpressao();
        if (conf.getNomeEmpresa() != null && !conf.getNomeEmpresa().isEmpty()) {
            cabecalho = cabecalho + MaximaUtils.centraliza((String)ESCPrinter.centraliza((String)ESCPrinter.negrita((String)MaximaUtils.removeAcentos((String)conf.getNomeEmpresa().toUpperCase()))), (int)48) + "\n";
        }
        if (conf.getTelefoneEmpresa() != null && !conf.getTelefoneEmpresa().isEmpty()) {
            cabecalho = cabecalho + MaximaUtils.centraliza((String)ESCPrinter.centraliza((String)ESCPrinter.negrita((String)("FONE: " + MaximaUtils.removeAcentos((String)conf.getTelefoneEmpresa().toUpperCase())))), (int)48) + "\n";
        }
        if (nomeFantasia != null) {
            cabecalho = cabecalho + MaximaUtils.centraliza((String)ESCPrinter.centraliza((String)MaximaUtils.removeAcentos((String)nomeFantasia)), (int)48) + "\n";
        }
        if (razao != null) {
            cabecalho = cabecalho + MaximaUtils.centraliza((String)ESCPrinter.centraliza((String)MaximaUtils.removeAcentos((String)razao)), (int)48) + "\n";
        }
        if (endereco.length() > 0) {
            cabecalho = cabecalho + MaximaUtils.centraliza((String)ESCPrinter.centraliza((String)MaximaUtils.removeAcentos((String)endereco)), (int)48) + "\n";
        }
        cabecalho = cabecalho + "\n";
        if (CNPJ != null) {
            cabecalho = cabecalho + MaximaUtils.centraliza((String)(ESCPrinter.centraliza((String)("CNPJ " + CNPJ)) + ESCPrinter.centraliza((String)(" IE " + IE))), (int)48);
        }
        cabecalho = cabecalho + "\n" + MaximaUtils.completaDireita((String)"", (String)"-", (int)48);
        cabecalho = cabecalho + "\n" + MaximaUtils.centraliza((String)ESCPrinter.centraliza((String)ESCPrinter.negrita((String)("Extrato No. " + nCFe))), (int)48);
        cabecalho = cabecalho + "\n" + MaximaUtils.centraliza((String)ESCPrinter.negrita((String)"CUPOM FISCAL ELETRONICO - SAT"), (int)48);
        cabecalho = cabecalho + "\n" + MaximaUtils.completaDireita((String)"", (String)"-", (int)48);
        if (destinatario != null || nomeConsumidor != null) {
            if (destinatario != null) {
                cabecalho = cabecalho + "\n" + ESCPrinter.alinha_esquerda((String)("CPF/CNPJ do Consumidor: " + destinatario));
            }
            if (nomeConsumidor != null) {
                cabecalho = cabecalho + "\n" + ESCPrinter.alinha_esquerda((String)("Nome: " + nomeConsumidor));
            }
            cabecalho = cabecalho + "\n" + MaximaUtils.completaDireita((String)"", (String)"-", (int)48);
        }
        cabecalho = cabecalho + "\n#|COD|DESC|QT|UN|VL UN R$|(VL TR R$)*|VL ITEM R$";
        cabecalho = cabecalho + MaximaUtils.completaDireita((String)"", (String)"-", (int)48) + "\n";
        String corpo = "";
        ArrayList produtos = impressao.getInfCFe().getDet();
        for (int i = 0; i < produtos.size(); ++i) {
            String numero = ((DetalhamentoProdutosCFe)produtos.get(i)).getNItem();
            String codigo = ((DetalhamentoProdutosCFe)produtos.get(i)).getProd().getcProd();
            String descricao = ((DetalhamentoProdutosCFe)produtos.get(i)).getProd().getxProd();
            String qtd = ((DetalhamentoProdutosCFe)produtos.get(i)).getProd().getqCom();
            String un = ((DetalhamentoProdutosCFe)produtos.get(i)).getProd().getuCom();
            String vUn = ((DetalhamentoProdutosCFe)produtos.get(i)).getProd().getvUnCom();
            String valor = ESCPrinter.alinha_direita((String)((DetalhamentoProdutosCFe)produtos.get(i)).getProd().getvItem());
            String imp = ((DetalhamentoProdutosCFe)produtos.get(i)).getImposto().getvItem12741();
            corpo = corpo + ESCPrinter.alinha_esquerda((String)(numero + " " + (String)codigo + " " + descricao + " " + qtd + " " + un + " X " + vUn + "(" + imp + ") ")) + valor + "\n";
        }
        cabecalho = cabecalho + corpo;
        String total = impressao.getInfCFe().getTotal().getValorCupom();
        String troco = impressao.getInfCFe().getPgto().getvTroco();
        corpo = "\n" + ESCPrinter.negrita((String)(MaximaUtils.completaDireita((String)"TOTAL R$", (String)" ", (int)20) + MaximaUtils.completaEsquerda((String)total, (String)" ", (int)28)));
        for (MP pgto : impressao.getInfCFe().getPgto().getMp()) {
            corpo = corpo + "\n" + ESCPrinter.alinha_esquerda((String)(MaximaUtils.completaDireita((String)MaximaUtils.removeAcentos((String)FormaPagamento.valueOfCodigoSat((String)pgto.getcMP()).toString()), (String)" ", (int)20) + MaximaUtils.completaEsquerda((String)pgto.getvMP(), (String)" ", (int)28)));
        }
        corpo = corpo + "\n" + ESCPrinter.alinha_esquerda((String)(MaximaUtils.completaDireita((String)"TROCO R$", (String)" ", (int)20) + MaximaUtils.completaEsquerda((String)troco, (String)" ", (int)28)));
        corpo = corpo + "\n" + MaximaUtils.completaDireita((String)"", (String)"-", (int)48);
        corpo = corpo + "\n" + ESCPrinter.alinha_esquerda((String)"OBSERVACOES DO CONTRIBUINTE");
        if (vImposto != null) {
            corpo = corpo + "\n" + ESCPrinter.alinha_esquerda((String)("Valor aproximado dos tributos R$: " + vImposto));
        }
        corpo = corpo + "\n* Valor aproximado dos tributos do item";
        corpo = corpo + "\n\n" + impressao.getInfCFe().getInfAdic().getInfCpl();
        corpo = corpo + "\n" + MaximaUtils.completaDireita((String)"", (String)"-", (int)48);
        if (impressao.getInfCFe().getEntrega() != null) {
            corpo = corpo + "\n" + ESCPrinter.negrita((String)"DADOS PARA ENTREGA");
            corpo = corpo + "\n" + impressao.getInfCFe().getEntrega().getxLgr() + ", " + impressao.getInfCFe().getEntrega().getNro() + " - " + impressao.getInfCFe().getEntrega().getxCpl() + " - " + impressao.getInfCFe().getEntrega().getxBairro();
            corpo = corpo + "\n" + impressao.getInfCFe().getEntrega().getxMun() + "/" + impressao.getInfCFe().getEntrega().getUF();
            corpo = corpo + "\n" + MaximaUtils.completaDireita((String)"", (String)"-", (int)48);
        }
        String rodape = corpo;
        String data = impressao.getInfCFe().getIde().getdEmi();
        String hora = impressao.getInfCFe().getIde().gethEmi();
        data = data.substring(6, 8) + "/" + data.substring(4, 6) + "/" + data.substring(0, 4);
        hora = hora.substring(0, 2) + ":" + hora.substring(2, 4) + ":" + hora.substring(4);
        rodape = rodape + "\n" + MaximaUtils.centraliza((String)("SAT No. " + impressao.getInfCFe().getIde().getNserieSAT()), (int)48);
        rodape = rodape + "\n" + MaximaUtils.centraliza((String)(data + " - " + hora), (int)48);
        cabecalho = cabecalho + rodape + "\n";
        return cabecalho;
    }
}

