/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.sat.print;

import br.com.maximasoft.print.core.ImpressoraSpooler;
import br.com.maximasoft.print.form.PrintCupomForm;
import br.com.maximasolutions.core.MaximaException;
import com.github.anastaciocintra.escpos.EscPos;
import com.github.anastaciocintra.escpos.EscPosConst;
import com.github.anastaciocintra.escpos.barcode.BarCode;
import com.github.anastaciocintra.escpos.barcode.BarCodeWrapperInterface;
import com.github.anastaciocintra.escpos.barcode.QRCode;
import com.github.anastaciocintra.output.PrinterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.PrintService;

public class SatPrinter {
    public void imprimeCupom(PrintCupomForm form) throws MaximaException {
        PrinterOutputStream printerOutputStream = null;
        PrintService printService = new ImpressoraSpooler().getImpressora(form.getImpressora());
        if (printService == null) {
            throw new MaximaException("Impressora n\u00e3o encontrada!");
        }
        try {
            printerOutputStream = new PrinterOutputStream(printService);
            EscPos escpos = new EscPos((OutputStream)printerOutputStream);
            escpos.writeLF(form.getTexto());
            BarCode barcode = new BarCode();
            barcode.setJustification(EscPosConst.Justification.Center);
            barcode.setBarCodeSize(2, 50);
            escpos.write((BarCodeWrapperInterface)barcode, form.getCodigoBarras().substring(0, 22));
            escpos.write((BarCodeWrapperInterface)barcode, form.getCodigoBarras().substring(22));
            QRCode qRCode = new QRCode();
            qRCode.setJustification(EscPosConst.Justification.Center);
            escpos.write((BarCodeWrapperInterface)qRCode, form.getQrCode());
            escpos.writeLF(form.getFooter());
            escpos.close();
        }
        catch (IOException ex) {
            Logger.getLogger(SatPrinter.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException("Ops, ocorreu um erro ao imprimir. " + ex.getMessage());
        }
        finally {
            try {
                if (printerOutputStream != null) {
                    printerOutputStream.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(SatPrinter.class.getName()).log(Level.SEVERE, null, ex);
                throw new MaximaException("Ops, ocorreu um erro ao imprimir. " + ex.getMessage());
            }
        }
    }
}

