/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.vendasexternas.controller;

import br.com.maximasolutions.componentes.fx.MaximaAutoComplete;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.modelo.Municipio;
import br.com.maximasolutions.geral.service.MunicipioService;
import br.com.maximasolutions.utils.MaximaCnpjCpf;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import br.com.maximasolutions.vendasexternas.modelo.ClienteVendaExterna;
import br.com.maximasolutions.vendasexternas.service.ClienteVendaExternaService;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class ClienteVendaExternaFormController
extends MaximaController
implements Initializable {
    @FXML
    private TextField tfNome;
    @FXML
    private TextField tfFantasia;
    @FXML
    private TextField tfCpfCnpj;
    @FXML
    private TextField tfInscricaoEstadual;
    @FXML
    private TextField tfEndereco;
    @FXML
    private TextField tfEnderecoNumero;
    @FXML
    private TextField tfBairro;
    @FXML
    private TextField tfComplemento;
    @FXML
    private TextField tfCep;
    @FXML
    private TextField tfCidade;
    @FXML
    private TextField tfTelefone;
    @FXML
    private TextField tfEmail;
    @FXML
    private TextField tfLimiteCredito;
    @FXML
    private TextField tfVendedor;
    @FXML
    private ComboBox<Municipio> cbbMunicipio;
    @FXML
    private Button btnSalva;
    @Autowired
    private ClienteVendaExternaService clienteVendaExternaService;
    @Autowired
    private MunicipioService municipioService;
    private ClienteVendaExterna clienteVendaExterna;
    private Cliente cliente;
    private MaximaAutoComplete<Object> maximaAutoComplete;

    public void initialize(URL url, ResourceBundle rb) {
        this.clienteVendaExterna = null;
        this.carregaIcones();
        this.registraAcoes();
        this.carregaCombos();
        this.carregaMascaras();
    }

    private void salva() {
        this.cliente = this.clienteVendaExterna.getCliente();
        if (this.cliente == null) {
            this.cliente = new Cliente();
        }
        this.cliente.setAtivo(Boolean.TRUE);
        this.cliente.setBairro(MaximaUtils.getText((String)this.tfBairro.getText()));
        this.cliente.setCep(MaximaUtils.removeCaracteres((String)this.tfCep.getText()));
        this.cliente.setComplemento(MaximaUtils.getText((String)this.tfComplemento.getText()));
        this.cliente.setCpf(MaximaUtils.removeCaracteres((String)this.tfCpfCnpj.getText()));
        this.cliente.setDataCadastro(LocalDate.now());
        this.cliente.setEmail(MaximaUtils.getText((String)this.tfEmail.getText()));
        this.cliente.setEndereco(MaximaUtils.getText((String)this.tfEndereco.getText()));
        this.cliente.setFantasia(MaximaUtils.getText((String)this.tfFantasia.getText()));
        this.cliente.setLimite(MaximaNumber.moneyToBigDecimal((String)this.tfLimiteCredito.getText()));
        this.cliente.setMunicipio((Municipio)this.cbbMunicipio.getSelectionModel().getSelectedItem());
        this.cliente.setNegativado(Boolean.FALSE);
        this.cliente.setNome(MaximaUtils.getText((String)this.tfNome.getText()));
        this.cliente.setNumero(MaximaUtils.getText((String)this.tfEnderecoNumero.getText()));
        this.cliente.setRg(MaximaUtils.removeCaracteres((String)this.tfInscricaoEstadual.getText()));
        this.cliente.setTelefone(MaximaUtils.removeCaracteres((String)this.tfTelefone.getText()));
        this.cliente.setUltimaAlteracao(LocalDateTime.now());
        if (!this.validaForm()) {
            return;
        }
        try {
            this.clienteVendaExternaService.confirma(this.clienteVendaExterna, this.cliente);
            MaximaAlert.mensagemInformativa((String)"Cliente confirmado com sucesso.");
            Stage stage = (Stage)this.tfNome.getScene().getWindow();
            stage.close();
        }
        catch (MaximaException ex) {
            Logger.getLogger(ClienteVendaExternaFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.alerta((String)("Erro: " + ex.getLocalizedMessage()));
        }
    }

    public void inicializa(ClienteVendaExterna clienteVendaExterna1) {
        this.clienteVendaExterna = clienteVendaExterna1;
        if (this.clienteVendaExterna != null) {
            this.tfNome.setText(this.clienteVendaExterna.getNome());
            this.tfFantasia.setText("");
            this.tfCpfCnpj.setText(this.clienteVendaExterna.getCpfCnpj());
            this.tfInscricaoEstadual.setText(this.clienteVendaExterna.getInscricaoEstadual());
            this.tfEndereco.setText(this.clienteVendaExterna.getEndereco());
            this.tfEnderecoNumero.setText(this.clienteVendaExterna.getNumero());
            this.tfBairro.setText(this.clienteVendaExterna.getBairro());
            this.tfComplemento.setText(this.clienteVendaExterna.getComplemento());
            this.tfCep.setText(this.clienteVendaExterna.getCep());
            this.tfCidade.setText(this.clienteVendaExterna.getCidade());
            this.tfTelefone.setText(this.clienteVendaExterna.getTelefone());
            this.tfEmail.setText(this.clienteVendaExterna.getEmail());
            this.tfNome.selectAll();
            this.tfNome.requestFocus();
        }
    }

    private void carregaCombos() {
        this.cbbMunicipio.setItems(FXCollections.observableArrayList((Collection)this.municipioService.list()));
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.salva());
    }

    private void carregaMascaras() {
        MaximaMask.monetaryField((TextField)this.tfLimiteCredito);
    }

    private boolean validaForm() {
        String msgErro = "";
        if (this.cliente == null) {
            MaximaAlert.alerta((String)"Informe os dados corretos do cliente.");
            return false;
        }
        if (this.cliente.getCpf() != null && !this.cliente.getCpf().isEmpty() && !MaximaCnpjCpf.isValid((String)this.cliente.getCpf())) {
            msgErro = msgErro + "Campo CNPJ/CPF inv\u00e1lido.\n";
        }
        if (this.cliente.getCpf() != null && this.cliente.getCpf().length() == 14 && (this.cliente.getRg() == null || this.cliente.getRg().isEmpty())) {
            msgErro = msgErro + "Campo Inscri\u00e7\u00e3o Estadual \u00e9 obrigat\u00f3rio.\n";
        }
        if (this.cliente.getMunicipio() == null) {
            msgErro = msgErro + "Campo Munic\u00edpio \u00e9 obrigat\u00f3rio.\n";
        }
        if (this.cliente.getTelefone() == null || this.cliente.getTelefone().isEmpty()) {
            msgErro = msgErro + "Campo Telefone \u00e9 obrigat\u00f3rio.\n";
        }
        if (!msgErro.isEmpty()) {
            MaximaAlert.alerta((String)msgErro);
            return false;
        }
        return true;
    }
}

