/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.vendasexternas.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.estoque.dto.CategoriaProdutoDto;
import br.com.maximasolutions.estoque.dto.ProdutoDto;
import br.com.maximasolutions.estoque.dto.UnidadeDto;
import br.com.maximasolutions.estoque.service.CategoriaProdutoService;
import br.com.maximasolutions.estoque.service.ProdutoService;
import br.com.maximasolutions.estoque.service.UnidadeService;
import br.com.maximasolutions.financeiro.dto.CondicaoRecebimentoDto;
import br.com.maximasolutions.financeiro.service.CondicaoRecebimentoService;
import br.com.maximasolutions.geral.dto.ClienteDto;
import br.com.maximasolutions.geral.dto.EstadoDto;
import br.com.maximasolutions.geral.dto.MunicipioDto;
import br.com.maximasolutions.geral.dto.VendedorDto;
import br.com.maximasolutions.geral.service.ClienteService;
import br.com.maximasolutions.geral.service.EstadoService;
import br.com.maximasolutions.geral.service.MunicipioService;
import br.com.maximasolutions.geral.service.VendedorService;
import br.com.maximasolutions.vendasexternas.controller.PedidoVendaExternaController;
import br.com.maximasolutions.vendasexternas.controller.SincronizacaoController;
import br.com.maximasolutions.vendasexternas.dto.VendasExternasSincronizacaoDto;
import br.com.maximasolutions.vendasexternas.dto.VendedorProdutoDto;
import br.com.maximasolutions.vendasexternas.service.PedidoVendaExternaService;
import br.com.maximasolutions.vendasexternas.service.SincronizacaoService;
import br.com.maximasolutions.vendasexternas.service.VendedorProdutoService;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.shape.Circle;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class SincronizacaoController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private PedidoVendaExternaService pedidoVendaExternaService;
    @Autowired
    private SincronizacaoService sincronizacaoService;
    @Autowired
    private EstadoService estadoService;
    @Autowired
    private MunicipioService municipioService;
    @Autowired
    private UnidadeService unidadeService;
    @Autowired
    private CategoriaProdutoService categoriaProdutoService;
    @Autowired
    private VendedorService vendedorService;
    @Autowired
    private ProdutoService produtoService;
    @Autowired
    private CondicaoRecebimentoService condicaoRecebimentoService;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private VendedorProdutoService vendedorProdutoService;
    @FXML
    private TableView<VendasExternasSincronizacaoDto> tabela;
    @FXML
    private TableColumn<VendasExternasSincronizacaoDto, String> colDataHora;
    @FXML
    private TableColumn<VendasExternasSincronizacaoDto, String> colDescricao;
    @FXML
    private Label labelServidorStatus;
    @FXML
    private Circle iconeServidorStatus;
    @FXML
    private Button btnLimpar;
    @FXML
    private Button btnFinalizar;
    private List<VendasExternasSincronizacaoDto> listaTabela;
    private Boolean existeSincronizacao;
    private Boolean servidorOn;

    public void initialize(URL url, ResourceBundle rb) {
        this.setColumnProperties();
        this.carregaIcones();
        this.registraAcoes();
    }

    public void inicializa() {
        this.listaTabela = new ArrayList();
        this.servidorOn = false;
        this.sincroniza();
    }

    private void sincroniza() {
        1 task = new /* Unavailable Anonymous Inner Class!! */;
        Thread thread = new Thread((Runnable)task);
        task.setOnSucceeded(evt -> this.sincroniza());
        task.setOnFailed(evt -> this.sincroniza());
        thread.start();
    }

    private void sincronizaEstados() {
        List estados = this.estadoService.listaSincronizar();
        System.out.println("===== Estados sincronizar: " + estados.size());
        estados.forEach(estado -> {
            try {
                EstadoDto estadoDto = this.sincronizacaoService.sincronizaEstado(estado);
                this.listaTabela.add(new VendasExternasSincronizacaoDto(LocalDateTime.now(), "== ESTADO: " + estadoDto.getNome()));
                this.existeSincronizacao = true;
            }
            catch (MaximaException ex) {
                Logger.getLogger(PedidoVendaExternaController.class.getName()).log(Level.SEVERE, null, ex);
                this.listaTabela.add(new VendasExternasSincronizacaoDto(LocalDateTime.now(), "== ESTADO FALHA: " + estado.getNome()));
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(SincronizacaoController.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.loadTabela();
        });
    }

    private void sincronizaMunicipios() {
        List municipios = this.municipioService.listaSincronizar();
        System.out.println("===== Municipios sincronizar: " + municipios.size());
        municipios.forEach(municipio -> {
            try {
                MunicipioDto municipioDto = this.sincronizacaoService.sincronizaMunicipio(municipio);
                this.listaTabela.add(new VendasExternasSincronizacaoDto(LocalDateTime.now(), "== MUNICIPIO: " + municipioDto.getNome()));
                this.existeSincronizacao = true;
            }
            catch (MaximaException ex) {
                Logger.getLogger(PedidoVendaExternaController.class.getName()).log(Level.SEVERE, null, ex);
                this.listaTabela.add(new VendasExternasSincronizacaoDto(LocalDateTime.now(), "== MUNICIPIO FALHA: " + municipio.getNome()));
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(SincronizacaoController.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.loadTabela();
        });
    }

    private void sincronizaUnidades() {
        List unidades = this.unidadeService.listaSincronizar();
        System.out.println("===== Unidades sincronizar: " + unidades.size());
        unidades.forEach(unidade -> {
            try {
                UnidadeDto unidadeDto = this.sincronizacaoService.sincronizaUnidade(unidade);
                this.listaTabela.add(new VendasExternasSincronizacaoDto(LocalDateTime.now(), "== UNIDADE: " + unidadeDto.getNome()));
                this.existeSincronizacao = true;
            }
            catch (MaximaException ex) {
                Logger.getLogger(PedidoVendaExternaController.class.getName()).log(Level.SEVERE, null, ex);
                this.listaTabela.add(new VendasExternasSincronizacaoDto(LocalDateTime.now(), "== UNIDADE FALHA: " + unidade.getNome()));
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(SincronizacaoController.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.loadTabela();
        });
    }

    private void sincronizaCategoriaProdutos() {
        List categoriaProdutos = this.categoriaProdutoService.listaSincronizar();
        System.out.println("===== CategoriaProdutos sincronizar: " + categoriaProdutos.size());
        categoriaProdutos.forEach(categoriaProduto -> {
            try {
                CategoriaProdutoDto categoriaProdutoDto = this.sincronizacaoService.sincronizaCategoriaProduto(categoriaProduto);
                this.listaTabela.add(new VendasExternasSincronizacaoDto(LocalDateTime.now(), "== CATEGORIA PRODUTO: " + categoriaProdutoDto.getNome()));
                this.existeSincronizacao = true;
            }
            catch (MaximaException ex) {
                Logger.getLogger(PedidoVendaExternaController.class.getName()).log(Level.SEVERE, null, ex);
                this.listaTabela.add(new VendasExternasSincronizacaoDto(LocalDateTime.now(), "== CATEGORIA PRODUTO FALHA: " + categoriaProduto.getNome()));
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(SincronizacaoController.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.loadTabela();
        });
    }

    private List<VendedorDto> sincronizaVendedores() {
        ArrayList<VendedorDto> lista = new ArrayList<VendedorDto>();
        List vendedores = this.vendedorService.listaSincronizar();
        System.out.println("===== Vendedor sincronizar: " + vendedores.size());
        vendedores.forEach(vendedor -> {
            if (vendedor.getLogin() != null && !vendedor.getLogin().isEmpty()) {
                try {
                    VendedorDto vendedorDto = this.sincronizacaoService.sincronizaVendedor(vendedor);
                    if (vendedorDto.getAtivo().booleanValue()) {
                        lista.add(vendedorDto);
                    }
                    this.listaTabela.add(new VendasExternasSincronizacaoDto(LocalDateTime.now(), "== VENDEDOR: " + vendedorDto.getNome()));
                    this.existeSincronizacao = true;
                }
                catch (MaximaException ex) {
                    Logger.getLogger(PedidoVendaExternaController.class.getName()).log(Level.SEVERE, null, ex);
                    this.listaTabela.add(new VendasExternasSincronizacaoDto(LocalDateTime.now(), "== VENDEDOR FALHA: " + vendedor.getNome()));
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(SincronizacaoController.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.loadTabela();
            }
        });
        return lista;
    }

    private void sincronizaClientes() {
        List clientes = this.clienteService.listaSincronizar();
        System.out.println("===== Cliente sincronizar: " + clientes.size());
        clientes.forEach(cliente -> {
            try {
                ClienteDto clienteDto = this.sincronizacaoService.sincronizaCliente(cliente);
                this.listaTabela.add(new VendasExternasSincronizacaoDto(LocalDateTime.now(), "== CLIENTE: " + clienteDto.getNome()));
                this.existeSincronizacao = true;
            }
            catch (MaximaException ex) {
                Logger.getLogger(PedidoVendaExternaController.class.getName()).log(Level.SEVERE, null, ex);
                this.listaTabela.add(new VendasExternasSincronizacaoDto(LocalDateTime.now(), "== CLIENTE FALHA: " + cliente.getNome()));
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(SincronizacaoController.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.loadTabela();
        });
    }

    private List<ProdutoDto> sincronizaProdutos() {
        ArrayList<ProdutoDto> lista = new ArrayList<ProdutoDto>();
        List produtos = this.produtoService.listaSincronizar();
        System.out.println("===== Produto sincronizar: " + produtos.size());
        produtos.forEach(produto -> {
            try {
                ProdutoDto produtoDto = this.sincronizacaoService.sincronizaProduto(produto);
                lista.add(produtoDto);
                this.listaTabela.add(new VendasExternasSincronizacaoDto(LocalDateTime.now(), "== PRODUTO: " + produtoDto.getNome()));
                this.existeSincronizacao = true;
            }
            catch (MaximaException ex) {
                Logger.getLogger(PedidoVendaExternaController.class.getName()).log(Level.SEVERE, null, ex);
                this.listaTabela.add(new VendasExternasSincronizacaoDto(LocalDateTime.now(), "== PRODUTO FALHA: " + produto.getNome()));
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(SincronizacaoController.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.loadTabela();
        });
        return lista;
    }

    private List<VendedorProdutoDto> sincronizaEstoqueEmpresa(List<ProdutoDto> produtoLista, List<VendedorDto> vendedorLista) {
        ArrayList<VendedorProdutoDto> lista = new ArrayList<VendedorProdutoDto>();
        if (produtoLista != null && !produtoLista.isEmpty()) {
            produtoLista.forEach(produtoDto -> {
                if (produtoDto.getVendasExternas().booleanValue()) {
                    List vendedores = this.vendedorService.listaVendedorEstoqueEmpresa();
                    vendedores.forEach(vendedor -> {
                        try {
                            VendedorProdutoDto vendedorProdutoDto = this.sincronizacaoService.sincronizaVendedorProduto(vendedor.getId(), produtoDto.getId());
                            lista.add(vendedorProdutoDto);
                            this.listaTabela.add(new VendasExternasSincronizacaoDto(LocalDateTime.now(), "== ESTOQUE EMPRESA: " + vendedorProdutoDto.getVendedor().getNome() + " | " + vendedorProdutoDto.getProduto().getNome()));
                            this.existeSincronizacao = true;
                        }
                        catch (MaximaException ex) {
                            Logger.getLogger(PedidoVendaExternaController.class.getName()).log(Level.SEVERE, null, ex);
                            this.listaTabela.add(new VendasExternasSincronizacaoDto(LocalDateTime.now(), "== ESTOQUE EMPRESA FALHA: " + vendedor.getNome() + " | " + produtoDto.getNome()));
                        }
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(SincronizacaoController.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        this.loadTabela();
                    });
                }
            });
        }
        if (vendedorLista != null && !vendedorLista.isEmpty()) {
            vendedorLista.forEach(vendedorDto -> {
                List produtos = this.produtoService.listaVendasExternas();
                produtos.forEach(produto -> {
                    boolean sincronizado = false;
                    for (VendedorProdutoDto dto : lista) {
                        if (!dto.getProduto().getId().equals(produto.getId()) || !dto.getVendedor().getId().equals(vendedorDto.getId())) continue;
                        sincronizado = true;
                        break;
                    }
                    if (!sincronizado) {
                        try {
                            VendedorProdutoDto vendedorProdutoDto = this.sincronizacaoService.sincronizaVendedorProduto(vendedorDto.getId(), produto.getId());
                            this.listaTabela.add(new VendasExternasSincronizacaoDto(LocalDateTime.now(), "== ESTOQUE EMPRESA: " + vendedorProdutoDto.getVendedor().getNome() + " | " + vendedorProdutoDto.getProduto().getNome()));
                            this.existeSincronizacao = true;
                        }
                        catch (MaximaException ex) {
                            Logger.getLogger(PedidoVendaExternaController.class.getName()).log(Level.SEVERE, null, ex);
                            System.out.println("==== FALHA SINCRONIZACAO: " + vendedorDto.getNome() + " | " + produto.getNome());
                            this.listaTabela.add(new VendasExternasSincronizacaoDto(LocalDateTime.now(), "== ESTOQUE EMPRESA FALHA: " + vendedorDto.getNome() + " | " + produto.getNome()));
                        }
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(SincronizacaoController.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        this.loadTabela();
                    }
                });
            });
        }
        return lista;
    }

    private void sincronizaEstoqueVendedor(List<VendedorDto> vendedores) {
        List lista = this.vendedorProdutoService.listaSincronizar();
        lista.forEach(vendedorProduto -> {
            try {
                if (vendedorProduto.getVendedor().getLogin() != null && !vendedorProduto.getVendedor().getLogin().isEmpty()) {
                    VendedorProdutoDto vendedorProdutoDto = this.sincronizacaoService.sincronizaVendedorProduto(vendedorProduto);
                    this.listaTabela.add(new VendasExternasSincronizacaoDto(LocalDateTime.now(), "== ESTOQUE VENDEDOR: " + vendedorProdutoDto.getVendedor().getNome() + " | " + vendedorProdutoDto.getProduto().getNome()));
                    this.existeSincronizacao = true;
                }
            }
            catch (MaximaException ex) {
                Logger.getLogger(PedidoVendaExternaController.class.getName()).log(Level.SEVERE, null, ex);
                this.listaTabela.add(new VendasExternasSincronizacaoDto(LocalDateTime.now(), "== ESTOQUE VENDEDOR FALHA: " + vendedorProduto.getVendedor().getNome() + " | " + vendedorProduto.getProduto().getNome()));
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(SincronizacaoController.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.loadTabela();
        });
    }

    private void sincronizaCondicaoRecebimento() {
        List recebimentos = this.condicaoRecebimentoService.listaSincronizar();
        System.out.println("===== Condic\u00e7\u00f5es recebimentos sincronizar: " + recebimentos.size());
        recebimentos.forEach(recebimento -> {
            try {
                CondicaoRecebimentoDto condicaoRecebimentoDto = this.sincronizacaoService.sincronizaCondicaoRecebimento(recebimento);
                this.listaTabela.add(new VendasExternasSincronizacaoDto(LocalDateTime.now(), "== CONDICAO RECEBIMENTO: " + condicaoRecebimentoDto.getNome()));
                this.existeSincronizacao = true;
            }
            catch (MaximaException ex) {
                Logger.getLogger(PedidoVendaExternaController.class.getName()).log(Level.SEVERE, null, ex);
                this.listaTabela.add(new VendasExternasSincronizacaoDto(LocalDateTime.now(), "== FALHA CONDICAO RECEBIMENTO: " + recebimento.getNome()));
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(SincronizacaoController.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.loadTabela();
        });
    }

    private void sincronizaPedidos() {
        List pedidos;
        try {
            pedidos = this.sincronizacaoService.listaPedidosEmAberto();
        }
        catch (MaximaException ex) {
            Logger.getLogger(PedidoVendaExternaController.class.getName()).log(Level.SEVERE, null, ex);
            System.out.println("== Falha ao listar pedidos em aberto ==");
            return;
        }
        pedidos.forEach(pedidoDto -> {
            try {
                this.sincronizacaoService.sincronizaPedidos(pedidoDto);
                this.listaTabela.add(new VendasExternasSincronizacaoDto(LocalDateTime.now(), "== SINCRONIZADO PEDIDO: " + pedidoDto.getId() + " | " + pedidoDto.getCliente().getNome()));
                this.existeSincronizacao = true;
            }
            catch (MaximaException ex) {
                Logger.getLogger(PedidoVendaExternaController.class.getName()).log(Level.SEVERE, null, ex);
                System.out.println("===== FALHA SINCRONIZAR PEDIDO: " + pedidoDto.getId() + " | " + pedidoDto.getVendedor().getNome() + " | " + pedidoDto.getCliente().getNome() + " | " + ex.getMessage());
                this.listaTabela.add(new VendasExternasSincronizacaoDto(LocalDateTime.now(), "== FALHA SINCRONIZAR PEDIDO: " + pedidoDto.getId() + " | " + pedidoDto.getVendedor().getNome() + " | " + pedidoDto.getCliente().getNome() + " | " + ex.getMessage()));
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(SincronizacaoController.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.loadTabela();
        });
    }

    private void carregaIcones() {
    }

    private void registraAcoes() {
        this.btnLimpar.setOnAction(evt -> {
            this.listaTabela = new ArrayList();
            this.loadTabela();
        });
        this.btnFinalizar.setOnAction(evt -> {
            if (MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja encerrar o sistema de sincroniza\u00e7\u00e3o com o aplicativo?")) {
                System.exit(0);
            }
        });
    }

    private void loadTabela() {
        ObservableList pedidoVendaExternaList = FXCollections.observableArrayList();
        Collections.sort(this.listaTabela);
        pedidoVendaExternaList.addAll((Collection)this.listaTabela);
        this.tabela.setItems(pedidoVendaExternaList);
    }

    private void setColumnProperties() {
        this.colDataHora.setCellValueFactory((Callback)new PropertyValueFactory("dataOperacao"));
        this.colDescricao.setCellValueFactory((Callback)new PropertyValueFactory("descricao"));
    }

    static /* synthetic */ Boolean access$002(SincronizacaoController x0, Boolean x1) {
        x0.existeSincronizacao = x1;
        return x0.existeSincronizacao;
    }

    static /* synthetic */ Boolean access$102(SincronizacaoController x0, Boolean x1) {
        x0.servidorOn = x1;
        return x0.servidorOn;
    }

    static /* synthetic */ SincronizacaoService access$200(SincronizacaoController x0) {
        return x0.sincronizacaoService;
    }

    static /* synthetic */ Boolean access$100(SincronizacaoController x0) {
        return x0.servidorOn;
    }

    static /* synthetic */ Circle access$300(SincronizacaoController x0) {
        return x0.iconeServidorStatus;
    }

    static /* synthetic */ void access$400(SincronizacaoController x0) {
        x0.sincronizaEstados();
    }

    static /* synthetic */ void access$500(SincronizacaoController x0) {
        x0.sincronizaMunicipios();
    }

    static /* synthetic */ void access$600(SincronizacaoController x0) {
        x0.sincronizaUnidades();
    }

    static /* synthetic */ void access$700(SincronizacaoController x0) {
        x0.sincronizaCategoriaProdutos();
    }

    static /* synthetic */ void access$800(SincronizacaoController x0) {
        x0.sincronizaCondicaoRecebimento();
    }

    static /* synthetic */ List access$900(SincronizacaoController x0) {
        return x0.sincronizaProdutos();
    }

    static /* synthetic */ List access$1000(SincronizacaoController x0) {
        return x0.sincronizaVendedores();
    }

    static /* synthetic */ void access$1100(SincronizacaoController x0) {
        x0.sincronizaClientes();
    }

    static /* synthetic */ List access$1200(SincronizacaoController x0, List x1, List x2) {
        return x0.sincronizaEstoqueEmpresa(x1, x2);
    }

    static /* synthetic */ void access$1300(SincronizacaoController x0, List x1) {
        x0.sincronizaEstoqueVendedor(x1);
    }

    static /* synthetic */ void access$1400(SincronizacaoController x0) {
        x0.sincronizaPedidos();
    }

    static /* synthetic */ Label access$1500(SincronizacaoController x0) {
        return x0.labelServidorStatus;
    }
}

