/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.vendasexternas.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.geral.controller.VendedorPesquisaController;
import br.com.maximasolutions.geral.modelo.Vendedor;
import br.com.maximasolutions.geral.service.VendedorService;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.vendasexternas.controller.VendedorProdutoLancamentoFormController;
import br.com.maximasolutions.vendasexternas.modelo.VendedorProduto;
import br.com.maximasolutions.vendasexternas.service.VendedorProdutoService;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class VendedorProdutoController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private TableView<VendedorProduto> tabela;
    @FXML
    private TableColumn<VendedorProduto, String> colCodigo;
    @FXML
    private TableColumn<VendedorProduto, String> colProduto;
    @FXML
    private TableColumn<VendedorProduto, BigDecimal> colEstoqueAtual;
    @FXML
    private TableColumn<VendedorProduto, BigDecimal> colPreco;
    @FXML
    private TextField tfVendedorCodigo;
    @FXML
    private TextField tfVendedorDescricao;
    @FXML
    private Button btnVendedor;
    @Autowired
    private VendedorProdutoService vendedorProdutoService;
    @Autowired
    private VendedorService vendedorService;
    private ObservableList<VendedorProduto> vendedorProdutoList;
    private Vendedor vendedor;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.vendedorProdutoList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {});
        this.setColumnProperties();
        this.registraAcoes();
    }

    public void inicializa() {
        this.vendedor = null;
        this.loadTabela();
    }

    private void pesquisaVendedor() {
        String vendedorCodigo = this.tfVendedorCodigo.getText().trim();
        if (vendedorCodigo.isEmpty()) {
            return;
        }
        try {
            Long vendedorCodigoNumero = Long.valueOf(vendedorCodigo);
            Vendedor vendedorPesquisa = this.vendedorService.load(vendedorCodigoNumero.longValue());
            if (vendedorPesquisa != null) {
                this.vendedor = vendedorPesquisa;
                this.loadDadosVendedor();
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.pesquisaVendedorForm();
    }

    private void pesquisaVendedorForm() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/geral/vendedor/VendedorPesquisa.fxml", "Pesquisa de vendedor");
            VendedorPesquisaController controller = (VendedorPesquisaController)stage.getUserData();
            controller.setValorPesquisa(this.tfVendedorCodigo.getText().trim());
            stage.showAndWait();
            Vendedor vendedorPesquisa = controller.getVendedorSelecionado();
            if (vendedorPesquisa != null) {
                this.vendedor = vendedorPesquisa;
                this.loadDadosVendedor();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(VendedorProdutoLancamentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.alerta((String)("Ocorreu um erro ao abrir janela de pesquisa de vendedores.\n" + ex.getMessage()));
        }
    }

    private void loadDadosVendedor() {
        if (this.vendedor != null) {
            this.tfVendedorCodigo.setText(this.vendedor.getId().toString());
            this.tfVendedorDescricao.setText(this.vendedor.getNome().toUpperCase());
            this.loadTabela();
        } else {
            this.tfVendedorCodigo.setText("");
            this.tfVendedorDescricao.setText("");
            this.tfVendedorCodigo.requestFocus();
        }
    }

    private void loadTabela() {
        this.vendedorProdutoList.clear();
        if (this.vendedor != null) {
            this.vendedorProdutoList.addAll((Collection)this.vendedorProdutoService.list(this.vendedor));
        }
        this.tabela.setItems(this.vendedorProdutoList);
    }

    private void carregaIcones() {
    }

    private void setColumnProperties() {
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("codigo"));
        this.colProduto.setCellValueFactory((Callback)new PropertyValueFactory("descricao"));
        this.colEstoqueAtual.setCellValueFactory((Callback)new PropertyValueFactory("estoqueAtual"));
        this.colPreco.setCellValueFactory((Callback)new PropertyValueFactory("precoVenda"));
        this.colEstoqueAtual.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colPreco.setCellFactory((Callback)new ColumnNumberFormatter());
    }

    private void registraAcoes() {
        this.btnVendedor.setOnAction(event -> this.pesquisaVendedorForm());
        this.tfVendedorCodigo.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaVendedor();
            }
        });
    }
}

