/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.vendasexternas.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.controller.ProdutoPesquisaController;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.service.ProdutoService;
import br.com.maximasolutions.geral.controller.VendedorPesquisaController;
import br.com.maximasolutions.geral.modelo.Vendedor;
import br.com.maximasolutions.geral.service.VendedorService;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.vendasexternas.modelo.VendedorProdutoLancamento;
import br.com.maximasolutions.vendasexternas.modelo.VendedorProdutoLancamentoItem;
import br.com.maximasolutions.vendasexternas.service.VendedorProdutoLancamentoService;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class VendedorProdutoLancamentoFormController
extends MaximaController
implements Initializable {
    @FXML
    private TextField tfVendedorCodigo;
    @FXML
    private TextField tfVendedorDescricao;
    @FXML
    private TextField tfObservacao;
    @FXML
    private TextField tfProdutoCodigo;
    @FXML
    private TextField tfProdutoDescricao;
    @FXML
    private TextField tfProdutoQuantidade;
    @FXML
    private TextField tfProdutoValorUnitario;
    @FXML
    private TextField tfProdutoValorTotal;
    @FXML
    private TextField tfProdutoValorVenda;
    @FXML
    private DatePicker tfDataLancamento;
    @FXML
    private TableView<VendedorProdutoLancamentoItem> tabela;
    @FXML
    private TableColumn<VendedorProdutoLancamentoItem, String> colCodigo;
    @FXML
    private TableColumn<VendedorProdutoLancamentoItem, String> colProduto;
    @FXML
    private TableColumn<VendedorProdutoLancamentoItem, BigDecimal> colQuantidade;
    @FXML
    private TableColumn<VendedorProdutoLancamentoItem, BigDecimal> colPrecoUnitario;
    @FXML
    private TableColumn<VendedorProdutoLancamentoItem, BigDecimal> colPrecoTotal;
    @FXML
    private TableColumn<VendedorProdutoLancamentoItem, BigDecimal> colPrecoSugerido;
    @FXML
    private Button btnSalva;
    @FXML
    private Button btnVendedor;
    @FXML
    private Button btnProduto;
    @FXML
    private Button btnProdutoAdd;
    @Autowired
    @Lazy
    private StageManager stageManager;
    @Autowired
    private ProdutoService produtoService;
    @Autowired
    private VendedorService vendedorService;
    @Autowired
    private VendedorProdutoLancamentoService lancamentoService;
    private Produto produto;
    private Vendedor vendedor;
    private VendedorProdutoLancamento vendedorProdutoLancamento;
    private List<VendedorProdutoLancamentoItem> itens;
    private ObservableList<VendedorProdutoLancamentoItem> vendedorProdutoLancamentoItemList;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.carregaCombos();
        this.carregaMascaras();
        this.setColumnProperties();
    }

    public void inicializa() {
        this.vendedorProdutoLancamentoItemList = FXCollections.observableArrayList();
        this.vendedor = null;
        this.produto = null;
        this.vendedorProdutoLancamento = null;
        this.itens = null;
        this.loadTabela();
    }

    private void salva() {
        if (this.vendedorProdutoLancamento == null) {
            this.vendedorProdutoLancamento = new VendedorProdutoLancamento();
        }
        this.vendedorProdutoLancamento.setVendedor(this.vendedor);
        this.vendedorProdutoLancamento.setDataLancamento((LocalDate)this.tfDataLancamento.getValue());
        this.vendedorProdutoLancamento.setObservacao(this.tfObservacao.getText().trim());
        if (!this.validaForm()) {
            return;
        }
        this.vendedorProdutoLancamento = this.lancamentoService.salva(this.vendedorProdutoLancamento, this.itens);
        MaximaAlert.mensagemInformativa((String)"Lan\u00e7amento realizado com sucesso.");
        this.close();
    }

    private void addProduto() {
        if (this.produto == null) {
            MaximaAlert.alerta((String)"Selecione um produto para adicionar.");
            return;
        }
        VendedorProdutoLancamentoItem item = new VendedorProdutoLancamentoItem();
        item.setProduto(this.produto);
        item.setDataLancamento(LocalDate.now());
        item.setPrecoSugerido(MaximaNumber.quantidadeToBigDecimal((String)this.tfProdutoValorVenda.getText()));
        item.setPrecoTotal(MaximaNumber.quantidadeToBigDecimal((String)this.tfProdutoValorTotal.getText()));
        item.setPrecoUnitario(MaximaNumber.quantidadeToBigDecimal((String)this.tfProdutoValorUnitario.getText()));
        item.setProdutoCodigo(this.produto.getCodigo());
        item.setProdutoDescricao(this.produto.getNome());
        item.setQuantidade(MaximaNumber.quantidadeToBigDecimal((String)this.tfProdutoQuantidade.getText()));
        item.setUnidade(this.produto.getUnidade().getSigla());
        if (!this.validaFormProduto(item)) {
            return;
        }
        if (this.itens == null) {
            this.itens = new ArrayList();
        }
        item.setSequencia(Integer.valueOf(this.itens.size() + 1));
        this.itens.add(item);
        this.loadTabela();
        this.inicializaProduto();
    }

    private void organizaSequencia() {
        int cont = 1;
        for (VendedorProdutoLancamentoItem i : this.itens) {
            i.setSequencia(Integer.valueOf(cont));
            ++cont;
        }
    }

    private void removeProduto() {
        VendedorProdutoLancamentoItem item = (VendedorProdutoLancamentoItem)this.tabela.getSelectionModel().getSelectedItem();
        if (item == null) {
            return;
        }
        if (!MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja remover o produto selecionado?")) {
            return;
        }
        for (VendedorProdutoLancamentoItem i : this.itens) {
            if (!item.getSequencia().equals(i.getSequencia())) continue;
            this.itens.remove(i);
            break;
        }
        this.organizaSequencia();
        this.loadTabela();
        this.inicializaProduto();
    }

    private void calculaTotalProduto() {
        BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfProdutoQuantidade.getText());
        BigDecimal valorUnitario = MaximaNumber.quantidadeToBigDecimal((String)this.tfProdutoValorUnitario.getText());
        BigDecimal valorTotal = quantidade.multiply(valorUnitario).setScale(2, RoundingMode.HALF_EVEN);
        this.tfProdutoValorTotal.setText(MaximaNumber.bigDecimalToString((BigDecimal)valorTotal, (int)2));
    }

    private void pesquisaVendedor() {
        String vendedorCodigo = this.tfVendedorCodigo.getText().trim();
        if (vendedorCodigo.isEmpty()) {
            return;
        }
        try {
            Long vendedorCodigoNumero = Long.valueOf(vendedorCodigo);
            Vendedor vendedorPesquisa = this.vendedorService.load(vendedorCodigoNumero.longValue());
            if (vendedorPesquisa != null) {
                this.vendedor = vendedorPesquisa;
                this.loadDadosVendedor();
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.pesquisaVendedorForm();
    }

    private void pesquisaVendedorForm() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/geral/vendedor/VendedorPesquisa.fxml", "Pesquisa de vendedor");
            VendedorPesquisaController controller = (VendedorPesquisaController)stage.getUserData();
            controller.setValorPesquisa(this.tfVendedorCodigo.getText().trim());
            stage.showAndWait();
            Vendedor vendedorPesquisa = controller.getVendedorSelecionado();
            if (vendedorPesquisa != null) {
                this.vendedor = vendedorPesquisa;
                this.loadDadosVendedor();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(VendedorProdutoLancamentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.alerta((String)("Ocorreu um erro ao abrir janela de pesquisa de vendedores.\n" + ex.getMessage()));
        }
    }

    private void loadDadosVendedor() {
        if (this.vendedor != null) {
            this.tfVendedorCodigo.setText(this.vendedor.getId().toString());
            this.tfVendedorDescricao.setText(this.vendedor.getNome().toUpperCase());
            this.tfDataLancamento.requestFocus();
        } else {
            this.tfVendedorCodigo.setText("");
            this.tfVendedorDescricao.setText("");
            this.tfVendedorCodigo.requestFocus();
        }
    }

    private void pesquisaProduto() {
        String produtoCodigo = this.tfProdutoCodigo.getText().trim();
        if (produtoCodigo.isEmpty()) {
            return;
        }
        Produto produtoPesquisa = this.produtoService.getByCodigoBarras(produtoCodigo);
        if (produtoPesquisa != null) {
            this.produto = produtoPesquisa;
            this.loadDadosProduto();
            return;
        }
        this.pesquisaProdutoForm();
    }

    private void pesquisaProdutoForm() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/produto/ProdutoPesquisa.fxml", "Pesquisa de produto");
            ProdutoPesquisaController controller = (ProdutoPesquisaController)stage.getUserData();
            controller.setValorPesquisa(this.tfProdutoCodigo.getText().trim());
            stage.showAndWait();
            Produto produtoPesquisa = controller.getProdutoSelecionado();
            if (produtoPesquisa != null) {
                this.produto = produtoPesquisa;
                this.loadDadosProduto();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(VendedorProdutoLancamentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.alerta((String)("Ocorreu um erro ao abrir janela de pesquisa de produtos.\n" + ex.getMessage()));
        }
    }

    private void loadDadosProduto() {
        if (this.produto != null) {
            this.tfProdutoCodigo.setText(this.produto.getCodigo());
            this.tfProdutoDescricao.setText(this.produto.getNome().toUpperCase());
            this.tfProdutoValorUnitario.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getPrecoVenda(), (int)2));
            this.tfProdutoQuantidade.requestFocus();
        } else {
            this.tfProdutoCodigo.setText("");
            this.tfProdutoDescricao.setText("");
            this.tfProdutoQuantidade.setText("");
            this.tfProdutoValorUnitario.setText("");
            this.tfProdutoValorTotal.setText("");
            this.tfProdutoValorVenda.setText("");
            this.tfProdutoCodigo.requestFocus();
        }
    }

    public void inicializa(Vendedor vendedor1) {
        this.inicializaProduto();
        this.vendedor = null;
        this.vendedorProdutoLancamento = null;
        this.itens = new ArrayList();
        this.tfVendedorCodigo.requestFocus();
    }

    private void inicializaProduto() {
        this.produto = null;
        this.loadDadosProduto();
    }

    private void close() {
        Stage stage = (Stage)this.btnSalva.getScene().getWindow();
        stage.close();
    }

    private void carregaCombos() {
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void loadTabela() {
        this.vendedorProdutoLancamentoItemList.clear();
        if (this.itens != null) {
            this.vendedorProdutoLancamentoItemList.addAll((Collection)this.itens);
        }
        this.tabela.setItems(this.vendedorProdutoLancamentoItemList);
    }

    private void setColumnProperties() {
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("produtoCodigo"));
        this.colProduto.setCellValueFactory((Callback)new PropertyValueFactory("produtoDescricao"));
        this.colQuantidade.setCellValueFactory((Callback)new PropertyValueFactory("quantidade"));
        this.colPrecoUnitario.setCellValueFactory((Callback)new PropertyValueFactory("precoUnitario"));
        this.colPrecoTotal.setCellValueFactory((Callback)new PropertyValueFactory("precoTotal"));
        this.colPrecoSugerido.setCellValueFactory((Callback)new PropertyValueFactory("precoSugerido"));
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.salva());
        this.btnVendedor.setOnAction(event -> this.pesquisaVendedorForm());
        this.btnProduto.setOnAction(event -> this.pesquisaProdutoForm());
        this.btnProdutoAdd.setOnAction(event -> this.addProduto());
        this.tfVendedorCodigo.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaVendedor();
            }
        });
        this.tfProdutoCodigo.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaProduto();
            }
        });
        this.tfProdutoQuantidade.setOnKeyReleased(event -> this.calculaTotalProduto());
        this.tfProdutoValorUnitario.setOnKeyReleased(event -> this.calculaTotalProduto());
        this.tabela.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.DELETE) {
                this.removeProduto();
            }
        });
    }

    private void carregaMascaras() {
        MaximaMask.monetaryField((TextField)this.tfProdutoValorUnitario);
        MaximaMask.monetaryField((TextField)this.tfProdutoValorTotal);
        MaximaMask.monetaryField((TextField)this.tfProdutoValorVenda);
    }

    private boolean validaForm() {
        String msgErro = "";
        if (this.vendedorProdutoLancamento.getVendedor() == null) {
            msgErro = msgErro + "Selecione o vendedor.\n";
        }
        if (this.vendedorProdutoLancamento.getDataLancamento() == null) {
            msgErro = msgErro + "Informe a data de lan\u00e7amento.\n";
        }
        if (!msgErro.isEmpty()) {
            MaximaAlert.alerta((String)msgErro);
            return false;
        }
        return true;
    }

    private boolean validaFormProduto(VendedorProdutoLancamentoItem item) {
        String msgErro = "";
        if (item.getProduto() == null) {
            msgErro = msgErro + "Selecione o produto.\n";
        }
        if (item.getQuantidade() == null || item.getQuantidade().compareTo(BigDecimal.ZERO) <= 0) {
            msgErro = msgErro + "Informe a quantidade maior que zero.\n";
        }
        if (item.getPrecoUnitario() == null) {
            msgErro = msgErro + "Informe o valor unit\u00e1rio.\n";
        }
        if (item.getPrecoSugerido() == null) {
            msgErro = msgErro + "Informe o valor sugerido para venda.\n";
        }
        if (!msgErro.isEmpty()) {
            MaximaAlert.alerta((String)msgErro);
            return false;
        }
        return true;
    }
}

