/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.vendasexternas.repository;

import br.com.maximasolutions.vendasexternas.modelo.PedidoItemVendaExterna;
import java.time.LocalDate;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface PedidoItemVendaExternaRepository
extends JpaRepository<PedidoItemVendaExterna, Long> {
    @Query(value="SELECT o FROM PedidoItemVendaExterna o WHERE o.pedido.id = :pedidoId ORDER BY o.produto.nome")
    public List<PedidoItemVendaExterna> list(@Param(value="pedidoId") Long var1);

    @Query(value="SELECT o.codigo, o.descricao, SUM(o.quantidade), AVG(o.valorUnitario), SUM(o.valorTotal) FROM PedidoItemVendaExterna o WHERE o.pedido.confirmado = true AND o.pedido.excluido = false AND o.pedido.dataPedido BETWEEN :dataInicio AND :dataFim GROUP BY o.produto.id ORDER BY o.produto.nome")
    public List<Object[]> lista(@Param(value="dataInicio") LocalDate var1, @Param(value="dataFim") LocalDate var2);

    @Query(value="SELECT o.codigo, o.descricao, SUM(o.quantidade), AVG(o.valorUnitario), SUM(o.valorTotal) FROM PedidoItemVendaExterna o WHERE o.pedido.confirmado = true AND o.pedido.excluido = false AND (o.pedido.dataPedido BETWEEN :dataInicio AND :dataFim) and o.pedido.vendedor.id = :vendedorId GROUP BY o.produto.id ORDER BY o.produto.nome")
    public List<Object[]> lista(@Param(value="dataInicio") LocalDate var1, @Param(value="dataFim") LocalDate var2, @Param(value="vendedorId") Long var3);
}

