/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.vendasexternas.service;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.repository.ConfiguracaoRepository;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.core.MaximaWebAPI;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.modelo.ProdutoExtrato;
import br.com.maximasolutions.estoque.modelo.ProdutoExtratoTipo;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.modelo.VendaProdutoFaturamento;
import br.com.maximasolutions.estoque.modelo.VendaProdutoItem;
import br.com.maximasolutions.estoque.modelo.VendaProdutoTipoEmissao;
import br.com.maximasolutions.estoque.repository.ProdutoExtratoRepository;
import br.com.maximasolutions.estoque.repository.ProdutoRepository;
import br.com.maximasolutions.estoque.repository.VendaProdutoFaturamentoRepository;
import br.com.maximasolutions.estoque.repository.VendaProdutoItemRepository;
import br.com.maximasolutions.estoque.repository.VendaProdutoRepository;
import br.com.maximasolutions.estoque.service.VendaProdutoService;
import br.com.maximasolutions.financeiro.modelo.CondicaoRecebimento;
import br.com.maximasolutions.financeiro.modelo.ContaReceberParcela;
import br.com.maximasolutions.financeiro.modelo.MovimentoCaixa;
import br.com.maximasolutions.financeiro.repository.CondicaoRecebimentoRepository;
import br.com.maximasolutions.financeiro.repository.ContaReceberParcelaRepository;
import br.com.maximasolutions.financeiro.repository.ContaReceberRepository;
import br.com.maximasolutions.financeiro.repository.MovimentacaoEntradaRepository;
import br.com.maximasolutions.financeiro.repository.MovimentoCaixaRepository;
import br.com.maximasolutions.geral.modelo.Vendedor;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.vendasexternas.bean.PedidoItemVendaExternaBean;
import br.com.maximasolutions.vendasexternas.bean.PedidoVendaExternaBean;
import br.com.maximasolutions.vendasexternas.dto.PedidoVendaExternaDto;
import br.com.maximasolutions.vendasexternas.modelo.PedidoItemVendaExterna;
import br.com.maximasolutions.vendasexternas.modelo.PedidoVendaExterna;
import br.com.maximasolutions.vendasexternas.modelo.PedidoVendaExternaStatus;
import br.com.maximasolutions.vendasexternas.modelo.PedidoVendaExternaTipo;
import br.com.maximasolutions.vendasexternas.modelo.VendedorProduto;
import br.com.maximasolutions.vendasexternas.modelo.VendedorProdutoExtrato;
import br.com.maximasolutions.vendasexternas.modelo.VendedorProdutoExtratoTipo;
import br.com.maximasolutions.vendasexternas.repository.PedidoItemVendaExternaRepository;
import br.com.maximasolutions.vendasexternas.repository.PedidoVendaExternaRepository;
import br.com.maximasolutions.vendasexternas.repository.VendedorProdutoExtratoRepository;
import br.com.maximasolutions.vendasexternas.repository.VendedorProdutoRepository;
import br.com.maximasolutions.vendasexternas.service.PedidoVendaExternaService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={MaximaException.class, MaximaValidacaoException.class})
public class PedidoVendaExternaServiceImpl
implements PedidoVendaExternaService {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private PedidoVendaExternaRepository pedidoRepository;
    @Autowired
    private PedidoItemVendaExternaRepository pedidoItemRepository;
    @Autowired
    private VendedorProdutoRepository vendedorProdutoRepository;
    @Autowired
    private MovimentoCaixaRepository movimentoCaixaRepository;
    @Autowired
    private VendaProdutoRepository vendaProdutoRepository;
    @Autowired
    private VendaProdutoItemRepository vendaProdutoItemRepository;
    @Autowired
    private CondicaoRecebimentoRepository condicaoRecebimentoRepository;
    @Autowired
    private ContaReceberRepository contaReceberRepository;
    @Autowired
    private ContaReceberParcelaRepository contaReceberParcelaRepository;
    @Autowired
    private ConfiguracaoRepository configuracaoRepository;
    @Autowired
    private VendedorProdutoExtratoRepository vendedorProdutoExtratoRepository;
    @Autowired
    private MovimentacaoEntradaRepository movimentacaoEntradaRepository;
    @Autowired
    private VendaProdutoFaturamentoRepository vendaProdutoFaturamentoRepository;
    @Autowired
    private ProdutoRepository produtoRepository;
    @Autowired
    private ProdutoExtratoRepository produtoExtratoRepository;
    @Autowired
    private VendaProdutoService vendaProdutoService;

    @Transactional(readOnly=true)
    public PedidoVendaExterna get(Long id) {
        Optional pedido = this.pedidoRepository.findById((Object)id);
        if (!pedido.isPresent()) {
            return null;
        }
        return (PedidoVendaExterna)pedido.get();
    }

    @Transactional(rollbackFor={MaximaException.class})
    public PedidoVendaExterna confirma(PedidoVendaExterna pedidoVendaExterna) throws MaximaException {
        if ((pedidoVendaExterna = (PedidoVendaExterna)this.pedidoRepository.findById((Object)pedidoVendaExterna.getId()).get()).getConfirmado().booleanValue()) {
            throw new MaximaException("AVISO: Pedido de venda j\u00e1 confirmado.");
        }
        MovimentoCaixa movimentoCaixa = this.movimentoCaixaRepository.getCaixaAberto(1L);
        if (movimentoCaixa == null) {
            throw new MaximaException("AVISO: Nenhum movimento de caixa aberto.\nVenda n\u00e3o pode ser confirmada.");
        }
        CondicaoRecebimento condicaoPagamento = (CondicaoRecebimento)this.condicaoRecebimentoRepository.findById((Object)pedidoVendaExterna.getPagamentoId()).get();
        if (condicaoPagamento == null) {
            throw new MaximaException("AVISO: Nenhuma condi\u00e7\u00e3o de pagamento informada.\nVenda n\u00e3o pode ser confirmada.");
        }
        Configuracao conf = this.configuracaoRepository.load();
        if (conf == null) {
            throw new MaximaException("AVISO: N\u00e3o foi poss\u00edvel carregar a tabela de configura\u00e7\u00f5es.\nVenda n\u00e3o pode ser confirmada.");
        }
        this.confirmaPedidoProntaEntrega(pedidoVendaExterna, movimentoCaixa, condicaoPagamento, conf);
        return pedidoVendaExterna;
    }

    private PedidoVendaExterna confirmaPedidoProntaEntrega(PedidoVendaExterna pedidoVendaExterna, MovimentoCaixa movimentoCaixa, CondicaoRecebimento condicaoRecebimento, Configuracao conf) throws MaximaException {
        try {
            pedidoVendaExterna.setConfirmado(Boolean.valueOf(true));
            pedidoVendaExterna.setHoraConfirmacao(LocalDateTime.now());
            pedidoVendaExterna.setStatus(PedidoVendaExternaStatus.CONFIRMADA);
            pedidoVendaExterna.setUsuarioConfirmacao(this.stageManager.getUsuario().getLogin());
            VendaProduto vendaProduto = this.createVendaProduto(pedidoVendaExterna, movimentoCaixa, condicaoRecebimento);
            vendaProduto = (VendaProduto)this.vendaProdutoRepository.save((Object)vendaProduto);
            pedidoVendaExterna.setVendaProduto(vendaProduto);
            pedidoVendaExterna = (PedidoVendaExterna)this.pedidoRepository.save((Object)pedidoVendaExterna);
            List itens = this.pedidoItemRepository.list(pedidoVendaExterna.getId());
            int count = 1;
            BigDecimal custoProdutos = BigDecimal.ZERO;
            BigDecimal custoServicos = BigDecimal.ZERO;
            for (PedidoItemVendaExterna item : itens) {
                VendaProdutoItem vendaProdutoItem;
                if (pedidoVendaExterna.getTipo().equals((Object)PedidoVendaExternaTipo.PRONTA_ENTREGA)) {
                    VendedorProduto vendedorProduto = this.vendedorProdutoRepository.get(vendaProduto.getVendedor().getId(), item.getProduto().getId());
                    if (vendedorProduto == null) {
                        throw new MaximaException("Produto: '" + item.getProduto().getNome() + "' n\u00e3o cadastrado para o vendedor");
                    }
                    BigDecimal estoqueVendedor = vendedorProduto.getEstoqueAtual();
                    vendedorProduto.setEstoqueAtual(vendedorProduto.getEstoqueAtual().subtract(item.getQuantidade()));
                    vendedorProduto.setUltimaAlteracao(LocalDateTime.now());
                    vendedorProduto.setSincronizado(Boolean.valueOf(false));
                    vendedorProduto = (VendedorProduto)this.vendedorProdutoRepository.save((Object)vendedorProduto);
                    vendaProdutoItem = this.createVendaProdutoItem(item, vendaProduto, count);
                    this.vendaProdutoItemRepository.save((Object)vendaProdutoItem);
                    VendedorProdutoExtrato vendedorProdutoExtrato = new VendedorProdutoExtrato(pedidoVendaExterna.getVendedor(), item.getProduto(), LocalDate.now(), VendedorProdutoExtratoTipo.VENDA, item.getQuantidade().multiply(new BigDecimal("-1")), "VENDA EXTERNA", estoqueVendedor, vendedorProduto.getEstoqueAtual());
                    this.vendedorProdutoExtratoRepository.save((Object)vendedorProdutoExtrato);
                }
                if (pedidoVendaExterna.getTipo().equals((Object)PedidoVendaExternaTipo.PEDIDO)) {
                    Produto produto = this.produtoRepository.get(item.getProduto().getUuid());
                    BigDecimal estoqueProduto = produto.getEstoqueAtual();
                    produto.setEstoqueAtual(produto.getEstoqueAtual().subtract(item.getQuantidade()));
                    produto.setUltimaVenda(LocalDate.now());
                    produto.setSincronizado(Boolean.valueOf(false));
                    produto = (Produto)this.produtoRepository.save((Object)produto);
                    vendaProdutoItem = this.createVendaProdutoItem(item, vendaProduto, count);
                    if (produto.getServico().booleanValue()) {
                        custoServicos = custoServicos.add(vendaProdutoItem.getCustoTotalServicos());
                    } else {
                        custoProdutos = custoProdutos.add(vendaProdutoItem.getCustoTotalProdutos());
                    }
                    this.vendaProdutoItemRepository.save((Object)vendaProdutoItem);
                    this.produtoExtratoRepository.save((Object)new ProdutoExtrato(produto, LocalDate.now(), "VENDA EXTERNA", item.getQuantidade().multiply(new BigDecimal("-1")), "VENDA EXTERNA", estoqueProduto, produto.getEstoqueAtual(), ProdutoExtratoTipo.VENDA_DIRETA));
                }
                ++count;
            }
            vendaProduto.setCustoProdutos(custoProdutos);
            vendaProduto.setCustoServicos(custoServicos);
            vendaProduto.setCustoTotal(custoProdutos.add(custoServicos));
            vendaProduto = (VendaProduto)this.vendaProdutoRepository.save((Object)vendaProduto);
            VendaProdutoFaturamento faturamento = this.createFaturamento(condicaoRecebimento, vendaProduto);
            faturamento = (VendaProdutoFaturamento)this.vendaProdutoFaturamentoRepository.save((Object)faturamento);
            ArrayList<VendaProdutoFaturamento> faturamentos = new ArrayList<VendaProdutoFaturamento>();
            faturamentos.add(faturamento);
            vendaProduto = this.vendaProdutoService.faturamento(vendaProduto, faturamentos, BigDecimal.ZERO);
            PedidoVendaExternaDto pedidoDto = (PedidoVendaExternaDto)new MaximaWebAPI(MaximaConfig.getVendasExternasServidorUrl()).enviaSincronizacaoApi((Object)new PedidoVendaExternaDto(pedidoVendaExterna, null), "api/pedidos/confirma", PedidoVendaExternaDto.class);
            return pedidoVendaExterna;
        }
        catch (Exception e) {
            Logger.getLogger(PedidoVendaExternaServiceImpl.class.getSimpleName()).log(Level.SEVERE, null, e);
            throw new MaximaException("Erro: N\u00e3o foi poss\u00edvel confirmar o pedido.\n" + e.getMessage());
        }
    }

    @Transactional(rollbackFor={MaximaException.class})
    public PedidoVendaExterna rejeita(PedidoVendaExterna pedidoVendaExterna) throws MaximaException {
        if ((pedidoVendaExterna = (PedidoVendaExterna)this.pedidoRepository.findById((Object)pedidoVendaExterna.getId()).get()).getExcluido().booleanValue()) {
            throw new MaximaException("Pedido de venda j\u00e1 EXCLU\u00cdDO.");
        }
        if (pedidoVendaExterna.getConfirmado().booleanValue()) {
            throw new MaximaException("Pedido de venda j\u00e1 CONFIRMADO.");
        }
        try {
            pedidoVendaExterna.setStatus(PedidoVendaExternaStatus.REJEITADA);
            pedidoVendaExterna.setHoraConfirmacao(LocalDateTime.now());
            pedidoVendaExterna.setUsuarioConfirmacao(this.stageManager.getUsuario().getLogin());
            pedidoVendaExterna = (PedidoVendaExterna)this.pedidoRepository.save((Object)pedidoVendaExterna);
            PedidoVendaExternaDto pedidoVendaExternaDto = (PedidoVendaExternaDto)new MaximaWebAPI(MaximaConfig.getVendasExternasServidorUrl()).enviaSincronizacaoApi((Object)new PedidoVendaExternaDto(pedidoVendaExterna, null), "api/pedidos/rejeita", PedidoVendaExternaDto.class);
        }
        catch (Exception e) {
            Logger.getLogger(PedidoVendaExternaServiceImpl.class.getSimpleName()).log(Level.SEVERE, null, e);
            throw new MaximaException("Erro: N\u00e3o foi poss\u00edvel excluir o pedido.\n" + e.getMessage());
        }
        return pedidoVendaExterna;
    }

    @Transactional(rollbackFor={MaximaException.class})
    public void exclui(PedidoVendaExterna pedidoVendaExterna) throws MaximaException {
        if ((pedidoVendaExterna = (PedidoVendaExterna)this.pedidoRepository.findById((Object)pedidoVendaExterna.getId()).get()).getExcluido().booleanValue()) {
            throw new MaximaException("Pedido de venda j\u00e1 EXCLU\u00cdDO.");
        }
        try {
            VendaProduto vendaProduto;
            pedidoVendaExterna.setExcluido(Boolean.valueOf(true));
            pedidoVendaExterna.setHoraExclusao(LocalDateTime.now());
            pedidoVendaExterna.setUsuarioExclusao(this.stageManager.getUsuario().getLogin());
            pedidoVendaExterna = (PedidoVendaExterna)this.pedidoRepository.save((Object)pedidoVendaExterna);
            if (pedidoVendaExterna.getStatus().equals((Object)PedidoVendaExternaStatus.CONFIRMADA)) {
                vendaProduto = (VendaProduto)this.vendaProdutoRepository.findById((Object)pedidoVendaExterna.getVendaProduto().getId()).get();
                if (vendaProduto.isFaturado().booleanValue()) {
                    this.vendaProdutoService.deleteFaturamento(vendaProduto, Boolean.TRUE);
                }
                vendaProduto.setExcluida(Boolean.TRUE);
                vendaProduto.setDataExclusao(LocalDateTime.now());
                vendaProduto = (VendaProduto)this.vendaProdutoRepository.save((Object)vendaProduto);
                List itens = this.pedidoItemRepository.list(pedidoVendaExterna.getId());
                for (PedidoItemVendaExterna item : itens) {
                    if (pedidoVendaExterna.getTipo().equals((Object)PedidoVendaExternaTipo.PRONTA_ENTREGA)) {
                        VendedorProduto vendedorProduto = this.vendedorProdutoRepository.get(vendaProduto.getVendedor().getId(), item.getProduto().getId());
                        BigDecimal estoqueVendedor = vendedorProduto.getEstoqueAtual();
                        vendedorProduto.setEstoqueAtual(vendedorProduto.getEstoqueAtual().add(item.getQuantidade()));
                        vendedorProduto.setUltimaAlteracao(LocalDateTime.now());
                        vendedorProduto.setSincronizado(Boolean.valueOf(false));
                        vendedorProduto = (VendedorProduto)this.vendedorProdutoRepository.save((Object)vendedorProduto);
                        VendedorProdutoExtrato vendedorProdutoExtrato = new VendedorProdutoExtrato(pedidoVendaExterna.getVendedor(), item.getProduto(), LocalDate.now(), VendedorProdutoExtratoTipo.VENDA_DELETE, item.getQuantidade().multiply(new BigDecimal("1")), "VENDA EXTERNA DELETE", estoqueVendedor, vendedorProduto.getEstoqueAtual());
                        this.vendedorProdutoExtratoRepository.save((Object)vendedorProdutoExtrato);
                    }
                    if (!pedidoVendaExterna.getTipo().equals((Object)PedidoVendaExternaTipo.PEDIDO)) continue;
                    Produto produto = this.produtoRepository.get(item.getProduto().getUuid());
                    BigDecimal estoqueProduto = produto.getEstoqueAtual();
                    produto.setEstoqueAtual(produto.getEstoqueAtual().add(item.getQuantidade()));
                    produto.setUltimaVenda(LocalDate.now());
                    produto.setSincronizado(Boolean.valueOf(false));
                    produto = (Produto)this.produtoRepository.save((Object)produto);
                    this.produtoExtratoRepository.save((Object)new ProdutoExtrato(produto, LocalDate.now(), "VENDA EXTERNA DELETE", item.getQuantidade().multiply(new BigDecimal("1")), "VENDA EXTERNA DELETE", estoqueProduto, produto.getEstoqueAtual(), ProdutoExtratoTipo.VENDA_DIRETA_DELETE));
                }
            }
            vendaProduto = (PedidoVendaExternaDto)new MaximaWebAPI(MaximaConfig.getVendasExternasServidorUrl()).enviaSincronizacaoApi((Object)new PedidoVendaExternaDto(pedidoVendaExterna, null), "api/pedidos/exclui", PedidoVendaExternaDto.class);
        }
        catch (Exception e) {
            Logger.getLogger(PedidoVendaExternaServiceImpl.class.getSimpleName()).log(Level.SEVERE, null, e);
            throw new MaximaException("Erro: N\u00e3o foi poss\u00edvel excluir o pedido.\n" + e.getMessage());
        }
    }

    @Transactional(readOnly=true)
    public List<PedidoVendaExterna> list() {
        return this.pedidoRepository.list();
    }

    @Transactional(readOnly=true)
    public List<PedidoItemVendaExterna> itens(PedidoVendaExterna pedido) {
        return this.pedidoItemRepository.list(pedido.getId());
    }

    @Transactional(readOnly=true)
    public List<PedidoItemVendaExternaBean> listaItens(LocalDate inicio, LocalDate fim, Vendedor vendedor) {
        List lista = vendedor == null ? this.pedidoItemRepository.lista(inicio, fim) : this.pedidoItemRepository.lista(inicio, fim, vendedor.getId());
        ArrayList<PedidoItemVendaExternaBean> retorno = new ArrayList<PedidoItemVendaExternaBean>();
        for (Object[] obj : lista) {
            PedidoItemVendaExternaBean bean = new PedidoItemVendaExternaBean();
            bean.setCodigo(String.valueOf(obj[0]));
            bean.setProduto(String.valueOf(obj[1]));
            bean.setQuantidade((BigDecimal)obj[2]);
            Double valorMedio = (Double)obj[3];
            bean.setValorMedio(BigDecimal.valueOf(valorMedio));
            bean.setValorTotal((BigDecimal)obj[4]);
            retorno.add(bean);
        }
        return retorno;
    }

    @Transactional(readOnly=true)
    public List<PedidoVendaExternaBean> lista(LocalDate inicio, LocalDate fim, Vendedor vendedor) {
        List lista = vendedor == null ? this.pedidoRepository.list(inicio, fim) : this.pedidoRepository.list(inicio, fim, vendedor.getId());
        ArrayList<PedidoVendaExternaBean> retorno = new ArrayList<PedidoVendaExternaBean>();
        for (PedidoVendaExterna pve : lista) {
            PedidoVendaExternaBean bean = new PedidoVendaExternaBean();
            bean.setCliente(pve.getCliente().getNome());
            bean.setDataVenda(pve.getDataPedido().format(DateTimeFormatter.ofPattern("dd/MM/yyyy")));
            bean.setValorTotal(pve.getTotal());
            bean.setVendedor(pve.getVendedor().getNome());
            bean.setCusto(pve.getTotalCusto());
            bean.setComissao(BigDecimal.ZERO);
            bean.setPagamentoId(pve.getPagamentoId());
            bean.setPagamentoDescricao(((CondicaoRecebimento)this.condicaoRecebimentoRepository.findById((Object)pve.getPagamentoId()).get()).getNome().toUpperCase());
            if (bean.getComissao().compareTo(BigDecimal.ZERO) < 0) {
                bean.setComissao(BigDecimal.ZERO);
            }
            List parcelas = this.contaReceberParcelaRepository.listPorContaReceber(pve.getVendaProduto().getContaReceber().getId().longValue());
            BigDecimal valorRecebido = BigDecimal.ZERO;
            for (ContaReceberParcela crp : parcelas) {
                valorRecebido = valorRecebido.add(crp.getValor().subtract(crp.getValorPendente()));
            }
            bean.setValorRecebido(valorRecebido);
            retorno.add(bean);
        }
        return retorno;
    }

    @Transactional(readOnly=true)
    public List<PedidoVendaExterna> lista(LocalDate inicio, LocalDate fim, Boolean confirmado, Boolean excluido, String filtro) {
        return this.pedidoRepository.pesquisa(inicio, fim, confirmado, excluido, filtro);
    }

    @Transactional(readOnly=true)
    public BigDecimal totalLista(LocalDate inicio, LocalDate fim, Boolean confirmado, Boolean excluido, String filtro) {
        BigDecimal total = this.pedidoRepository.totalPesquisa(inicio, fim, confirmado, excluido, filtro);
        if (total == null) {
            total = BigDecimal.ZERO;
        }
        return total;
    }

    private VendaProdutoFaturamento createFaturamento(CondicaoRecebimento condicaoRecebimento, VendaProduto vendaProduto) {
        VendaProdutoFaturamento faturamento = new VendaProdutoFaturamento();
        faturamento.setCondicaoRecebimento(condicaoRecebimento);
        faturamento.setDataEmissao(LocalDateTime.now());
        faturamento.setDataEntrada(LocalDate.now());
        faturamento.setHistorico("");
        faturamento.setValor(vendaProduto.getTotal());
        faturamento.setValorTroco(BigDecimal.ZERO);
        faturamento.setVendaProduto(vendaProduto);
        return faturamento;
    }

    private VendaProdutoItem createVendaProdutoItem(PedidoItemVendaExterna item, VendaProduto vendaProduto, int numItem) {
        VendaProdutoItem vendaProdutoItem = new VendaProdutoItem();
        vendaProdutoItem.setAtivo(Boolean.TRUE);
        vendaProdutoItem.setDataMovimento(LocalDateTime.now());
        vendaProdutoItem.setDesconto(item.getDesconto());
        vendaProdutoItem.setDescricao(item.getProduto().getNome());
        vendaProdutoItem.setNumItem(Integer.valueOf(numItem));
        vendaProdutoItem.setObservacao(item.getObservacao());
        if (item.getProduto().getServico().booleanValue()) {
            vendaProdutoItem.setPrecoCusto(BigDecimal.ZERO);
            vendaProdutoItem.setServicoCusto(item.getProduto().getUltimoCusto());
        } else {
            vendaProdutoItem.setPrecoCusto(item.getProduto().getUltimoCusto());
            vendaProdutoItem.setServicoCusto(BigDecimal.ZERO);
        }
        vendaProdutoItem.setPrecoTotal(item.getValorTotal());
        vendaProdutoItem.setPrecoUnitario(item.getValorUnitario());
        vendaProdutoItem.setProduto(item.getProduto());
        vendaProdutoItem.setQuantidade(item.getQuantidade());
        vendaProdutoItem.setUnidade(item.getProduto().getUnidade().getSigla());
        vendaProdutoItem.setVendaProduto(vendaProduto);
        return vendaProdutoItem;
    }

    private VendaProduto createVendaProduto(PedidoVendaExterna pedido, MovimentoCaixa movimentoCaixa, CondicaoRecebimento condicaoRecebimento) {
        VendaProduto vendaProduto = new VendaProduto();
        vendaProduto.setAcrescimo(BigDecimal.ZERO);
        vendaProduto.setAtivo(Boolean.TRUE);
        vendaProduto.setCliente(pedido.getCliente());
        vendaProduto.setDataEmissao(pedido.getDataPedido());
        vendaProduto.setDataFaturamento(pedido.getDataPedido());
        vendaProduto.setDataOperacao(LocalDateTime.now());
        vendaProduto.setDesconto(pedido.getDesconto());
        vendaProduto.setExcluida(Boolean.FALSE);
        vendaProduto.setFaturado(Boolean.FALSE);
        vendaProduto.setFinalizada(Boolean.TRUE);
        vendaProduto.setHora(MaximaDate.getHoraAtual());
        vendaProduto.setMovimentoCaixa(movimentoCaixa);
        vendaProduto.setObservacao(pedido.getObservacao());
        vendaProduto.setTipoEmissao(VendaProdutoTipoEmissao.EXTERNA);
        vendaProduto.setValorProdutos(pedido.getTotal());
        vendaProduto.setValorServico(BigDecimal.ZERO);
        vendaProduto.setValorPecas(pedido.getTotal());
        vendaProduto.setTotal(pedido.getTotal());
        vendaProduto.setTroco(BigDecimal.ZERO);
        vendaProduto.setValorProdutos(pedido.getTotal());
        vendaProduto.setVendedor(pedido.getVendedor());
        return vendaProduto;
    }
}

