/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.vendasexternas.service;

import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaWebAPI;
import br.com.maximasolutions.estoque.dto.CategoriaProdutoDto;
import br.com.maximasolutions.estoque.dto.ProdutoDto;
import br.com.maximasolutions.estoque.dto.UnidadeDto;
import br.com.maximasolutions.estoque.modelo.CategoriaProduto;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.modelo.Unidade;
import br.com.maximasolutions.estoque.repository.CategoriaProdutoRepository;
import br.com.maximasolutions.estoque.repository.ProdutoRepository;
import br.com.maximasolutions.estoque.repository.UnidadeRepository;
import br.com.maximasolutions.financeiro.dto.CondicaoRecebimentoDto;
import br.com.maximasolutions.financeiro.modelo.CondicaoRecebimento;
import br.com.maximasolutions.financeiro.repository.CondicaoRecebimentoRepository;
import br.com.maximasolutions.geral.dto.ClienteDto;
import br.com.maximasolutions.geral.dto.EstadoDto;
import br.com.maximasolutions.geral.dto.MunicipioDto;
import br.com.maximasolutions.geral.dto.VendedorDto;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.modelo.Estado;
import br.com.maximasolutions.geral.modelo.Municipio;
import br.com.maximasolutions.geral.modelo.Vendedor;
import br.com.maximasolutions.geral.repository.ClienteRepository;
import br.com.maximasolutions.geral.repository.EstadoRepository;
import br.com.maximasolutions.geral.repository.MunicipioRepository;
import br.com.maximasolutions.geral.repository.VendedorRepository;
import br.com.maximasolutions.serializer.LocalDateDeserializer;
import br.com.maximasolutions.serializer.LocalDateTimeDeserializer;
import br.com.maximasolutions.vendasexternas.converter.PedidoVendaExternaConverter;
import br.com.maximasolutions.vendasexternas.dto.PedidoVendaExternaConfirmaDto;
import br.com.maximasolutions.vendasexternas.dto.PedidoVendaExternaDto;
import br.com.maximasolutions.vendasexternas.dto.PedidoVendaExternaItemDto;
import br.com.maximasolutions.vendasexternas.dto.ServidorStatusDto;
import br.com.maximasolutions.vendasexternas.dto.VendedorProdutoDto;
import br.com.maximasolutions.vendasexternas.modelo.PedidoItemVendaExterna;
import br.com.maximasolutions.vendasexternas.modelo.PedidoVendaExterna;
import br.com.maximasolutions.vendasexternas.modelo.VendedorProduto;
import br.com.maximasolutions.vendasexternas.repository.PedidoItemVendaExternaRepository;
import br.com.maximasolutions.vendasexternas.repository.PedidoVendaExternaRepository;
import br.com.maximasolutions.vendasexternas.repository.VendedorProdutoRepository;
import br.com.maximasolutions.vendasexternas.service.SincronizacaoService;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={MaximaException.class})
public class SincronizacaoServiceImpl
implements SincronizacaoService {
    @Autowired
    private UnidadeRepository unidadeRepository;
    @Autowired
    private EstadoRepository estadoRepository;
    @Autowired
    private MunicipioRepository municipioRepository;
    @Autowired
    private CategoriaProdutoRepository categoriaProdutoRepository;
    @Autowired
    private VendedorRepository vendedorRepository;
    @Autowired
    private ProdutoRepository produtoRepository;
    @Autowired
    private VendedorProdutoRepository vendedorProdutoRepository;
    @Autowired
    private CondicaoRecebimentoRepository condicaoRecebimentoRepository;
    @Autowired
    private ClienteRepository clienteRepository;
    @Autowired
    private PedidoVendaExternaRepository pedidoVendaExternaRepository;
    @Autowired
    private PedidoItemVendaExternaRepository pedidoItemVendaExternaRepository;
    private static final String BASE_URI = MaximaConfig.getVendasExternasServidorUrl();

    public void sincroniza() throws MaximaException {
    }

    public Boolean getServidorOn() throws MaximaException {
        ServidorStatusDto statusDto;
        Response response;
        try {
            response = new MaximaWebAPI(BASE_URI).enviaSolicitacaoGet("api/status");
        }
        catch (IOException ex) {
            return false;
        }
        if (!response.isSuccessful()) {
            return false;
        }
        if (response.body() == null) {
            return false;
        }
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)new LocalDateDeserializer());
        gsonBuilder.registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeDeserializer());
        Gson gson = gsonBuilder.setPrettyPrinting().create();
        try {
            statusDto = (ServidorStatusDto)gson.fromJson(response.body().string(), ServidorStatusDto.class);
        }
        catch (IOException ex) {
            return false;
        }
        return statusDto.getSucesso();
    }

    public EstadoDto sincronizaEstado(Estado estado) throws MaximaException {
        if (estado.getUuid() == null || estado.getUuid().isEmpty()) {
            estado.setUuid(UUID.randomUUID().toString());
        }
        estado.setSincronizado(Boolean.valueOf(true));
        estado = (Estado)this.estadoRepository.save((Object)estado);
        return (EstadoDto)new MaximaWebAPI(BASE_URI).enviaSincronizacaoApi((Object)estado, "api/estados/sincroniza", EstadoDto.class);
    }

    public MunicipioDto sincronizaMunicipio(Municipio municipio) throws MaximaException {
        if (municipio.getUuid() == null || municipio.getUuid().isEmpty()) {
            municipio.setUuid(UUID.randomUUID().toString());
        }
        municipio.setSincronizado(Boolean.valueOf(true));
        municipio = (Municipio)this.municipioRepository.save((Object)municipio);
        return (MunicipioDto)new MaximaWebAPI(BASE_URI).enviaSincronizacaoApi((Object)municipio, "api/municipios/sincroniza", MunicipioDto.class);
    }

    public UnidadeDto sincronizaUnidade(Unidade unidade) throws MaximaException {
        if (unidade.getUuid() == null || unidade.getUuid().isEmpty()) {
            unidade.setUuid(UUID.randomUUID().toString());
        }
        unidade.setSincronizado(Boolean.valueOf(true));
        unidade = (Unidade)this.unidadeRepository.save((Object)unidade);
        return (UnidadeDto)new MaximaWebAPI(BASE_URI).enviaSincronizacaoApi((Object)unidade, "api/unidades/sincroniza", UnidadeDto.class);
    }

    public CategoriaProdutoDto sincronizaCategoriaProduto(CategoriaProduto categoriaProduto) throws MaximaException {
        if (categoriaProduto.getUuid() == null || categoriaProduto.getUuid().isEmpty()) {
            categoriaProduto.setUuid(UUID.randomUUID().toString());
        }
        categoriaProduto.setSincronizado(Boolean.valueOf(true));
        categoriaProduto = (CategoriaProduto)this.categoriaProdutoRepository.save((Object)categoriaProduto);
        return (CategoriaProdutoDto)new MaximaWebAPI(BASE_URI).enviaSincronizacaoApi((Object)categoriaProduto, "api/categorias-produtos/sincroniza", CategoriaProdutoDto.class);
    }

    public ProdutoDto sincronizaProduto(Produto produto) throws MaximaException {
        if (produto.getUuid() == null || produto.getUuid().isEmpty()) {
            produto.setUuid(UUID.randomUUID().toString());
        }
        produto.setSincronizado(Boolean.valueOf(true));
        produto = (Produto)this.produtoRepository.save((Object)produto);
        return (ProdutoDto)new MaximaWebAPI(BASE_URI).enviaSincronizacaoApi((Object)produto, "api/produtos/sincroniza", ProdutoDto.class);
    }

    public VendedorDto sincronizaVendedor(Vendedor vendedor) throws MaximaException {
        if (vendedor.getUuid() == null || vendedor.getUuid().isEmpty()) {
            vendedor.setUuid(UUID.randomUUID().toString());
        }
        vendedor.setSincronizado(Boolean.valueOf(true));
        vendedor = (Vendedor)this.vendedorRepository.save((Object)vendedor);
        return (VendedorDto)new MaximaWebAPI(BASE_URI).enviaSincronizacaoApi((Object)vendedor, "api/vendedor/sincroniza", VendedorDto.class);
    }

    public ClienteDto sincronizaCliente(Cliente cliente) throws MaximaException {
        if (cliente.getUuid() == null || cliente.getUuid().isEmpty()) {
            cliente.setUuid(UUID.randomUUID().toString());
        }
        cliente.setSincronizado(Boolean.valueOf(true));
        cliente = (Cliente)this.clienteRepository.save((Object)cliente);
        return (ClienteDto)new MaximaWebAPI(BASE_URI).enviaSincronizacaoApi((Object)cliente, "api/clientes/sincroniza", ClienteDto.class);
    }

    public VendedorProdutoDto sincronizaVendedorProduto(Long vendedorId, Long produtoId) throws MaximaException {
        Produto produto = (Produto)this.produtoRepository.findById((Object)produtoId).get();
        Vendedor vendedor = (Vendedor)this.vendedorRepository.findById((Object)vendedorId).get();
        VendedorProduto vendedorProduto = this.vendedorProdutoRepository.get(vendedor.getId(), produto.getId());
        if (vendedorProduto == null) {
            vendedorProduto = new VendedorProduto();
        }
        if (vendedorProduto.getUuid() == null || vendedorProduto.getUuid().isEmpty()) {
            vendedorProduto.setUuid(UUID.randomUUID().toString());
        }
        vendedorProduto.setCategoria(produto.getCategoria());
        vendedorProduto.setCodigo(produto.getCodigo());
        vendedorProduto.setDescontoPermitido(BigDecimal.ZERO);
        vendedorProduto.setDescricao(produto.getNome().toUpperCase());
        vendedorProduto.setEstoqueAtual(produto.getEstoqueAtual());
        vendedorProduto.setEstoqueEmpresa(produto.getEstoqueAtual());
        vendedorProduto.setEstoqueMinimo(BigDecimal.ZERO);
        vendedorProduto.setPrecoCusto(BigDecimal.ZERO);
        vendedorProduto.setPrecoVenda(produto.getPrecoVenda());
        vendedorProduto.setProduto(produto);
        vendedorProduto.setProntaEntrega(Boolean.FALSE);
        vendedorProduto.setSincronizado(Boolean.TRUE);
        vendedorProduto.setUltimaAlteracao(LocalDateTime.now());
        vendedorProduto.setUnidade(produto.getUnidade().getSigla().toUpperCase());
        vendedorProduto.setVendedor(vendedor);
        vendedorProduto = (VendedorProduto)this.vendedorProdutoRepository.save((Object)vendedorProduto);
        return (VendedorProdutoDto)new MaximaWebAPI(BASE_URI).enviaSincronizacaoApi((Object)vendedorProduto, "api/vendedor-produto/sincroniza", VendedorProdutoDto.class);
    }

    public VendedorProdutoDto sincronizaVendedorProduto(VendedorProduto vendedorProduto) throws MaximaException {
        if ((vendedorProduto = (VendedorProduto)this.vendedorProdutoRepository.findById((Object)vendedorProduto.getId()).get()).getUuid() == null || vendedorProduto.getUuid().isEmpty()) {
            vendedorProduto.setUuid(UUID.randomUUID().toString());
        }
        vendedorProduto.setSincronizado(Boolean.TRUE);
        vendedorProduto = (VendedorProduto)this.vendedorProdutoRepository.save((Object)vendedorProduto);
        return (VendedorProdutoDto)new MaximaWebAPI(BASE_URI).enviaSincronizacaoApi((Object)vendedorProduto, "api/vendedor-produto/sincroniza", VendedorProdutoDto.class);
    }

    public CondicaoRecebimentoDto sincronizaCondicaoRecebimento(CondicaoRecebimento condicaoRecebimento) throws MaximaException {
        if (condicaoRecebimento.getUuid() == null || condicaoRecebimento.getUuid().isEmpty()) {
            condicaoRecebimento.setUuid(UUID.randomUUID().toString());
        }
        condicaoRecebimento.setSincronizado(Boolean.valueOf(true));
        condicaoRecebimento = (CondicaoRecebimento)this.condicaoRecebimentoRepository.save((Object)condicaoRecebimento);
        return (CondicaoRecebimentoDto)new MaximaWebAPI(BASE_URI).enviaSincronizacaoApi((Object)condicaoRecebimento, "api/condicao-recebimento/sincroniza", CondicaoRecebimentoDto.class);
    }

    public List<PedidoVendaExternaDto> listaPedidosEmAberto() throws MaximaException {
        PedidoVendaExternaDto[] pedidos;
        Response response;
        try {
            response = new MaximaWebAPI(BASE_URI).enviaSolicitacaoGet("api/pedidos");
        }
        catch (IOException ex) {
            throw new MaximaException("AVISO: Falha na comunica\u00e7\u00e3o com o servidor.");
        }
        if (!response.isSuccessful()) {
            throw new MaximaException("AVISO: Falha na comunica\u00e7\u00e3o com o servidor.");
        }
        if (response.body() == null) {
            return new ArrayList<PedidoVendaExternaDto>();
        }
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)new LocalDateDeserializer());
        gsonBuilder.registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeDeserializer());
        Gson gson = gsonBuilder.setPrettyPrinting().create();
        try {
            pedidos = (PedidoVendaExternaDto[])gson.fromJson(response.body().string(), PedidoVendaExternaDto[].class);
        }
        catch (IOException ex) {
            Logger.getLogger(SincronizacaoServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException("ERRO: N\u00e3o foi poss\u00edvel recuperar os pedidos. (Falha na convers\u00e3o para JSON).");
        }
        ArrayList<PedidoVendaExternaDto> retorno = new ArrayList<PedidoVendaExternaDto>();
        retorno.addAll(Arrays.asList(pedidos));
        return retorno;
    }

    public void sincronizaPedidos(PedidoVendaExternaDto pedidoDto) throws MaximaException {
        PedidoVendaExterna pedido = this.pedidoVendaExternaRepository.get(pedidoDto.getUuid());
        if (pedido != null) {
            throw new MaximaException("PEDIDO J\u00c1 CADASTRADO.");
        }
        Vendedor vendedor = this.vendedorRepository.get(pedidoDto.getVendedor().getUuid());
        if (vendedor == null || !vendedor.getAtivo().booleanValue()) {
            throw new MaximaException("VENDEDOR N\u00c3O CADASTRADO");
        }
        Cliente cliente = this.clienteRepository.get(pedidoDto.getCliente().getUuid());
        System.out.println("UUID Cliente: " + pedidoDto.getCliente().getUuid());
        if (cliente == null) {
            List clientePorCpf = this.clienteRepository.listaPorCpf(pedidoDto.getCliente().getCpf());
            if (clientePorCpf.isEmpty()) {
                Municipio municipio1 = this.municipioRepository.get(pedidoDto.getCliente().getMunicipio().getUuid());
                cliente = (Cliente)this.clienteRepository.save((Object)pedidoDto.getCliente().converter(municipio1, vendedor));
            } else {
                if (clientePorCpf.size() > 1) {
                    throw new MaximaException("AVISO: Mais de um cliente com o mesmo CPF/CNPJ.");
                }
                Cliente clienteExistente = (Cliente)clientePorCpf.get(0);
                if (clienteExistente.getVendedor() != null && !clienteExistente.getVendedor().getId().equals(vendedor.getId())) {
                    throw new MaximaException("AVISO: Cliente vinculado a outro vendedor.");
                }
                cliente = clienteExistente;
                cliente.setVendedor(vendedor);
                cliente = (Cliente)this.clienteRepository.save((Object)cliente);
            }
        }
        PedidoVendaExternaConverter converter = new PedidoVendaExternaConverter();
        pedido = converter.converter(pedidoDto, cliente, vendedor);
        pedido = (PedidoVendaExterna)this.pedidoVendaExternaRepository.save((Object)pedido);
        for (PedidoVendaExternaItemDto itemDto : pedidoDto.getItens()) {
            PedidoItemVendaExterna item = converter.converter(itemDto, pedido, this.produtoRepository);
            this.pedidoItemVendaExternaRepository.save((Object)item);
        }
        pedidoDto = (PedidoVendaExternaDto)new MaximaWebAPI(BASE_URI).enviaSincronizacaoApi((Object)new PedidoVendaExternaConfirmaDto(pedido.getUuid()), "api/pedidos/recebido", PedidoVendaExternaDto.class);
    }
}

