/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.vendasexternas.service;

import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.modelo.ProdutoExtrato;
import br.com.maximasolutions.estoque.modelo.ProdutoExtratoTipo;
import br.com.maximasolutions.estoque.repository.ProdutoExtratoRepository;
import br.com.maximasolutions.estoque.repository.ProdutoRepository;
import br.com.maximasolutions.vendasexternas.modelo.VendedorProduto;
import br.com.maximasolutions.vendasexternas.modelo.VendedorProdutoExtrato;
import br.com.maximasolutions.vendasexternas.modelo.VendedorProdutoExtratoTipo;
import br.com.maximasolutions.vendasexternas.modelo.VendedorProdutoLancamento;
import br.com.maximasolutions.vendasexternas.modelo.VendedorProdutoLancamentoItem;
import br.com.maximasolutions.vendasexternas.repository.VendedorProdutoExtratoRepository;
import br.com.maximasolutions.vendasexternas.repository.VendedorProdutoLancamentoItemRepository;
import br.com.maximasolutions.vendasexternas.repository.VendedorProdutoLancamentoRepository;
import br.com.maximasolutions.vendasexternas.repository.VendedorProdutoRepository;
import br.com.maximasolutions.vendasexternas.service.VendedorProdutoLancamentoService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class VendedorProdutoLancamentoServiceImpl
implements VendedorProdutoLancamentoService {
    @Autowired
    private VendedorProdutoLancamentoRepository vendedorProdutoLancamentoRepository;
    @Autowired
    private VendedorProdutoLancamentoItemRepository itemRepository;
    @Autowired
    private VendedorProdutoRepository vendedorProdutoRepository;
    @Autowired
    private ProdutoRepository produtoRepository;
    @Autowired
    private ProdutoExtratoRepository produtoExtratoRepository;
    @Autowired
    private VendedorProdutoExtratoRepository vendedorProdutoExtratoRepository;

    @Transactional(readOnly=true)
    public List<VendedorProdutoLancamento> list() {
        return this.vendedorProdutoLancamentoRepository.list();
    }

    public VendedorProdutoLancamento salva(VendedorProdutoLancamento lancamento, List<VendedorProdutoLancamentoItem> itens) {
        lancamento = (VendedorProdutoLancamento)this.vendedorProdutoLancamentoRepository.save((Object)lancamento);
        BigDecimal total = BigDecimal.ZERO;
        for (VendedorProdutoLancamentoItem item : itens) {
            item.setLancamento(lancamento);
            item = (VendedorProdutoLancamentoItem)this.itemRepository.save((Object)item);
            total = total.add(item.getPrecoTotal());
            BigDecimal estoqueVendedor = BigDecimal.ZERO;
            VendedorProduto vendedorProduto = this.vendedorProdutoRepository.get(lancamento.getVendedor().getId(), item.getProduto().getId());
            if (vendedorProduto == null) {
                vendedorProduto = new VendedorProduto();
                vendedorProduto.setEstoqueAtual(item.getQuantidade());
            } else {
                estoqueVendedor = vendedorProduto.getEstoqueAtual();
                vendedorProduto.setEstoqueAtual(vendedorProduto.getEstoqueAtual().add(item.getQuantidade()));
            }
            vendedorProduto.setCategoria(item.getProduto().getCategoriaProduto().getNome());
            vendedorProduto.setDescontoPermitido(item.getProduto().getDescontoPermitido());
            vendedorProduto.setDescricao(item.getProdutoDescricao());
            vendedorProduto.setEstoqueMinimo(BigDecimal.ZERO);
            vendedorProduto.setProduto(item.getProduto());
            vendedorProduto.setUnidade(item.getProduto().getUnidade().getSigla());
            vendedorProduto.setCodigo(item.getProduto().getCodigo());
            vendedorProduto.setVendedor(lancamento.getVendedor());
            vendedorProduto.setPrecoCusto(item.getPrecoUnitario());
            vendedorProduto.setPrecoVenda(item.getPrecoSugerido());
            vendedorProduto.setUltimaAlteracao(LocalDateTime.now());
            vendedorProduto.setSincronizado(Boolean.valueOf(false));
            vendedorProduto = (VendedorProduto)this.vendedorProdutoRepository.save((Object)vendedorProduto);
            Produto produto = this.produtoRepository.getByCodigoBarras(item.getProduto().getCodigo());
            BigDecimal estoqueAnterior = produto.getEstoqueAtual();
            produto.setEstoqueAtual(produto.getEstoqueAtual().subtract(item.getQuantidade()));
            produto = (Produto)this.produtoRepository.save((Object)produto);
            ProdutoExtrato extrato = new ProdutoExtrato(produto, LocalDate.now(), "VPL" + vendedorProduto.getId(), item.getQuantidade().multiply(new BigDecimal("-1")), "ADD", estoqueAnterior, produto.getEstoqueAtual(), ProdutoExtratoTipo.VENDEDOR);
            this.produtoExtratoRepository.save((Object)extrato);
            VendedorProdutoExtrato vendedorProdutoExtrato = new VendedorProdutoExtrato(lancamento.getVendedor(), produto, LocalDate.now(), VendedorProdutoExtratoTipo.LANCAMENTO, item.getQuantidade(), "LAN\u00c7AMENTO", estoqueVendedor, vendedorProduto.getEstoqueAtual());
            this.vendedorProdutoExtratoRepository.save((Object)vendedorProdutoExtrato);
        }
        lancamento.setValorTotal(total);
        lancamento = (VendedorProdutoLancamento)this.vendedorProdutoLancamentoRepository.save((Object)lancamento);
        return lancamento;
    }

    public void delete(VendedorProdutoLancamento lancamento) {
        List itens = this.itemRepository.list(lancamento.getId());
        for (VendedorProdutoLancamentoItem item : itens) {
            item.setExcluido(Boolean.TRUE);
            item = (VendedorProdutoLancamentoItem)this.itemRepository.save((Object)item);
            VendedorProduto vendedorProduto = this.vendedorProdutoRepository.get(lancamento.getVendedor().getId(), item.getProduto().getId());
            BigDecimal estoqueVendedor = vendedorProduto.getEstoqueAtual();
            vendedorProduto.setEstoqueAtual(vendedorProduto.getEstoqueAtual().subtract(item.getQuantidade()));
            vendedorProduto.setUltimaAlteracao(LocalDateTime.now());
            vendedorProduto.setSincronizado(Boolean.valueOf(false));
            this.vendedorProdutoRepository.save((Object)vendedorProduto);
            Produto produto = this.produtoRepository.getByCodigoBarras(item.getProdutoCodigo());
            BigDecimal estoqueAnterior = produto.getEstoqueAtual();
            produto.setEstoqueAtual(produto.getEstoqueAtual().add(item.getQuantidade()));
            produto = (Produto)this.produtoRepository.save((Object)produto);
            ProdutoExtrato extrato = new ProdutoExtrato(produto, LocalDate.now(), "VPLD" + vendedorProduto.getId(), item.getQuantidade(), "DEL", estoqueAnterior, produto.getEstoqueAtual(), ProdutoExtratoTipo.VENDEDOR);
            this.produtoExtratoRepository.save((Object)extrato);
            VendedorProdutoExtrato vendedorProdutoExtrato = new VendedorProdutoExtrato(lancamento.getVendedor(), produto, LocalDate.now(), VendedorProdutoExtratoTipo.LANCAMENTO_DELETE, item.getQuantidade().multiply(new BigDecimal("-1")), "DELETE LAN\u00c7AMENTO", estoqueVendedor, vendedorProduto.getEstoqueAtual());
            this.vendedorProdutoExtratoRepository.save((Object)vendedorProdutoExtrato);
        }
        lancamento.setExcluido(Boolean.TRUE);
        this.vendedorProdutoLancamentoRepository.save((Object)lancamento);
    }
}

