/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.boleto.bancos;

import br.com.caelum.stella.boleto.Beneficiario;
import br.com.caelum.stella.boleto.Boleto;
import br.com.caelum.stella.boleto.bancos.AbstractBanco;
import br.com.caelum.stella.boleto.bancos.CodigoDeBarrasBuilder;
import br.com.caelum.stella.boleto.bancos.gerador.GeradorDeDigitoSantander;
import br.com.caelum.stella.boleto.utils.StellaStringUtils;
import java.net.URL;

public class Santander
extends AbstractBanco {
    private static final long serialVersionUID = 1L;
    private static final String NUMERO_SANTANDER = "033";
    private static final String DIGITO_SANTANDER = "7";
    private GeradorDeDigitoSantander gdivSantander = new GeradorDeDigitoSantander();

    public String geraCodigoDeBarrasPara(Boleto boleto) {
        Beneficiario beneficiario = boleto.getBeneficiario();
        StringBuilder campoLivre = new StringBuilder("9");
        campoLivre.append(this.getNumeroConvenioFormatado(beneficiario));
        campoLivre.append(this.getNossoNumeroFormatado(beneficiario));
        campoLivre.append("0").append(beneficiario.getCarteira());
        return new CodigoDeBarrasBuilder(boleto).comCampoLivre(campoLivre);
    }

    public URL getImage() {
        String pathDoArquivo = "/br/com/caelum/stella/boleto/img/%s.png";
        String imagem = String.format(pathDoArquivo, NUMERO_SANTANDER);
        return this.getClass().getResource(imagem);
    }

    public String getNumeroFormatado() {
        return NUMERO_SANTANDER;
    }

    public String getCarteiraFormatado(Beneficiario beneficiario) {
        return StellaStringUtils.leftPadWithZeros((String)beneficiario.getCarteira(), (int)3);
    }

    public String getCodigoBeneficiarioFormatado(Beneficiario beneficiario) {
        return StellaStringUtils.leftPadWithZeros((String)beneficiario.getCodigoBeneficiario(), (int)7);
    }

    public String getNossoNumeroFormatado(Beneficiario beneficiario) {
        String nossoNumero = beneficiario.getNossoNumero();
        if (beneficiario.getDigitoNossoNumero() != null) {
            return StellaStringUtils.leftPadWithZeros((String)(nossoNumero + beneficiario.getDigitoNossoNumero()), (int)13);
        }
        return StellaStringUtils.leftPadWithZeros((String)(nossoNumero + this.getGeradorDeDigito().calculaDVNossoNumero(nossoNumero)), (int)13);
    }

    public String getNumeroFormatadoComDigito() {
        StringBuilder builder = new StringBuilder();
        builder.append(NUMERO_SANTANDER).append("-");
        return builder.append(DIGITO_SANTANDER).toString();
    }

    public String getNossoNumeroECodigoDocumento(Boleto boleto) {
        Beneficiario beneficiario = boleto.getBeneficiario();
        String nossoNumero = this.getNossoNumeroFormatado(beneficiario);
        StringBuilder builder = new StringBuilder();
        builder.append(nossoNumero, 0, 12);
        builder.append("-").append(nossoNumero.substring(12));
        return builder.toString();
    }

    public GeradorDeDigitoSantander getGeradorDeDigito() {
        return this.gdivSantander;
    }

    public String getNumeroConvenioFormatado(Beneficiario beneficiario) {
        return StellaStringUtils.leftPadWithZeros((String)beneficiario.getNumeroConvenio(), (int)7);
    }
}

