/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.administrativo.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.administrativo.service.EmpresaService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.ImpressoraModelo;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.core.ProdutoEtiquetaModelo;
import br.com.maximasolutions.estoque.modelo.VendaProdutoComprovanteA4Tipo;
import br.com.maximasolutions.estoque.modelo.VendaProdutoComprovanteTipo;
import br.com.maximasolutions.financeiro.modelo.BancoBoleto;
import br.com.maximasolutions.financeiro.modelo.CentroCusto;
import br.com.maximasolutions.financeiro.service.BancoBoletoService;
import br.com.maximasolutions.financeiro.service.CentroCustoService;
import br.com.maximasolutions.fiscal.modelo.Contador;
import br.com.maximasolutions.fiscal.service.ContadorService;
import br.com.maximasolutions.food.modelo.DepartamentoImpressora;
import br.com.maximasolutions.food.modelo.TipoPrecoPizza;
import br.com.maximasolutions.food.service.DepartamentoImpressoraService;
import br.com.maximasolutions.geral.form.ClientePesquisaForm;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.modelo.Empresa;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class ConfiguracaoFormController
extends MaximaController
implements Initializable {
    @FXML
    private TextField tfId;
    @FXML
    private TextField tfEmpresa;
    @FXML
    private TextField tfNomeFantasia;
    @FXML
    private TextField tfSatCnpjSoftwareHouse;
    @FXML
    private TextField tfSatCodigoAtivacao;
    @FXML
    private TextField tfSatPathXml;
    @FXML
    private TextField tfNfeEntradaXml;
    @FXML
    private TextField tfTelefone;
    @FXML
    private TextField tfCnpj;
    @FXML
    private TextField tfClientePadrao;
    @FXML
    private TextField tfDescontoPermitido;
    @FXML
    private TextField tfProdutoDiretorioFoto;
    @FXML
    private TextField tfImpressoraPorta;
    @FXML
    private TextField tfNfeDiretorio;
    @FXML
    private TextField tfNfeNaturezaOperacao;
    @FXML
    private TextField tfMensagemComanda;
    @FXML
    private TextField tfEtiquetaParcelas;
    @FXML
    private TextArea tfNfeInfAddCont;
    @FXML
    private CheckBox ccbDeliveryTaxaEntrega;
    @FXML
    private CheckBox ccbBloquearPrecoVenda;
    @FXML
    private CheckBox ccbEntradaProdutoCaixa;
    @FXML
    private CheckBox ccbEntradaValores;
    @FXML
    private CheckBox ccbProdutoAlteraPrecoVenda;
    @FXML
    private CheckBox ccbComandaOcupada;
    @FXML
    private CheckBox ccbComandaImpressa;
    @FXML
    private CheckBox ccbComandaExigeAutorizacao;
    @FXML
    private CheckBox ccbProdutoFiscal;
    @FXML
    private CheckBox cbbDeliveryImprimirCaixa;
    @FXML
    private CheckBox ccbNfeIbpt;
    @FXML
    private CheckBox ccbMovimentoCaixaImprimeProdutos;
    @FXML
    private CheckBox ccbMovimentoCaixaImprimeVendas;
    @FXML
    private CheckBox ccbMovimentoCaixaImprimeOutrosRecebimentos;
    @FXML
    private CheckBox ccbVendaPermiteEstoqueNegativo;
    @FXML
    private CheckBox cbbFixarDataRecebimento;
    @FXML
    private CheckBox ccbProdutosEstoquePositivo;
    @FXML
    private CheckBox ccbImprimirIndividual;
    @FXML
    private CheckBox ccbMotivoCancelamento;
    @FXML
    private CheckBox ccbImprimirComanda;
    @FXML
    private CheckBox ccbAgruparImpressao;
    @FXML
    private CheckBox ccbFixarMargem;
    @FXML
    private ComboBox<CentroCusto> cbbCentroCustoVenda;
    @FXML
    private ComboBox<BancoBoleto> cbbFinanceiroBancoBoleto;
    @FXML
    private ComboBox<Contador> cbbContador;
    @FXML
    private ComboBox<ImpressoraModelo> cbbImpressaoImpressora;
    @FXML
    private ComboBox<ProdutoEtiquetaModelo> cbbProdutoEtiquetaModelo;
    @FXML
    private ComboBox<String> cbbImpressoraEtiqueta;
    @FXML
    private ComboBox<String> cbbImpressoraCaixaSpooler;
    @FXML
    private ComboBox<DepartamentoImpressora> cbbComandaImpressoraTransferencia;
    @FXML
    private ComboBox<VendaProdutoComprovanteTipo> cbbVendaProdutoComprovante;
    @FXML
    private ComboBox<VendaProdutoComprovanteA4Tipo> cbbVendaProdutoComprovanteA4;
    @FXML
    private ComboBox<TipoPrecoPizza> cbbTipoPrecoPizza;
    @FXML
    private TextArea tfSatAssinatura;
    @FXML
    private TextArea txtVendaProdutoComprovanteReciboEntrega;
    @FXML
    private Button btnSalva;
    @FXML
    private Button btnClientePesquisa;
    @FXML
    private TextField tfEmailHost;
    @FXML
    private TextField tfEmailPorta;
    @FXML
    private TextField tfEmail;
    @FXML
    private PasswordField tfEmailSenha;
    @FXML
    private PasswordField tfCancelamentoSenha;
    @FXML
    private PasswordField tfSenhaFechamentoCaixa;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private BancoBoletoService bancoBoletoService;
    @Autowired
    private CentroCustoService centroCustoService;
    @Autowired
    private ContadorService contadorService;
    @Autowired
    private EmpresaService empresaService;
    @Autowired
    private DepartamentoImpressoraService departamentoImpressoraService;
    private Configuracao conf;
    private Cliente cliente;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.loadCombos();
        this.setMascaras();
        this.registraAcoes();
        this.loadConfiguracao();
    }

    private void loadConfiguracao() {
        this.conf = this.configuracaoService.load();
        Empresa empresa = this.empresaService.load();
        String empresaDescricao = "NENHUMA EMPRESA CADASTRADA";
        if (empresa != null) {
            empresaDescricao = empresa.getNome().toUpperCase();
        }
        this.tfEmpresa.setText(empresaDescricao);
        if (this.conf != null) {
            this.tfId.setText(this.conf.getId().toString());
            this.tfNomeFantasia.setText(this.conf.getNomeEmpresa());
            this.tfTelefone.setText(this.conf.getTelefoneEmpresa());
            this.tfCnpj.setText(this.conf.getCnpjEmpresa());
            this.cliente = this.conf.getCliente();
            if (this.cliente != null) {
                this.tfClientePadrao.setText(this.cliente.getNome().toUpperCase());
            }
            this.cbbCentroCustoVenda.getSelectionModel().select((Object)this.conf.getCentroCusto());
            this.ccbBloquearPrecoVenda.setSelected(this.conf.getBloqueaPrecoVenda().booleanValue());
            this.tfDescontoPermitido.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.conf.getDescontoAtualPermitido(), (int)2));
            this.ccbVendaPermiteEstoqueNegativo.setSelected(this.conf.getPermiteEstoqueNegativo().booleanValue());
            this.tfProdutoDiretorioFoto.setText(this.conf.getProdutoDiretorioFoto());
            this.ccbProdutoAlteraPrecoVenda.setSelected(this.conf.getAlteraPrecoVenda().booleanValue());
            this.ccbProdutoFiscal.setSelected(this.conf.getProdutoFiscal().booleanValue());
            this.ccbProdutosEstoquePositivo.setSelected(this.conf.getExibirEstoquePositivo().booleanValue());
            this.cbbImpressaoImpressora.getSelectionModel().select((Object)this.conf.getImpressoraModeloConfig());
            this.tfImpressoraPorta.setText(this.conf.getImpressoraPorta());
            this.cbbProdutoEtiquetaModelo.getSelectionModel().select((Object)this.conf.getProdutoEtiquetaModelo());
            this.cbbImpressoraEtiqueta.getSelectionModel().select((Object)this.conf.getImpressoraEtiqueta());
            this.cbbImpressoraCaixaSpooler.getSelectionModel().select((Object)this.conf.getImpressoraCaixaSpooler());
            this.cbbVendaProdutoComprovante.getSelectionModel().select((Object)this.conf.getVendaProdutoComprovanteTipo());
            this.cbbVendaProdutoComprovanteA4.getSelectionModel().select((Object)this.conf.getVendaProdutoComprovanteA4Tipo());
            this.txtVendaProdutoComprovanteReciboEntrega.setText(this.conf.getVendaProdutoComprovanteReciboEntrega());
            this.cbbFinanceiroBancoBoleto.getSelectionModel().select((Object)this.conf.getBancoBoleto());
            this.cbbFixarDataRecebimento.setSelected(this.conf.getFixarDataRecebimento().booleanValue());
            this.tfNfeEntradaXml.setText(this.conf.getCaminhoNFeEntrada());
            this.ccbEntradaProdutoCaixa.setSelected(this.conf.getEntradaProdutoCaixa().booleanValue());
            this.ccbEntradaValores.setSelected(this.conf.getEntradaAlteraValores().booleanValue());
            this.ccbFixarMargem.setSelected(this.conf.getFixarMargemProduto().booleanValue());
            this.tfSatCnpjSoftwareHouse.setText(this.conf.getSatCnpjSoftwareHouse());
            this.tfSatCodigoAtivacao.setText(this.conf.getSatSenha());
            this.tfSatPathXml.setText(this.conf.getCaminhoSAT());
            this.tfSatAssinatura.setText(this.conf.getSatChaveAssinada());
            this.cbbContador.getSelectionModel().select((Object)this.conf.getContador());
            this.tfNfeDiretorio.setText(this.conf.getCaminhoNFe());
            this.tfNfeNaturezaOperacao.setText(this.conf.getNfeNaturezaOperacao());
            this.tfNfeInfAddCont.setText(this.conf.getInfContNfe());
            this.ccbNfeIbpt.setSelected(this.conf.getExibirImpostoIBPT().booleanValue());
            this.tfEmailHost.setText(this.conf.getEmailHost());
            this.tfEmailPorta.setText(this.conf.getEmailPorta());
            this.tfEmail.setText(this.conf.getEmail());
            this.tfEmailSenha.setText(this.conf.getEmailSenha());
            this.ccbComandaOcupada.setSelected(this.conf.getComandaExibirOcupadas().booleanValue());
            this.ccbComandaImpressa.setSelected(this.conf.getComandaFechamentoImpresso().booleanValue());
            this.cbbComandaImpressoraTransferencia.getSelectionModel().select((Object)this.conf.getComandaImpressoraTransferencia());
            this.ccbComandaExigeAutorizacao.setSelected(this.conf.getFoodExigirAutorizacao().booleanValue());
            this.cbbDeliveryImprimirCaixa.setSelected(this.conf.getDeliveryImprimirCaixa().booleanValue());
            this.cbbTipoPrecoPizza.getSelectionModel().select((Object)this.conf.getTipoPrecoPizza());
            this.ccbImprimirIndividual.setSelected(this.conf.getImprimirItemIndividual().booleanValue());
            this.tfMensagemComanda.setText(this.conf.getMensagemComandaIndividual());
            this.ccbMovimentoCaixaImprimeProdutos.setSelected(this.conf.getMovimentoCaixaImprimeProdutos().booleanValue());
            this.ccbMovimentoCaixaImprimeVendas.setSelected(this.conf.getMovimentoCaixaImprimeVendas().booleanValue());
            this.ccbMovimentoCaixaImprimeOutrosRecebimentos.setSelected(this.conf.getMovimentoCaixaImprimeOutrosRecebimentos().booleanValue());
            this.tfSenhaFechamentoCaixa.setText(this.conf.getSenhaFechamentoCaixa());
            this.tfCancelamentoSenha.setText(this.conf.getCancelamentoSenha());
            this.ccbMotivoCancelamento.setSelected(this.conf.getExigirMotivoCancelamento().booleanValue());
            this.ccbImprimirComanda.setSelected(this.conf.getImprimirComanda().booleanValue());
            this.ccbAgruparImpressao.setSelected(this.conf.getAgruparItensImpressao().booleanValue());
            this.tfEtiquetaParcelas.setText(MaximaNumber.quantidadeToString((BigDecimal)this.conf.getEtiquetaParcelas()));
        } else {
            this.conf = new Configuracao();
        }
    }

    private void save() {
        Empresa empresa = this.empresaService.load();
        this.conf.setEmpresaNFe(empresa);
        this.conf.setNomeEmpresa(MaximaUtils.getText((String)this.tfNomeFantasia.getText()));
        this.conf.setTelefoneEmpresa(this.tfTelefone.getText());
        this.conf.setCnpjEmpresa(this.tfCnpj.getText());
        this.conf.setCliente(this.cliente);
        this.conf.setCentroCusto((CentroCusto)this.cbbCentroCustoVenda.getSelectionModel().getSelectedItem());
        this.conf.setBloqueaPrecoVenda(Boolean.valueOf(this.ccbBloquearPrecoVenda.isSelected()));
        this.conf.setPermiteEstoqueNegativo(Boolean.valueOf(this.ccbVendaPermiteEstoqueNegativo.isSelected()));
        this.conf.setDescontoAtualPermitido(MaximaNumber.moneyToBigDecimal((String)this.tfDescontoPermitido.getText()));
        String produtoDiretorioFoto = MaximaUtils.getText((String)this.tfProdutoDiretorioFoto.getText());
        if (produtoDiretorioFoto != null && !produtoDiretorioFoto.isEmpty()) {
            if (!(produtoDiretorioFoto = produtoDiretorioFoto.replace("\\", "/")).endsWith("/")) {
                produtoDiretorioFoto = produtoDiretorioFoto + "/";
            }
        } else {
            produtoDiretorioFoto = "C:/Maxima/Fotos/";
        }
        this.conf.setProdutoDiretorioFoto(produtoDiretorioFoto);
        this.conf.setAlteraPrecoVenda(Boolean.valueOf(this.ccbProdutoAlteraPrecoVenda.isSelected()));
        this.conf.setProdutoFiscal(Boolean.valueOf(this.ccbProdutoFiscal.isSelected()));
        this.conf.setExibirEstoquePositivo(Boolean.valueOf(this.ccbProdutosEstoquePositivo.isSelected()));
        this.conf.setImpressoraModelo((ImpressoraModelo)this.cbbImpressaoImpressora.getSelectionModel().getSelectedItem());
        this.conf.setImpressoraPorta(MaximaUtils.getText((String)this.tfImpressoraPorta.getText()));
        this.conf.setProdutoEtiquetaModelo((ProdutoEtiquetaModelo)this.cbbProdutoEtiquetaModelo.getSelectionModel().getSelectedItem());
        this.conf.setImpressoraEtiqueta((String)this.cbbImpressoraEtiqueta.getSelectionModel().getSelectedItem());
        this.conf.setImpressoraCaixaSpooler((String)this.cbbImpressoraCaixaSpooler.getSelectionModel().getSelectedItem());
        this.conf.setVendaProdutoComprovanteTipo((VendaProdutoComprovanteTipo)this.cbbVendaProdutoComprovante.getSelectionModel().getSelectedItem());
        this.conf.setVendaProdutoComprovanteA4Tipo((VendaProdutoComprovanteA4Tipo)this.cbbVendaProdutoComprovanteA4.getSelectionModel().getSelectedItem());
        this.conf.setVendaProdutoComprovanteReciboEntrega(this.txtVendaProdutoComprovanteReciboEntrega.getText());
        this.conf.setBancoBoleto((BancoBoleto)this.cbbFinanceiroBancoBoleto.getSelectionModel().getSelectedItem());
        this.conf.setFixarDataRecebimento(Boolean.valueOf(this.cbbFixarDataRecebimento.isSelected()));
        this.conf.setSenhaFechamentoCaixa(this.tfSenhaFechamentoCaixa.getText());
        this.conf.setCaminhoNFeEntrada(MaximaUtils.getText((String)this.tfNfeEntradaXml.getText()));
        this.conf.setEntradaProdutoCaixa(Boolean.valueOf(this.ccbEntradaProdutoCaixa.isSelected()));
        this.conf.setEntradaAlteraValores(Boolean.valueOf(this.ccbEntradaValores.isSelected()));
        this.conf.setFixarMargemProduto(Boolean.valueOf(this.ccbFixarMargem.isSelected()));
        this.conf.setSatCnpjSoftwareHouse(MaximaUtils.removeCaracteres((String)this.tfSatCnpjSoftwareHouse.getText()));
        this.conf.setSatSenha(MaximaUtils.getText((String)this.tfSatCodigoAtivacao.getText()));
        this.conf.setCaminhoSAT(MaximaUtils.getText((String)this.tfSatPathXml.getText()));
        this.conf.setSatChaveAssinada(MaximaUtils.getText((String)this.tfSatAssinatura.getText()));
        this.conf.setContador((Contador)this.cbbContador.getSelectionModel().getSelectedItem());
        this.conf.setCaminhoNFe(MaximaUtils.getText((String)this.tfNfeDiretorio.getText()));
        this.conf.setNfeNaturezaOperacao(MaximaUtils.getText((String)this.tfNfeNaturezaOperacao.getText()));
        this.conf.setInfContNfe(MaximaUtils.getText((String)this.tfNfeInfAddCont.getText()));
        this.conf.setExibirImpostoIBPT(Boolean.valueOf(this.ccbNfeIbpt.isSelected()));
        this.conf.setEmailHost(MaximaUtils.getText((String)this.tfEmailHost.getText()));
        this.conf.setEmailPorta(MaximaUtils.getText((String)this.tfEmailPorta.getText()));
        this.conf.setEmail(MaximaUtils.getText((String)this.tfEmail.getText()));
        this.conf.setEmailSenha(MaximaUtils.getText((String)this.tfEmailSenha.getText()));
        this.conf.setComandaExibirOcupadas(Boolean.valueOf(this.ccbComandaOcupada.isSelected()));
        this.conf.setComandaFechamentoImpresso(Boolean.valueOf(this.ccbComandaImpressa.isSelected()));
        this.conf.setComandaImpressoraTransferencia((DepartamentoImpressora)this.cbbComandaImpressoraTransferencia.getSelectionModel().getSelectedItem());
        this.conf.setFoodExigirAutorizacao(Boolean.valueOf(this.ccbComandaExigeAutorizacao.isSelected()));
        this.conf.setDeliveryImprimirCaixa(Boolean.valueOf(this.cbbDeliveryImprimirCaixa.isSelected()));
        this.conf.setTipoPrecoPizza((TipoPrecoPizza)this.cbbTipoPrecoPizza.getSelectionModel().getSelectedItem());
        this.conf.setImprimirItemIndividual(Boolean.valueOf(this.ccbImprimirIndividual.isSelected()));
        this.conf.setMensagemComandaIndividual(this.tfMensagemComanda.getText().trim());
        this.conf.setMovimentoCaixaImprimeProdutos(Boolean.valueOf(this.ccbMovimentoCaixaImprimeProdutos.isSelected()));
        this.conf.setMovimentoCaixaImprimeVendas(Boolean.valueOf(this.ccbMovimentoCaixaImprimeVendas.isSelected()));
        this.conf.setMovimentoCaixaImprimeOutrosRecebimentos(Boolean.valueOf(this.ccbMovimentoCaixaImprimeOutrosRecebimentos.isSelected()));
        this.conf.setCancelamentoSenha(this.tfCancelamentoSenha.getText());
        this.conf.setExigirMotivoCancelamento(Boolean.valueOf(this.ccbMotivoCancelamento.isSelected()));
        this.conf.setImprimirComanda(Boolean.valueOf(this.ccbImprimirComanda.isSelected()));
        this.conf.setAgruparItensImpressao(Boolean.valueOf(this.ccbAgruparImpressao.isSelected()));
        this.conf.setEtiquetaParcelas(MaximaNumber.quantidadeToBigDecimal((String)this.tfEtiquetaParcelas.getText()));
        try {
            this.conf = this.configuracaoService.save(this.conf);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Configura\u00e7\u00e3o salva com sucesso.\nReinicie o sistema para aplica\u00e7\u00e3o das altera\u00e7\u00f5es.");
        }
        catch (MaximaException ex) {
            Logger.getLogger(ConfiguracaoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: " + ex.getMessage()));
        }
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnClientePesquisa.setGraphic((Node)maximaIcone.getPesquisa());
    }

    private void loadCombos() {
        ArrayList bancoBoletos = new ArrayList();
        bancoBoletos.add(null);
        bancoBoletos.addAll(this.bancoBoletoService.list());
        this.cbbFinanceiroBancoBoleto.setItems(FXCollections.observableArrayList(bancoBoletos));
        this.cbbCentroCustoVenda.setItems(FXCollections.observableArrayList((Collection)this.centroCustoService.combo()));
        this.cbbContador.setItems(FXCollections.observableArrayList((Collection)this.contadorService.list("")));
        this.cbbImpressaoImpressora.setItems(FXCollections.observableArrayList((Object[])ImpressoraModelo.values()));
        this.cbbProdutoEtiquetaModelo.setItems(FXCollections.observableArrayList((Object[])ProdutoEtiquetaModelo.values()));
        this.cbbVendaProdutoComprovante.setItems(FXCollections.observableArrayList((Object[])VendaProdutoComprovanteTipo.values()));
        this.cbbVendaProdutoComprovanteA4.setItems(FXCollections.observableArrayList((Object[])VendaProdutoComprovanteA4Tipo.values()));
        this.cbbTipoPrecoPizza.setItems(FXCollections.observableArrayList((Object[])TipoPrecoPizza.values()));
        PrintService[] impressoras = PrintServiceLookup.lookupPrintServices(null, null);
        ArrayList<String> listaImpressoras = new ArrayList<String>();
        for (PrintService printService : impressoras) {
            listaImpressoras.add(printService.getName());
        }
        this.cbbImpressoraEtiqueta.setItems(FXCollections.observableArrayList(listaImpressoras));
        this.cbbImpressoraCaixaSpooler.setItems(FXCollections.observableArrayList(listaImpressoras));
        this.cbbComandaImpressoraTransferencia.setItems(FXCollections.observableArrayList((Collection)this.departamentoImpressoraService.listaCombo()));
    }

    private void setMascaras() {
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.save());
        this.btnClientePesquisa.setOnAction(evt -> this.pesquisaClienteForm());
    }

    private void pesquisaClienteForm() {
        Cliente clientePesquisa = new ClientePesquisaForm().getCliente(this.stageManager, this.btnClientePesquisa.getScene(), "");
        if (clientePesquisa != null) {
            this.cliente = clientePesquisa;
            this.tfClientePadrao.setText(this.cliente.getNome().toUpperCase());
        }
    }
}

