/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.administrativo.controller;

import br.com.maximasolutions.administrativo.modelo.Usuario;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.administrativo.service.ValidacaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.controller.ValidacaoController;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.view.FxmlView;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class LoginController
extends MaximaController
implements Initializable {
    @FXML
    private Button btnLogin;
    @FXML
    private PasswordField password;
    @FXML
    private TextField username;
    @FXML
    private Label lblLogin;
    @FXML
    private ImageView imgLogo;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private UsuarioService usuarioService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private ValidacaoService validacaoService;

    private void efetuaLogin() {
        new ValidacaoController().validaAtivacao(this.stageManager, this.configuracaoService, this.validacaoService);
        Scene scene = this.stageManager.getStage().getScene();
        scene.getStylesheets().add((Object)this.getClass().getResource("/styles/Styles.css").toExternalForm());
        Usuario usuario = this.usuarioService.authenticate(this.getUsername(), this.getPassword());
        if (usuario != null) {
            this.stageManager.setUsuario(usuario);
            this.stageManager.switchScene(FxmlView.PRINCIPAL);
        } else {
            this.lblLogin.setText("Usu\u00e1rio e/ou senha inv\u00e1lidos.");
        }
    }

    public String getPassword() {
        return this.password.getText();
    }

    public String getUsername() {
        return this.username.getText();
    }

    public void initialize(URL location, ResourceBundle resources) {
        Image image = new Image(this.getClass().getResourceAsStream("/images/maximasoft.png"));
        this.imgLogo.setImage(image);
        this.registraAcoes();
    }

    private void registraAcoes() {
        this.btnLogin.setOnAction(t -> this.efetuaLogin());
        this.username.setOnKeyPressed(t -> {
            if (t.getCode() == KeyCode.ENTER) {
                this.password.requestFocus();
                this.password.selectAll();
            }
        });
        this.password.setOnKeyPressed(t -> {
            if (t.getCode() == KeyCode.ENTER) {
                this.efetuaLogin();
            }
        });
    }
}

