/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.administrativo.controller;

import br.com.maximasolutions.administrativo.modelo.Usuario;
import br.com.maximasolutions.administrativo.modelo.UsuarioPerfil;
import br.com.maximasolutions.administrativo.service.UsuarioPerfilService;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class UsuarioFormController
extends MaximaController
implements Initializable {
    @FXML
    private TextField tfNome;
    @FXML
    private TextField tfLogin;
    @FXML
    private TextField tfDesconto;
    @FXML
    private PasswordField tfSenha;
    @FXML
    private ComboBox<UsuarioPerfil> cbbPerfil;
    @FXML
    private Button btnSalva;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private UsuarioService usuarioService;
    @Autowired
    private UsuarioPerfilService perfilService;
    private Usuario usuario;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.carregaCombos();
    }

    private void salva() {
        if (this.usuario == null) {
            this.usuario = new Usuario();
            this.usuario.setAtivo(Boolean.TRUE);
        }
        this.usuario.setNome(this.tfNome.getText().trim().toUpperCase());
        this.usuario.setLogin(this.tfLogin.getText().trim());
        this.usuario.setSenha(this.tfSenha.getText().trim());
        this.usuario.setUltimaAlteracao(LocalDateTime.now());
        this.usuario.setPerfil((UsuarioPerfil)this.cbbPerfil.getSelectionModel().getSelectedItem());
        this.usuario.setLimiteDesconto(MaximaNumber.moneyToBigDecimal((String)this.tfDesconto.getText()));
        if (!this.validaForm()) {
            return;
        }
        try {
            this.usuarioService.save(this.usuario);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Usu\u00e1rio salvo com sucesso.");
            Stage stage = (Stage)this.tfNome.getScene().getWindow();
            stage.close();
        }
        catch (MaximaException ex) {
            Logger.getLogger(UsuarioFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Erro: " + ex.getMessage()));
        }
    }

    public void inicializa(Usuario usuario1) {
        this.usuario = usuario1;
        if (this.usuario != null) {
            this.tfNome.setText(this.usuario.getNome());
            this.tfLogin.setText(this.usuario.getLogin());
            this.tfSenha.setText(this.usuario.getSenha());
            this.cbbPerfil.getSelectionModel().select((Object)this.usuario.getPerfil());
            this.tfDesconto.setText(MaximaNumber.formataNumero((BigDecimal)this.usuario.getLimiteDesconto()));
            this.tfNome.selectAll();
            this.tfNome.requestFocus();
        }
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.usuario.getNome() == null || this.usuario.getNome().isEmpty()) {
            this.tfNome.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfNome.getStyleClass().remove((Object)"error");
        }
        if (this.usuario.getPerfil() == null) {
            valido = false;
            this.cbbPerfil.getStyleClass().add((Object)"error");
        } else {
            this.cbbPerfil.getStyleClass().remove((Object)"error");
        }
        if (this.usuario.getLogin() == null || this.usuario.getLogin().length() < 5) {
            valido = false;
            this.tfLogin.getStyleClass().add((Object)"error");
        } else {
            this.tfLogin.getStyleClass().remove((Object)"error");
        }
        if (this.usuario.getSenha() == null || this.usuario.getSenha().length() < 4) {
            valido = false;
            this.tfSenha.getStyleClass().add((Object)"error");
        } else {
            this.tfSenha.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private void carregaCombos() {
        this.cbbPerfil.setItems(FXCollections.observableArrayList((Collection)this.perfilService.list()));
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
        MaximaMask.monetaryField((TextField)this.tfDesconto);
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.salva());
    }
}

