/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.administrativo.controller;

import br.com.maximasolutions.administrativo.controller.UsuarioPerfilFormController;
import br.com.maximasolutions.administrativo.core.PermissaoControleValida;
import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.modelo.PermissaoControleAcao;
import br.com.maximasolutions.administrativo.modelo.UsuarioPerfil;
import br.com.maximasolutions.administrativo.service.UsuarioPerfilService;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class UsuarioPerfilController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private Button btnNovo;
    @FXML
    private Button btnEdita;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnAtualiza;
    @FXML
    private TableView<UsuarioPerfil> tabela;
    @FXML
    private TableColumn<UsuarioPerfil, String> colNome;
    @Autowired
    private UsuarioPerfilService usuarioPerfilService;
    @Autowired
    private UsuarioService usuarioService;
    private ObservableList<UsuarioPerfil> usuarioPerfilList;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.usuarioPerfilList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.editaUsuarioPerfil();
            }
        });
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
    }

    public void inicializa() {
        this.acoes = this.usuarioService.acoes(this.stageManager.getUsuario(), PermissaoControle.UsuarioPerfil);
    }

    private void novoUsuarioPerfil() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.ADD).booleanValue()) {
            return;
        }
        this.formUsuarioPerfil(null);
        this.loadTabela();
    }

    private void editaUsuarioPerfil() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.EDIT).booleanValue()) {
            return;
        }
        UsuarioPerfil usuarioPerfil = (UsuarioPerfil)this.tabela.getSelectionModel().getSelectedItem();
        if (usuarioPerfil == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um usu\u00e1rio para editar.");
            return;
        }
        this.formUsuarioPerfil(usuarioPerfil);
        this.loadTabela();
    }

    private void formUsuarioPerfil(UsuarioPerfil usuarioPerfil) {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/administrativo/usuarioPerfil/UsuarioPerfilForm.fxml", "Novo Perfil");
            UsuarioPerfilFormController controller = (UsuarioPerfilFormController)stage.getUserData();
            controller.inicializa(usuarioPerfil);
            stage.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(UsuarioPerfilController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao abrir form perfil.\n" + ex.getMessage()));
        }
    }

    private void deleteUsuarioPerfil() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.DELETE).booleanValue()) {
            return;
        }
        UsuarioPerfil usuarioPerfil = (UsuarioPerfil)this.tabela.getSelectionModel().getSelectedItem();
        if (usuarioPerfil == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um perfil para remover.");
            return;
        }
        if (MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)("Deseja remover o perfil: '" + usuarioPerfil.getNome() + "'?"))) {
            this.usuarioPerfilService.deleteById(usuarioPerfil.getId());
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Perfil deletado com sucesso.");
        }
        this.loadTabela();
    }

    private void loadTabela() {
        this.usuarioPerfilList.clear();
        this.usuarioPerfilList.addAll((Collection)this.usuarioPerfilService.list());
        this.tabela.setItems(this.usuarioPerfilList);
    }

    private void carregaIcones() {
        this.btnNovo.setGraphic((Node)new MaximaIcone().getIconeNovo());
        this.btnEdita.setGraphic((Node)new MaximaIcone().edita());
        this.btnDelete.setGraphic((Node)new MaximaIcone().getIconeDelete());
        this.btnAtualiza.setGraphic((Node)new MaximaIcone().getIconeAtualiza());
    }

    private void setColumnProperties() {
        this.colNome.setCellValueFactory((Callback)new PropertyValueFactory("nome"));
    }

    private void registraAcoes() {
        this.btnNovo.setOnAction(event -> this.novoUsuarioPerfil());
        this.btnEdita.setOnAction(event -> this.editaUsuarioPerfil());
        this.btnDelete.setOnAction(event -> this.deleteUsuarioPerfil());
        this.btnAtualiza.setOnAction(event -> this.loadTabela());
    }
}

