/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.administrativo.controller;

import br.com.maximasolutions.administrativo.controller.UsuarioPerfilItemFormController;
import br.com.maximasolutions.administrativo.modelo.UsuarioPerfil;
import br.com.maximasolutions.administrativo.modelo.UsuarioPerfilItem;
import br.com.maximasolutions.administrativo.service.UsuarioPerfilService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import java.io.IOException;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class UsuarioPerfilFormController
extends MaximaController
implements Initializable {
    @FXML
    private TextField tfNome;
    @FXML
    private Button btnSalva;
    @FXML
    private Button btnAdd;
    @FXML
    private TableView<UsuarioPerfilItem> tabela;
    @FXML
    private TableColumn<UsuarioPerfilItem, String> colPerfil;
    @FXML
    private TableColumn<UsuarioPerfilItem, String> colAcoes;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private UsuarioPerfilService usuarioPerfilService;
    private UsuarioPerfil perfil;
    private List<UsuarioPerfilItem> controles;

    public void initialize(URL url, ResourceBundle rb) {
        this.perfil = null;
        this.carregaIcones();
        this.registraAcoes();
        this.carregaCombos();
        this.setColumnProperties();
    }

    private void salva() {
        if (this.perfil == null) {
            this.perfil = new UsuarioPerfil();
            this.perfil.setAtivo(Boolean.TRUE);
        }
        this.perfil.setNome(this.tfNome.getText().trim().toUpperCase());
        this.perfil.setUltimaAlteracao(LocalDateTime.now());
        if (!this.validaForm()) {
            return;
        }
        try {
            System.out.println("");
            this.usuarioPerfilService.save(this.perfil, this.controles);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Perfil salvo com sucesso.");
            Stage stage = (Stage)this.tfNome.getScene().getWindow();
            stage.close();
        }
        catch (MaximaException ex) {
            Logger.getLogger(UsuarioPerfilFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Erro: " + ex.getMessage()));
        }
    }

    public void inicializa(UsuarioPerfil perfil1) {
        this.perfil = perfil1;
        if (this.perfil != null) {
            this.controles = this.usuarioPerfilService.lista(this.perfil);
            if (this.controles != null) {
                for (UsuarioPerfilItem item : this.controles) {
                    item.setAcoes(this.usuarioPerfilService.permissaoControleAcaos(item));
                }
            }
            this.tfNome.setText(this.perfil.getNome());
            this.tfNome.selectAll();
            this.tfNome.requestFocus();
        } else {
            this.controles = new ArrayList();
        }
        this.loadTabela();
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.perfil.getNome() == null || this.perfil.getNome().isEmpty()) {
            this.tfNome.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfNome.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private void carregaCombos() {
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
        this.btnAdd.setGraphic((Node)new MaximaIcone().getIconeNovo());
    }

    private void loadTabela() {
        ArrayList lista = new ArrayList();
        this.controles.forEach(obj -> {
            if (!obj.getExcluida().booleanValue()) {
                lista.add(obj);
            }
        });
        this.tabela.setItems(FXCollections.observableArrayList(lista));
    }

    private void setColumnProperties() {
        this.colPerfil.setCellValueFactory((Callback)new PropertyValueFactory("controle"));
        this.colAcoes.setCellValueFactory((Callback)new PropertyValueFactory("descricao"));
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.salva());
        this.btnAdd.setOnAction(evt -> this.addControle());
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.editaControle();
            }
        });
        this.tabela.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.DELETE) {
                this.deleteControle();
            }
        });
    }

    private void addControle() {
        this.formControle(null);
        this.loadTabela();
    }

    private void editaControle() {
        UsuarioPerfilItem selecionado = (UsuarioPerfilItem)this.tabela.getSelectionModel().getSelectedItem();
        if (selecionado == null) {
            return;
        }
        this.formControle(selecionado);
        this.loadTabela();
    }

    private void deleteControle() {
        UsuarioPerfilItem selecionado = (UsuarioPerfilItem)this.tabela.getSelectionModel().getSelectedItem();
        if (selecionado == null) {
            return;
        }
        for (UsuarioPerfilItem item : this.controles) {
            if (!selecionado.getControle().equals((Object)item.getControle())) continue;
            item.setExcluida(Boolean.TRUE);
            break;
        }
        this.loadTabela();
    }

    private void formControle(UsuarioPerfilItem item) {
        try {
            Stage form = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/administrativo/usuarioPerfil/UsuarioPerfilItemForm.fxml", "Cadastro Controle");
            UsuarioPerfilItemFormController controller = (UsuarioPerfilItemFormController)form.getUserData();
            controller.inicializa(item, this.controles);
            form.showAndWait();
            UsuarioPerfilItem retorno = controller.getPerfilItem();
            if (retorno != null && retorno.getId() == null) {
                boolean existe = false;
                for (UsuarioPerfilItem i : this.controles) {
                    if (!retorno.getControle().equals((Object)i.getControle())) continue;
                    existe = true;
                    break;
                }
                if (!existe) {
                    this.controles.add(retorno);
                } else {
                    MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: N\u00e3o pode adicionar esse m\u00f3dulo.\nMenu j\u00e1 configurado.");
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(UsuarioPerfilFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: N\u00e3o foi poss\u00edvel abrir o form.");
        }
    }
}

