/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.administrativo.controller;

import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.modelo.PermissaoControleAcao;
import br.com.maximasolutions.administrativo.modelo.UsuarioPerfilItem;
import br.com.maximasolutions.administrativo.service.UsuarioPerfilService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class UsuarioPerfilItemFormController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private UsuarioPerfilService perfilService;
    @FXML
    private ComboBox<PermissaoControle> cbbControle;
    @FXML
    private Button btnSalva;
    @FXML
    private Pane paneAcoes;
    private List<CheckBox> cbAcoes;
    private UsuarioPerfilItem perfilItem;
    private List<PermissaoControleAcao> acoesSelecionadas;
    private List<UsuarioPerfilItem> controles;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
    }

    public void inicializa(UsuarioPerfilItem perfilItem, List<UsuarioPerfilItem> controles) {
        this.cbAcoes = new ArrayList();
        this.acoesSelecionadas = new ArrayList();
        this.perfilItem = perfilItem;
        ArrayList<PermissaoControle> comboControle = new ArrayList<PermissaoControle>();
        if (this.perfilItem != null) {
            this.cbbControle.getSelectionModel().select((Object)this.perfilItem.getControle());
            this.acoesSelecionadas = this.perfilService.permissaoControleAcaos(perfilItem);
            this.loadAcoes(this.perfilItem.getControle(), this.acoesSelecionadas);
            comboControle.add(this.perfilItem.getControle());
        } else {
            for (PermissaoControle cont : PermissaoControle.values()) {
                if (controles == null || controles.isEmpty()) {
                    comboControle.add(cont);
                    continue;
                }
                boolean existe = false;
                for (UsuarioPerfilItem item : controles) {
                    if (!item.getControle().equals((Object)cont)) continue;
                    existe = true;
                    break;
                }
                if (existe) continue;
                comboControle.add(cont);
            }
        }
        this.carregaCombos(comboControle);
    }

    public UsuarioPerfilItem getPerfilItem() {
        return this.perfilItem;
    }

    private void salva() {
        if (!this.validaForm()) {
            return;
        }
        if (this.perfilItem == null) {
            this.perfilItem = new UsuarioPerfilItem();
        }
        this.perfilItem.setControle((PermissaoControle)this.cbbControle.getSelectionModel().getSelectedItem());
        this.acoesSelecionadas = new ArrayList();
        String descricao = "";
        for (CheckBox cb : this.cbAcoes) {
            if (!cb.isSelected()) continue;
            PermissaoControleAcao acao = PermissaoControleAcao.valueOf((String)cb.getId());
            this.acoesSelecionadas.add(acao);
            if (!descricao.isEmpty()) {
                descricao = descricao + " | ";
            }
            descricao = descricao + acao.toString();
        }
        this.perfilItem.setDescricao(descricao);
        this.perfilItem.setAcoes(this.acoesSelecionadas);
        this.fechar();
    }

    private boolean validaForm() {
        boolean valido = true;
        PermissaoControle controle = (PermissaoControle)this.cbbControle.getSelectionModel().getSelectedItem();
        if (controle == null) {
            this.cbbControle.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.cbbControle.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private void carregaCombos(List<PermissaoControle> controles) {
        this.cbbControle.setItems(FXCollections.observableArrayList(controles));
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.salva());
        this.cbbControle.valueProperty().addListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void loadAcoes(PermissaoControle controle, List<PermissaoControleAcao> selecionadas) {
        this.paneAcoes.getChildren().clear();
        if (controle == null) {
            return;
        }
        int margemEsquerda = 20;
        int margemTop = 20;
        this.cbAcoes = new ArrayList();
        for (PermissaoControleAcao ac : controle.getAcoes()) {
            boolean selecionada = false;
            if (selecionadas != null) {
                for (PermissaoControleAcao a : selecionadas) {
                    if (!ac.equals((Object)a)) continue;
                    selecionada = true;
                    break;
                }
            }
            CheckBox cb = new CheckBox();
            cb.setText(ac.toString());
            cb.setLayoutX((double)margemEsquerda);
            cb.setLayoutY((double)margemTop);
            cb.setId(ac.toString());
            cb.setSelected(selecionada);
            this.paneAcoes.getChildren().add((Object)cb);
            this.cbAcoes.add(cb);
            margemTop += 30;
        }
    }

    private void fechar() {
        Stage form = (Stage)this.btnSalva.getScene().getWindow();
        form.close();
    }

    static /* synthetic */ void access$000(UsuarioPerfilItemFormController x0, PermissaoControle x1, List x2) {
        x0.loadAcoes(x1, x2);
    }
}

