/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.administrativo.controller;

import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class WorkIndicatorDialog<P> {
    private Task animationWorker;
    private Task<Integer> taskWorker;
    private final ProgressIndicator progressIndicator = new ProgressIndicator(-1.0);
    private final Stage dialog = new Stage(StageStyle.UNDECORATED);
    private final Label label = new Label();
    private final Group root = new Group();
    private final Scene scene = new Scene((Parent)this.root, 330.0, 120.0, (Paint)Color.WHITE);
    private final BorderPane mainPane = new BorderPane();
    private final VBox vbox = new VBox();
    public ObservableList<Integer> resultNotificationList = FXCollections.observableArrayList();
    public Integer resultValue;

    public WorkIndicatorDialog(Window owner, String label) {
        this.dialog.initModality(Modality.WINDOW_MODAL);
        this.dialog.initOwner(owner);
        this.dialog.setResizable(false);
        this.label.setText(label);
    }

    public void addTaskEndNotification(Consumer<Integer> c) {
        this.resultNotificationList.addListener(n -> {
            this.resultNotificationList.clear();
            c.accept(this.resultValue);
        });
    }

    public void exec(P parameter, ToIntFunction func) {
        this.setupDialog();
        this.setupAnimationThread();
        this.setupWorkerThread(parameter, func);
    }

    private void setupDialog() {
        this.root.getChildren().add((Object)this.mainPane);
        this.vbox.setSpacing(5.0);
        this.vbox.setAlignment(Pos.CENTER);
        this.vbox.setMinSize(330.0, 120.0);
        this.vbox.getChildren().addAll((Object[])new Node[]{this.label, this.progressIndicator});
        this.mainPane.setTop((Node)this.vbox);
        this.dialog.setScene(this.scene);
        this.dialog.setOnHiding(event -> {});
        this.dialog.show();
    }

    private void setupAnimationThread() {
        this.animationWorker = new /* Unavailable Anonymous Inner Class!! */;
        this.progressIndicator.setProgress(0.0);
        this.progressIndicator.progressProperty().unbind();
        this.progressIndicator.progressProperty().bind((ObservableValue)this.animationWorker.progressProperty());
        this.animationWorker.messageProperty().addListener((observable, oldValue, newValue) -> {});
        new Thread((Runnable)this.animationWorker).start();
    }

    private void setupWorkerThread(P parameter, ToIntFunction<P> func) {
        this.taskWorker = new /* Unavailable Anonymous Inner Class!! */;
        EventHandler eh = event -> {
            this.animationWorker.cancel(true);
            this.progressIndicator.progressProperty().unbind();
            this.dialog.close();
            try {
                this.resultValue = (Integer)this.taskWorker.get();
                this.resultNotificationList.add((Object)this.resultValue);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        };
        this.taskWorker.setOnSucceeded(eh);
        this.taskWorker.setOnFailed(eh);
        new Thread((Runnable)this.taskWorker).start();
    }

    public Integer getResultValue() {
        return this.resultValue;
    }
}

